package LCM::Gui::App::LCMGuiAppExternall;

use strict;
use LCM::Gui::Dialogs::UpdateHosts::ProgressHandler;
use base qw ( LCM::Gui::App::LCMGuiApp );

sub createActionConfiguration {
	my ( $self, ) = @_;

	require LCM::Configuration::HdbLcmExternalActionConfiguration;
	my $config = LCM::Configuration::HdbLcmExternalActionConfiguration->new( $self->{options}, $self->{configfile} );
	
	return $config;
}

sub createExecutor {
	my ($self, $action) = @_;
    if ($self->isHelp()) {
        require LCM::Task::HelpProcessTask;
        return LCM::Task::HelpProcessTask->new($self->getInstconfig(), $self);
    }
    return undef;
}

sub createConfiguration {
	my ($self, $action) = @_;

	my $config;
	my $actionConfig = $self->getActionConfiguration();
	require LCM::Configuration::GenericStackConfigurationFactory;
	if ( 'install' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createInstallConfiguration($self);
	} elsif ( 'update' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createUpdateConfiguration($self);
	}
	if (defined $config) {
		$actionConfig->getComponentManager()->setSystemComponentManager(undef);
		$config->setComponentManager( $actionConfig->getComponentManager() ) ;
	}
# Added because of TIPHANA15IT10-2040
# a 'kit' property is needed in the CollectOtherHostInfos
# method in AnyConfig in case of non-resident hdblcm
	if (defined $actionConfig->{kit}) {
		$config->{kit} = $actionConfig->{kit};
	}
	return $config;
}

1;
