package LCM::Gui::Controllers::ControllersFactory;

use strict;
use parent qw(Exporter);
use SDB::Install::Configuration qw($bool_true_pattern);
use LCM::Configuration::GenericStackAny qw(INSTALL_ACTION UPDATE_ACTION);

my $SIMPLE_UI_PARAM_ID = 'UseSimpleUI';
our @EXPORT = qw(CreateControllerForScenario);

sub CreateControllerForScenario {
    my ($scenario, $configuration, $wizard) = @_;
    my $isUsingSimpleMode = !$configuration->isSkipped($SIMPLE_UI_PARAM_ID) && $configuration->getBatchValue($SIMPLE_UI_PARAM_ID) =~ /$bool_true_pattern/;

    if ($scenario eq INSTALL_ACTION && $isUsingSimpleMode) {
        require LCM::Gui::Controllers::SimpleInstallController;
        return new LCM::Gui::Controllers::SimpleInstallController($configuration, $wizard);
    } elsif ($scenario eq INSTALL_ACTION) {
        require LCM::Gui::Controllers::InstallController;
        return new LCM::Gui::Controllers::InstallController($configuration, $wizard);
    } elsif ($scenario eq UPDATE_ACTION) {
        require LCM::Gui::Controllers::UpdateController;
        return new LCM::Gui::Controllers::UpdateController($configuration, $wizard);
    }
    return undef;
}

1;
