package LCM::Gui::Controllers::InstallController;

use strict;
use base 'LCM::Gui::Controllers::Controller';

use SDB::Install::SysVars qw ($isWin);
use LCM::Gui::PagePredicates qw (	ShouldSkipCertificatesDialog
									ShouldSkipUserProperties
									ShouldSkipStreamingPropertiesPage
									ShouldSkipEsStoragePage
									ShouldSkipAcceleratorPropertiesPage
									ShouldSkipRDSyncPropertiesPage
									ShouldSkipXSPropertiesPage
									ShouldSkipXSSpaceIsolationPropertiesPage
									ShouldSkipSelectXSApplicationsPage
									ShouldSkipSelectedComponentsDialog
									ShouldSkipMasterPassword
									ShouldSkipSQLUserProperties
									ShouldSkipLSSPropertiesDialog);


sub getCondensedSteps {
	my $self = shift;
	my $wizard = $self->getWizard();

	my @distSystem = $isWin ? () : (new LCM::Gui::Dialogs::DistributedSystemParamsDialog ($wizard));
	my @condensedSteps = (
		@distSystem,
		new LCM::Gui::Dialogs::AdditionalSystemDialog ($wizard),
		new SDB::Install::Gui::Dialogs::VolumePaths ($wizard),
		new LCM::Gui::Dialogs::CertificatesDialog ($wizard),
		new LCM::Gui::Dialogs::MasterPasswordDialog($wizard),
		new SDB::Install::Gui::Dialogs::User ($wizard),
		new SDB::Install::Gui::Dialogs::SQLUser ($wizard),
		new LCM::Gui::Dialogs::HostagentPasswordDialog($wizard)
	);
	if($self->getConfiguration()->getComponentManager()->isInternalBuild()){
		push @condensedSteps, new LCM::Gui::Dialogs::LSSPropertiesDialog($wizard);
	}
	push @condensedSteps, (
		new LCM::Gui::Dialogs::StreamingPropertiesDialog( $wizard ),
		new LCM::Gui::Dialogs::EsStoragePropertiesDialog($wizard),
		new LCM::Gui::Dialogs::AcceleratorPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::RDSyncPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::XSPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::SelectXsComponentsDialog($wizard)
	);
	return \@condensedSteps;
}

sub getMapDialogIdToSkipPredicates {
	my ($self, ) = @_;
	return {
		"CertificatesDialog"         => sub { ShouldSkipCertificatesDialog() },
		"UserProperties"             => sub { ShouldSkipUserProperties() },
		"SHAPassword"                => sub { $self->shouldSkipSHAPassword()},
		"LSSPropertiesDialog"        => sub { ShouldSkipLSSPropertiesDialog() },
		"StreamingProperties"        => sub { ShouldSkipStreamingPropertiesPage()},
		"EsStoragePropertiesDialog"  => sub { ShouldSkipEsStoragePage() },
		"AcceleratorProperties"      => sub { ShouldSkipAcceleratorPropertiesPage()},
		'RDSyncProperties'           => sub { ShouldSkipRDSyncPropertiesPage() },
		'XSProperties'               => sub { ShouldSkipXSPropertiesPage() },
		'XSSpaceIsolationProperties' => sub { ShouldSkipXSSpaceIsolationPropertiesPage() },
		'SelectXsComponents'         => sub { ShouldSkipSelectXSApplicationsPage() },
		'SelectComponents'           => sub { ShouldSkipSelectedComponentsDialog() },
		'SQLUserProperties'          => sub { ShouldSkipSQLUserProperties() },
		'MasterPasswordProperties'   => sub { ShouldSkipMasterPassword() },
	};
}

sub shouldSkipSHAPassword {
	my ($self, ) = @_;
	my $configuration = $self->getConfiguration();
	my $isSkipped = $configuration->isSkipped('HostagentPassword') || $configuration->isHidden('HostagentPassword');
	my $hasValue = $configuration->isUseSAPHostagent() && $configuration->hasValue('HostagentPassword');

	return ($isSkipped || $hasValue) ? 1 : 0;
}

1;