package LCM::Gui::Controllers::UpdateController;

use strict;

use base 'LCM::Gui::Controllers::Controller';

use LCM::Gui::PagePredicates qw (	ShouldSkipUpgradeProperties
									ShouldSkipAdditionalHostsProperties
									ShouldSkipCertificatesDialog
									ShouldSkipStreamingPropertiesPage
									ShouldSkipEsStoragePage
									ShouldSkipAcceleratorPropertiesPage
									ShouldSkipInternalNetworkPropertiesPage
									ShouldSkipRDSyncPropertiesPage
									ShouldSkipXSPropertiesPage
									ShouldSkipXSSpaceIsolationPropertiesPage
									ShouldSkipSelectXSApplicationsPage
									ShouldSkipLSSPropertiesDialog);

sub getCondensedSteps {
	my $self = shift;
	my $wizard = $self->getWizard ();
	my @condensedSteps = (
		new LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::UpgradeParameterDialog($wizard),
		new LCM::Gui::Dialogs::CertificatesDialog($wizard),
		new LCM::Gui::Dialogs::InternalNetworkPropertiesDialog($wizard),
	);
	if($self->getConfiguration()->getComponentManager()->isInternalBuild()){
		push @condensedSteps, new LCM::Gui::Dialogs::LSSPropertiesDialog($wizard);
	}
	push @condensedSteps, (
		new LCM::Gui::Dialogs::StreamingPropertiesDialog($wizard ),
		new LCM::Gui::Dialogs::EsStoragePropertiesDialog($wizard),
		new LCM::Gui::Dialogs::AcceleratorPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::RDSyncPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::XSPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::SelectXsComponentsDialog($wizard),
	);
	return \@condensedSteps;
}

sub getMapDialogIdToSkipPredicates {
	return {
		"CertificatesDialog"  => sub{ ShouldSkipCertificatesDialog()},
		"UpgradeProperties"   => sub{ ShouldSkipUpgradeProperties() },
		"HostsProperties"     => sub{ ShouldSkipAdditionalHostsProperties() },
		"LSSPropertiesDialog" => sub { ShouldSkipLSSPropertiesDialog() },
		"StreamingProperties" => sub{ ShouldSkipStreamingPropertiesPage() },
		"EsStoragePropertiesDialog" => sub{ ShouldSkipEsStoragePage() },
		"AcceleratorProperties" => sub{ShouldSkipAcceleratorPropertiesPage()},
		'InterServiceCommunicationProperties' => sub{ ShouldSkipInternalNetworkPropertiesPage() },
		'RDSyncProperties' => sub { ShouldSkipRDSyncPropertiesPage() },
		'XSProperties' => sub { ShouldSkipXSPropertiesPage() },
		'XSSpaceIsolationProperties' => sub { ShouldSkipXSSpaceIsolationPropertiesPage() },
		'SelectXsComponents' => sub { ShouldSkipSelectXSApplicationsPage() },
	};
}

1;
