package LCM::Gui::Dialogs::AddComponentSourceDialog;

use Wx qw (wxVERTICAL wxALL wxEXPAND  wxALIGN_CENTER_VERTICAL wxOK wxCANCEL wxLEFT wxDefaultPosition wxGROW wxTOP wxTAB_TRAVERSAL);
use SDB::Install::Gui::Design qw (SDBBGCOLOUR_WizardDialog);
use SAPDB::Install::Control::PathCtrl;
use strict;

our @ISA = qw (Wx::Dialog);

sub new {
	my ($class, $parent) = @_;
	my ($self) = $class->SUPER::new($parent, -1, "Choose component location", wxDefaultPosition, new Wx::Size(400,160));

	$self->SetWindowStyleFlag($self->GetWindowStyleFlag | wxTAB_TRAVERSAL);
	$self->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	
	my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
	
	my $sizer = new Wx::BoxSizer(wxVERTICAL);
	$outer_sizer->Add($sizer, 0, wxALL | wxEXPAND, 20);
	$self->{"inner_sizer"} = $sizer;
	
	my $simpleSourceLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "Select directory", 0);
   	$sizer->Add($simpleSourceLbl, 0, wxALIGN_CENTER_VERTICAL | wxLEFT ,0);

	my $pathCtrl = new SAPDB::Install::Control::PathCtrl ($self, 1, "", wxDefaultPosition, [400,-1]);
	$sizer->Add($pathCtrl, 1, wxEXPAND );
	$pathCtrl->SetFocus();
	$self->{pathCtrl} = $pathCtrl;	
	
	my $searchRecCb = new Wx::CheckBox($self, -1, "Include subdirectories");
	$self->{searchRecCb} = $searchRecCb;	
	$sizer->Add($searchRecCb);
	
	my $buttonsSizer = $self->CreateButtonSizer(wxOK | wxCANCEL);
	$sizer->Add($buttonsSizer, 0, wxEXPAND | wxGROW | wxTOP, 20);
	$self->SetSizerAndFit($outer_sizer);
	return $self;
}

sub ShowModal {
	my ($self) = @_;
	$self->{pathCtrl}->SetFocus();
	return $self->SUPER::ShowModal();
}

sub GetSelectedPath() {
	return $_[0]->{pathCtrl}->GetValue();
}

sub IsSearchRecursive() {
	return $_[0]->{searchRecCb}->IsChecked();
}