package LCM::Gui::Dialogs::AddHostRoles::AddHostRolesPropertiesDialog;

use strict;
use parent qw(SAPDB::Install::Wizard::Dialog::Base);
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD wxGROW);
use SDB::Install::Gui::Design;
use SDB::Install::Configuration qw($bool_true_pattern);
use SDB::Install::MsgLst;
use SDB::Install::Globals qw($gHostRoleCacheServer);
use LCM::Gui::Dialogs::AddHostRoles::AddHostRolesPanel;
use LCM::App::AddHostRolesUtils qw(getPossibleRolesForExistingHosts);
use experimental qw (smartmatch);
use LCM::Gui::Dialogs::UiComponentsFactory;

sub new {
    my($self) = shift()->SUPER::new(@_);
    @$self{qw(id label_text name)} = ('AddHostRolesPropertiesDialog', 'Specify Additional Roles', 'Define Additional Roles');
    return $self;
}

sub init {
    my ($self, ) = @_;

    if ( ! $self->{dialogInitialized} ) {
        my $app        = Wx::wxTheApp;
        my $instconfig = $app->{instconfig};
        $instconfig->setBatchValueOfRequiredParams('AutoInitializeServices');

        my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
        $self->SetSizer($outer_sizer);

        my $sizer = new Wx::BoxSizer(wxVERTICAL);
        $self->{sizer} = $sizer;
        $outer_sizer->Add( $sizer, 1, wxALL | wxEXPAND, 20 );

        my $is_gtk1 = Wx::wxGTK1 ();
        my $title = CreateTitle($self, 'Add Host Roles', $is_gtk1);
        $sizer->Add($title, 0);
        $sizer->AddSpacer(20);

        my $hostRolesPanel = LCM::Gui::Dialogs::AddHostRoles::AddHostRolesPanel->new($self);
        my $componentsSizer = $hostRolesPanel->addNewHostPanel( wxVERTICAL, 0, wxEXPAND, 40, wxEXPAND | wxGROW );
        $sizer->Add( $componentsSizer, 1, wxEXPAND );
        $self->{addHostRolesPanel} = $hostRolesPanel;
    }

    $self->_addExistingHostsToPanel();
    $self->SetAutoLayout(1);
    $self->{dialogInitialized} = 1;
    return {};
}

sub Process {
    my ($self,) = @_;
    my $app = Wx::wxTheApp();
    my $configuration = $app->getInstconfig();

    $configuration->resetError();
    $self->_resetAddRoles();

    if (!$self->_setAddRolesFromHostsListControl()) {
        return $self->errorState();
    }

    if (!$self->_validateRootCredentials()) {
        return $self->errorState();
    }
    if(!$self->_validateSidadmPassword()) {
        return $self->errorState();
    }
    $self->GetWizard()->RefreshSkippableDialogs();
    return {};
}

sub _validateRootCredentials {
    my ($self, ) = @_;
    return ( ! $self->_validateRootUser() or ! $self->_validateRootPassword() ) ? undef : 1;
}

sub _resetAddRoles {
    my ($self) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    my $addRolesParamValues = $instconfig->{params}->{AddRoles}->{value};
    for my $host (keys(%$addRolesParamValues)) {
        delete $instconfig->{params}->{AddRoles}->{value}->{$host};
    }
}

sub OnListItemsUpdated {
    my ($self, ) = @_;
    $self->{isAddRolesParamaterSet} = 0;
}

sub Back{ $_[0]->Reset(); }

sub Reset {
    my ($self) = @_;
    defined($self->GetSizer()) && $self->GetSizer()->Clear(1);
    delete($self->{_uiControls});
    $self->SUPER::Reset();
}

sub Destroy {
    my ($self) = @_;
    $self->Reset();
    $self->SUPER::Destroy();
}

sub DESTROY {
    my ($self) = @_;
    print ">>>>> destroying $self\n" if $SAPDB::Install::DEBUG::DESTRUCT;
}

sub errorState {
    my ( $self ) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
    $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
    return undef;
}

sub _setAddRolesFromHostsListControl {
    my ($self) = @_;
    my $hostsList = $self->{Controls}->{'HostsList'};
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    my $numberOfHosts = $hostsList->GetItemCount();
    my $mHostToValidAdditionalRoles = getPossibleRolesForExistingHosts($instconfig);

    my $numberOfHostsWithNewRoles = 0;
    for my $index (0 .. ($numberOfHosts-1)) {
        my $item = LCM::Gui::Dialogs::HostsPanel::GetListItem($self, $index);
        my ($host, $roles) = ($item->{host}, $item->{role});
        my $aValidAdditionalRoles = $mHostToValidAdditionalRoles->{$host};
        my @newRoles = grep ($_ ~~ @$aValidAdditionalRoles, split(",", $roles));
        next if (! scalar(@newRoles));

        $numberOfHostsWithNewRoles++;
        my $newRolesCsv = join(",", @newRoles);
        if (!$instconfig->setMapValueItem('AddRoles', $host, $newRolesCsv)) {
            $hostsList->SetFocus();
            return 0;
        }
    }
    if (!$numberOfHostsWithNewRoles) {
        $instconfig->AddError("There must be at least one new role added proceed!");
        $hostsList->SetFocus();
        return 0;
    }
    if(!$instconfig->checkAllMapValues('AddRoles')){
        $instconfig->AddError($instconfig->getErrMsgLst());
        $hostsList->SetFocus();
        return 0;
    }
    return 1;
}

# Handles batch values as well
sub _addExistingHostsToPanel {
    my ($self) = @_;
    my $app        = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
    my $addHostRolesPanel = $self->{addHostRolesPanel};

    my $ownInstance = $instconfig->getOwnInstance();
    my $hostRolesInfo = $ownInstance->getHostRolesInfo();

    my $mAddRolesValue = $instconfig->getValueOrBatchValue('AddRoles');
    my $oldContext = $instconfig->setMsgLstContext([new SDB::Install::MsgLst(), new SDB::Install::MsgLst()]);

    for my $host (keys %$hostRolesInfo) {
        my $csvRoles = join(',', split(' ', $hostRolesInfo->{$host}));
# Prevent autovivification
        my $batchValueRoles = (exists $mAddRolesValue->{$host}) ? $mAddRolesValue->{$host} : undef;
        if (defined $batchValueRoles && length($batchValueRoles)) {
            my @filteredBatchRoles = grep { $_ ne $gHostRoleCacheServer } split(',', $batchValueRoles);
            my @validBatchRoles = grep { $instconfig->checkRole($_) } @filteredBatchRoles;
            $csvRoles = join(',', $csvRoles, $batchValueRoles) if @validBatchRoles;
        }
        my $hostObj = {
            host => $host,
            role => $csvRoles,
        };
        $addHostRolesPanel->addHost( new LCM::AdditionalHostHelper($hostObj) );
    }
    $instconfig->setMsgLstContext($oldContext);
}

sub _validateRootUser {
    my ($self, ) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    if ( $instconfig->isSkipped('RootUser') ) {
        return 1;
    }

    my $rootUserCtrl = $self->{Controls}->{'RootUser'};
    my $rootUser = $rootUserCtrl->GetValue();

    if ( ! defined $rootUser or $rootUser eq '' ) {
        $instconfig->AddError("Root user is a mandatory field!");
        $rootUserCtrl->SetFocus();
        return undef;
    }

    if ( ! $instconfig->setValue('RootUser', $rootUser) ) {
        $rootUserCtrl->SetFocus();
        return undef;
    }

    return 1;
}

sub _validateRootPassword {
    my ($self, ) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    if ( $instconfig->isSkipped('RootPassword') ) {
        return 1;
    }

    my $rootPassCtrl = $self->{Controls}->{'RootPassword'};
    my $rootPass = $rootPassCtrl->GetValue();

    if ( ! $instconfig->setValue('RootPassword', $rootPass) ) {
        $rootPassCtrl->SetFocus();
        return undef;
    }

    return 1;
}

sub _validateSidadmPassword {
    my ($self, ) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    my $sidadmPasswordCtrl = $self->{Controls}->{'Password'};
    my $sidadmPassword = $sidadmPasswordCtrl->GetValue();

    if ( ! defined $sidadmPassword or $sidadmPassword eq '' ) {
        my $passwordStr = $instconfig->getString('Password');
        $instconfig->AddError("$passwordStr is empty");
        $sidadmPasswordCtrl->SetFocus();
        return undef;
    }

    if ( ! $instconfig->setValue( 'Password', $sidadmPassword ) ) {
        $sidadmPasswordCtrl->SetFocus();
        return undef;
    }

    return 1;
}

1;