package LCM::Gui::Dialogs::AddHosts::AcceleratorPropertiesDialog;

use SDB::Install::Gui::Design;
use base qw (LCM::Gui::Dialogs::AcceleratorPropertiesDialog);
use strict;
use Wx qw (wxVERTICAL wxLEFT wxEXPAND wxBOTTOM wxALL);

sub init{
	my ($self,$config) = @_;
	
    my $app = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
	my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
	my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
	my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);
	
	$mainSizer->AddSpacer (20);
	$dialogTitle->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
	$mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
	$mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);
	$self->_addParameterControls('AcceleratorUser', $gridSizer, $instconfig, 'string');
	$self->_addPasswordConfirmationControls('AcceleratorPassword', $gridSizer, $instconfig);
	
	$gridSizer->AddGrowableCol( 1 );
	$self->SetSizerAndFit($mainSizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	$self->Show(1);
	
	return {}; 
}

sub Process {
	my ($self,) = @_;
	my $app = Wx::wxTheApp();
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

	$instconfig->resetError ();
	
	if(!$self->_setAcceleratorUser($app, $instconfig)){
    	return undef;
    }
    if(!$self->_setAcceleratorPassword($app, $instconfig)){
    	return undef;
    }
	
	return {};
}

1;