package LCM::Gui::Dialogs::AddHosts::AddHostsPanel;


use strict;
use parent 'LCM::Gui::Dialogs::HostsPanel';
use Wx qw (wxVERTICAL wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD);
use LCM::Gui::DialogUtilities qw(GetAppConfig);
use LCM::Configuration::HdbLcmInstalledActionConfiguration qw ( IsHostPartOfSystem);

sub newFieldsSizer {
    my ($self) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    return $self->fieldsSizer($instconfig);
}

sub fieldsSizer {
    my ($self, $instconfig, ) = @_;
    my $window = $self->getWindow();
    my $sizer = new Wx::FlexGridSizer(3, 2, 5, 10);

    $window->{_fieldsSizer} = $sizer;
    $sizer->SetFlexibleDirection(wxHORIZONTAL);
    $sizer->AddGrowableCol(1);

    $self->_addRootUserName($sizer, $instconfig);  
    $self->_addRootUserPassword($sizer, $instconfig);
    $self->_addSystemAdministratorPassword($sizer) if ( IsHostPartOfSystem );
    $self->_addHostagentPassword($sizer, $instconfig);
    $self->_addAutoAddXs2RolesCheckBox($sizer, $instconfig);

    return $sizer;
}

sub _onAssignRoles {
	my ($self, $window) = @_;
	$self->SUPER::_onAssignRoles($window);
	$window->_handleAutoAddCheckBox();
}

sub _onRemoveHost {
	my ($self, $window) = @_;
	$self->SUPER::_onRemoveHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onEditHost {
	my ($self, $window) = @_;
	$self->SUPER::_onEditHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onAddHost {
	my ($self, $window) = @_;
	$self->SUPER::_onAddHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _addSystemAdministratorPassword {
    my ($self, $sizer) = @_;
    my $window = $self->getWindow();
    my $sidAdmPasswordStr = LCM::Gui::DialogUtilities::GetAppConfig()->{params}->{Password}->{str};
    my $sidAdmPasswordLbl = SDB::Install::Gui::Control::Label->new( $window, -1, $sidAdmPasswordStr, 1);

    $sizer->Add($sidAdmPasswordLbl, 0, wxALIGN_CENTER_VERTICAL);

    my $sidadmPasswordCtrl = new Wx::TextCtrl($window, -1, "", wxDefaultPosition, [200, -1], wxTE_PASSWORD);
    $sizer->Add($sidadmPasswordCtrl,  0, wxALIGN_CENTER_VERTICAL);

    $self->addWindowControl( 'Password', $sidadmPasswordCtrl);
}

sub setFieldProperties{
    my ($self,$instconfig) = @_;
    $self->_setParameterControlsVisibility($instconfig, 'RootUser');
}

sub newAddHostsSizer {
    my ( $self ) = @_;
    my $sizer = new Wx::BoxSizer(wxVERTICAL);
    $self->addHostsPanel($sizer);
    return $sizer;
}

1;