package LCM::Gui::Dialogs::AddHosts::SummaryTreeBuilder;

use strict;
use LCM::ComponentManager::SystemComponentManager;
use LCM::AdditionalHostHelper;
use SDB::Install::Globals qw (getHumanReadableRolesString);

sub buildSummaryTree {
	require LCM::SummaryTreeBuilder;

	my ($instconfig) = @_;

	my $roottext =  $instconfig->getProductName();	
	my $warnings = _addParamsWarnings($instconfig);
	my @rootChildren = ();

	my $summaryTree  = {
		"text"     => $roottext,
		"warnings" => $warnings,
		"children" => \@rootChildren
	};

	push( @rootChildren, _buildOperationParamsNode($instconfig) );
	push( @rootChildren, _buildAdditionalHostsNode($instconfig) );

	if ( LCM::SummaryTreeBuilder::_shouldBuildAutoAddedXs2RolesNode($instconfig) ) {
		push( @rootChildren, LCM::SummaryTreeBuilder::_buildAutoAddedXs2RolesNode( $instconfig ));
	}

	return $summaryTree;
}

sub _addParamsWarnings {
	my ($instconfig) = @_;

	my $param;
	for my $param_id ( @{ $instconfig->getParamIds() } ) {
		$param = $instconfig->{params}->{$param_id};
		if (not $param->{warnings} ) {
			next;
		}

		if (not exists $instconfig->{warnings} ) {
			$instconfig->{warnings} = [];
		}

		for my $warning ( @{ $param->{warnings} } ) {
			push( @{$instconfig->{warnings}}, $warning );
		}
	}

	return $instconfig->{warnings};
}

sub _buildOperationParamsNode {
	my ($instconfig)           = @_;
	my @operationParams        = ();
	
	my $operationParamsNodeRef = {
		"text" => "Add Hosts Parameters",
		"children" => \@operationParams
	};

	my $param;
	for my $param_id ( @{ $instconfig->getParamIds() } ) {
		$param = $instconfig->{params}->{$param_id};
		if ( $param->{skip} ) {
			next;
		}

		if ( $param->{type} eq 'passwd' || $param->{type} eq 'initial_passwd' ) {
			next;
		}
		
		if( $param_id eq 'AddHosts') {
			next;
		}
		
		if (! (defined $param->{hidden} && $param->{hidden}) ) {
			my $text = "$param->{str}: " . $instconfig->getLogValue($param_id);
			my $nodeRef = { "text" => $text };
			push( @operationParams, $nodeRef );
		}
	}
    
	return $operationParamsNodeRef;
}

sub _buildAdditionalHostsNode {
	my ($instconfig) = @_;

	my @hostsChildren = ();
	my $hostsNodeRef  = {
		"text"     => "Additional Hosts",
		"children" => \@hostsChildren
	};

    my $parser = new SDB::Install::Configuration::AddHostsParser ();
    my $addHosts = $instconfig->{params}->{AddHosts}->{value};
    $parser->parse($addHosts);
    require LCM::AdditionalHostHelper;
    
    foreach my $host (@{$parser->getHosts()}){
        my @hostRoles = @{$parser->getRoles($host)};
        my $humanReadableRoles = getHumanReadableRolesString(@hostRoles);
        my $workerGroups = $parser->getValue($host, 'workergroup') || [];
        my $workerGroupsString = scalar(@{$workerGroups}) > 0 ? join(',', @{$workerGroups}) : undef;
        my $hostObj = new LCM::AdditionalHostHelper({
            host => $host,
            role => $humanReadableRoles,
            workergroup => $workerGroupsString,
            group => $parser->getValue($host, 'group'),
            storage_partition => $parser->getValue($host, 'storage_partition'),
        });
        
		my @hostChildren = ();
		push( @hostChildren, { text => "Role: " . $hostObj->getRoleDisplayValue() } ) if $hostObj->getRole();
		push( @hostChildren, { text => "High-Availability Group: " . $hostObj->getGroupDisplayValue() } ) if $hostObj->getGroup();
		push (@hostChildren, { text => "Worker Group: " . $hostObj->getWorkerGroupDisplayValue()}) if($hostObj->getWorkerGroupDisplayValue());
		push( @hostChildren, { text => "Storage Partition: " . $hostObj->getStoragePartitionDisplayValue() } );

		my $hostNode = {
			"text"     => $hostObj->getHost(),
			"children" => \@hostChildren
		};

		push( @hostsChildren, $hostNode );
	}

	return $hostsNodeRef;
}

return 1;
