package LCM::Gui::Dialogs::AdditionalRolesDialog;

use strict;
our @ISA = qw (Wx::Dialog);

use Wx qw (	wxVERTICAL wxALL wxEXPAND wxALIGN_LEFT wxOK wxCANCEL wxHORIZONTAL wxDefaultPosition wxDefaultSize wxID_OK wxTAB_TRAVERSAL);
use Wx::Event qw (EVT_CHECKBOX);
use SDB::Install::Gui::Design qw (SDBBGCOLOUR_WizardDialog);
use SDB::Install::Globals qw ( GetAllRoles GetHostRoleProperties );
our @validRoles = @ { GetAllRoles() };
our $roleProperties = GetHostRoleProperties();

sub new {
	my ($class, $parent, $host, $hideDbRoles) = @_;
	my $self = $class->SUPER::new($parent, -1, "Edit roles of host $host", wxDefaultPosition, new Wx::Size(500,500));

	$self->{parent} 	 = $parent;	
	$self->{hideDbRoles} = $hideDbRoles;
	
	$self->SetWindowStyleFlag( $self->GetWindowStyleFlag | wxTAB_TRAVERSAL );
	$self->SetBackgroundColour( SDBBGCOLOUR_WizardDialog );

	my $outer_sizer = new Wx::BoxSizer( wxVERTICAL );
	$self->SetSizer( $outer_sizer );

	my $sizer = new Wx::BoxSizer( wxVERTICAL );
	$outer_sizer->Add( $sizer, 1, wxALL | wxEXPAND, 20 );
	$self->{"inner_sizer"} = $sizer;

	$sizer->Add( $self->CreateInputFormSizer(), 1, wxEXPAND );
	$sizer->Add( $self->CreateButtonSizer( wxOK | wxCANCEL ), 0, wxEXPAND );

	$self->_getOKButton()->Enable(0);
	return $self;
}

sub CreateInputFormSizer {
	my ( $self, ) = @_;

	my $validRoleslength = scalar @validRoles;
	my $sizer = new Wx::FlexGridSizer( $validRoleslength , 2, 5, 10 );
	$sizer->SetFlexibleDirection(wxHORIZONTAL);
	$sizer->AddGrowableCol(1);

   	$sizer->Add(new Wx::StaticText($self,-1,""), 0, wxALIGN_LEFT);
   	$sizer->Add( new Wx::StaticText($self,-1,"Assign roles"), 0, wxALIGN_LEFT );

	for my $validRole ( @validRoles ) {
		if($self->{hideDbRoles} && $roleProperties->{$validRole}->{isColumnStore}){
			next;
		}
		
		$self->{"role_$validRole"} = new Wx::CheckBox( $self, -1, $roleProperties->{$validRole}->{str}, wxDefaultPosition, wxDefaultSize );
		$sizer->Add( new Wx::StaticText($self,-1,""), 0, wxALIGN_LEFT );
		$sizer->Add( $self->{"role_$validRole"}, 1, wxALIGN_LEFT );
		EVT_CHECKBOX( $self, $self->{"role_$validRole"}->GetId(), \&_onCLBRoles );
	}
	return $sizer;
}

sub _onCLBRoles {
	my ($self, $evt) = @_;
	# TODO PLAMEN get index and checked
	$self->_fillSelectedItems();

	my $enableOkButton = scalar @ { $self->{_selectedRoles} } > 0;
	$self->_getOKButton()->Enable( $enableOkButton );
}

sub _fillSelectedItems {
	my ($self, ) = @_;

	my @selectedItems = ();
	for my $validRole ( @validRoles ) {
		if($self->{hideDbRoles} && $roleProperties->{$validRole}->{isColumnStore}){
			next;
		}

		if ( $self->{"role_$validRole"}->IsChecked() ) {
			push ( @selectedItems, $validRole );
		}
	}

	$self->{_selectedRoles} = \@selectedItems;
	$self->{_csvRoles} = join(",", @selectedItems);
}

sub _getOKButton {
	my ($self) = @_;
	return Wx::Window::FindWindowById(wxID_OK, $self);
}

sub setPrimaryHostRole {
	my ( $self, $role ) = @_;
	$self->{primaryHostRole} = $role;
}

sub handleSelectedHostRolesCB {
	my ( $self, $host, $isLocalHost ) = @_;
	$self->handleSelectedHostRoles( $host->{role} );
	$self->handleRolesAccessability( $host, $host->{role}, $isLocalHost );
}

sub handleSelectedHostRoles {
	my ( $self, $roles, $isLocalHost ) = @_;
	
	my @rolesFromTable = split (",", $roles);
	for ( @rolesFromTable ) {
		my $checkBox = $self->{"role_$_"};
# Very ugnly workaround, which is necessary while the cache_server role is 'hidden'
# After it's showed, the check for defined() can be removed
	    $checkBox->SetValue(1) if defined($checkBox);
	}
}

sub handleRolesAccessability {
	my ( $self, $host, $roles, $isLocalHost ) = @_;

	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	my $action = $instconfig->getAction();
	if ( ! $action eq 'update' && ( ! $isLocalHost or $action eq 'install' ) ) {
		return;
	}

	my $config = $instconfig->{localHostConfiguration};
	if ( $action ne 'update' && defined $config) { 
		my @settedRoles = split( ",", $config->getValue("HostRoles") );
		for ( @settedRoles ) {
			$self->{"role_$_"}->Enable(0);
		}
		return;
	}
	
	if( $self->{parent}->can("isHostExist") && $self->{parent}->isHostExist( $host->{host} ) ){
		for my $validRole ( @validRoles ) {
			if( $self->{parent}->can("isHostRoleExist") && 
				$self->{parent}->isHostRoleExist( $host->{host}, $validRole ) ){
				$self->{"role_$validRole"}->Enable(0);
			}
		}
		return;
	}
	
	$self->{"role_". $self->{primaryHostRole}}->Enable(0);
}

sub getCSVRoles {
	my ($self, ) = @_;
	my @roles = split(',',$self->{_csvRoles});
	my @csvRoles = ($self->{primaryHostRole});
	for my $role (@roles){
		next if ($role eq $self->{primaryHostRole});
		push(@csvRoles, $role);
	}
	return join(',', @csvRoles);
}

1;