package LCM::Gui::Dialogs::DistributedSystemParamsDialog;

use strict;

use Wx qw ( wxVERTICAL wxLEFT wxRIGHT wxEXPAND wxGROW wxALL );
use Wx::Event qw (EVT_RADIOBUTTON);

use SDB::Install::Gui::Control::Label;
use SDB::Install::Gui::Control::Button;
use SDB::Install::Gui::Design;
use LCM::Gui::Dialogs::AdditionalHostPropsDialog;
use LCM::AdditionalHostHelper;
use LCM::App::AddHostsUtils ;
use LCM::Gui::Dialogs::InstallPanel;
use LCM::Gui::Dialogs::UiComponentsFactory;
use SDB::Install::Configuration qw($bool_false_pattern);

use base 'SAPDB::Install::Wizard::Dialog::Base';

sub new{
    my($self) = shift->SUPER::new(@_);
    
	my $is_gtk1 = Wx::wxGTK1 ();
	my $app = Wx::wxTheApp;
	
    $self->{id} = 'DistributedSystemParams';
	$self->{name} = "Choose System Type";
	
    my $outersizer = new Wx::BoxSizer (wxVERTICAL);
    $self->SetSizer($outersizer);

    my $sizer = new Wx::BoxSizer (wxVERTICAL);
    $self->{'sizer_inner'} = $sizer;
    $outersizer->Add($sizer, 1, wxALL | wxEXPAND | wxGROW, 20);
    
    my $title = CreateTitle($self, 'Choose System Type', $is_gtk1);
	$sizer->Add($title, 0);
    $sizer->AddSpacer(20);
    
    $self->{'rb_single_host'} = CreateRadioButton($self, "&Single-Host System", $is_gtk1);
    $sizer->Add($self->{'rb_single_host'},0, wxRIGHT, 20);
	EVT_RADIOBUTTON ($self, $self->{'rb_single_host'}->GetId(), \&OnRBSingleHost);
	
	$self->{'rb_distributed'} = CreateRadioButton($self, "&Multiple-Host System", $is_gtk1);
    $sizer->Add($self->{'rb_distributed'},0, wxRIGHT, 20);
	EVT_RADIOBUTTON ($self, $self->{'rb_distributed'}->GetId(), \&OnRBDistributed);
	
	$sizer->AddSpacer(10);
	my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
	my $distSystemProps = $hostsPanel->addNewHostPanel( wxVERTICAL, 0, wxEXPAND, 10, wxEXPAND | wxGROW);
	$sizer->Add($distSystemProps,1, wxLEFT | wxEXPAND | wxGROW, 22);
	$sizer->Hide($distSystemProps, 1);
	$self->{'sizer_dist_props'} = $distSystemProps;
	
	$self->SetAutoLayout (1);
    return $self;
}

sub OnRBSingleHost {
	my ($self) = @_;

	$self->{'sizer_inner'}->Hide($self->{'sizer_dist_props'}, 1);
	$self->{'sizer_inner'}->Layout();
	my $instconfig = _getInstconfig();
	$instconfig->{param}->{'AddHosts'}->{skip} = 1;
	$self->skipDistributedParams( 1 );
	$self->filterCertificates();
}

sub OnRBDistributed {
	my ($self) = @_;

	$self->{'sizer_inner'}->Show($self->{'sizer_dist_props'}, 1);
	$self->skipDistributedParams( 0 );
	my $instconfig = _getInstconfig();
	my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
    $hostsPanel->setFieldProperties($instconfig);
	$self->{'sizer_inner'}->Layout();
}

sub skipDistributedParams {
	my ( $self, $skipFlag ) = @_;
	
	my $instconfig = _getInstconfig();
    $instconfig->{params}->{'AddHosts'}->{skip} = $skipFlag;
    
    if ( ! $instconfig->isUseSAPHostagent() ) {
        $instconfig->setSkip('RootUser', $skipFlag);
# Do not unskip the RootPassword parameter in any case
# it will be unskipped in checkRootUser sub only when needed
		$instconfig->setSkip('RootPassword', 1);
    } else{
    	$instconfig->setSkip('HostagentPassword', $skipFlag);
    }
}

sub filterCertificates {
    my ( $self ) = @_;
    
    my $instconfig = _getInstconfig();
    $instconfig->{params}->{'CertificatesHostmap'}->{origin_values} = undef;
    $instconfig->{params}->{'CertificatesHostmap'}->{value} = undef;
    $instconfig->{params}->{'CertificatesHostmap'}->{default_map} = undef;
}

sub _getInstconfig {
	my ($self) = @_;
	return Wx::wxTheApp->{instconfig};
}

sub _isDistributedSystem {
	return $_[0]->{'rb_distributed'}->GetValue ();
} 

sub BackInit{
    my ($self) = @_;

    my $instconfig = $self->_getInstconfig();
	$self->_clearRemoteHostsObject($instconfig);
    if(defined $self->{oldSHAPasswordSkip}){
    	$instconfig->setSkip('HostagentPassword', $self->{oldSHAPasswordSkip});
        $self->GetWizard()->RefreshSkippableDialogs();
    }        
    return {};
}

sub init{
	my ($self,$config) = @_;

	my $instconfig = $self->_getInstconfig();
	$self->_clearRemoteHostsObject($instconfig);
	
	if ($self->{isInitialized}) {
		return {};
	}

	my $addHosts = $instconfig->getBatchValue('AddHosts');
	
	if ($addHosts) {
		$self->{'rb_distributed'}->SetValue(1);
		$self->OnRBDistributed ();
		
		$self->_setValuesOnDefinedBatchValues();
		my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
		$hostsPanel->fillAddHostsFromCmdLine ();
	}
	
	$self->{isInitialized} = 1;	
	return {};
}

sub _setValuesOnDefinedBatchValues {
	my ($self) = @_;
	my $instconfig = $self->_getInstconfig();
	my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
	my $controls = $hostsPanel->getWindowControls ();

	$controls->{RootUser}->SetValue($instconfig->getBatchValue('RootUser')) if $instconfig->getBatchValue('RootUser');
	$controls->{RootPassword}->SetValue($instconfig->getBatchValue('RootPassword')) if $instconfig->getBatchValue('RootPassword');
    $controls->{Target}->SetValue($instconfig->getBatchValue('Target')) if $instconfig->getBatchValue('Target');		
	$controls->{CheckMnt}->SetValue($instconfig->getBatchValue('CheckMnt')) if $instconfig->getBatchValue('CheckMnt');
}

sub Process{
    my ($self, ) = @_;
    my $instconfig = $self->_getInstconfig(); 
	$self->_refreshDistributedParams();
    
    if ( ! $self->_isDistributedSystem ()) {

    	$instconfig->_skipParameters(['CheckMnt', 'AddHosts'], 1);

    	if (! $instconfig->_shouldSkipHostagentPassword()) {
    		$self->{oldSHAPasswordSkip} = $instconfig->isSkipped('HostagentPassword');
    	    $instconfig->setSkip('HostagentPassword', 0);
    	    $self->GetWizard()->RefreshSkippableDialogs();
    	}

    	return {};
    }
    $instconfig->ResetError();
    
    my $msgLst = new SDB::Install::MsgLst();
	$self->_checkForMandatoryParameters($msgLst);

    if ( ! $msgLst->isEmpty() ) {
        my $app = Wx::wxTheApp();
    	$app->ShowErrorMsg ('Configuration error', $msgLst);
    	return undef;
    }
    
    return $self->_checkInputParameters();
}

sub _refreshDistributedParams {
    my ($self) = @_;	
    my $instconfig = $self->_getInstconfig();
    
    $self->_resetFieldValue('RootUser');
    $self->_resetFieldValue('RootPassword');
    $self->_resetFieldValue('HostagentPassword');

    $instconfig->{params}->{AddHosts}->{value} = undef;
    $instconfig->{params}->{CertificatesHostmap}->{default_map} = undef;
    $instconfig->{params}->{CertificatesHostmap}->{origin_values} = undef;
    $instconfig->{_remoteInstallerFromKit} = undef;
    $self->_clearRemoteHostsObject($instconfig);
}

sub _resetFieldValue(){
	my  ($self, $paramId ) = @_;
	my $instconfig = $self->_getInstconfig();
	if(! $instconfig->isSkipped($paramId) ){
		$instconfig->resetParam($paramId);
	}
}

sub _clearRemoteHostsObject {
	my ($self, $config) = @_;
	
	if (defined $config->{_remoteHosts}) {
    	$config->{_remoteHosts}->destroy();
    	$config->{_remoteHosts} = undef;
    }
}

sub _checkForMandatoryParameters {
	my ($self, $msgLst ) = @_;

    my ( $rootUser, $targetValue, $addHostsValue ) = $self->_getUserInput();
    my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
	my $controls = $hostsPanel->getWindowControls ();
    my $instconfig = $self->_getInstconfig();
    my $focusSet = 0;
	
    if ( !$instconfig->isSkipped('RootUser') && ! $rootUser ) {
    	$msgLst->AddError("Required parameter 'Root User' cannot have empty value.");
    	$controls->{RootUser}->SetFocus() if !$focusSet;
    	$focusSet = 1;
    }
    
    if ( ! $addHostsValue ) {
        $msgLst->AddError("No additional hosts set. Multiple host system must have at least one additional host.");
    }
    
    if ( $instconfig->{params}->{Target}->{mandatory} and ! $targetValue ) {
    	$msgLst->AddError("Required parameter '" . $instconfig->{params}->{Target}->{str} . "' cannot have empty value.");
    	$controls->{Target}->SetFocus() if !$focusSet;
    	$focusSet = 1;
    }
}

sub _getUserInput {
    my ($self, ) = @_;
    my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
    my $controls =  $hostsPanel->getWindowControls ();

    my $rootUser        = $controls->{RootUser}->GetValue();
    my $targetValue     = $controls->{Target}->GetValue();
    my $addHostsValue   = $hostsPanel->buildAddHostsOptionValue ( );
    my $checkMnt        = $controls->{CheckMnt}->GetValue();
    my $rootPass        = $controls->{RootPassword}->GetValue();
    my $hostagentPass   = $controls->{HostagentPassword}->GetValue();

    return ( $rootUser, $targetValue, $addHostsValue, $checkMnt, $rootPass,$hostagentPass );
}

sub _checkInputParameters {
	my  ($self, ) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $self->_getInstconfig();
	my $hostsPanel = LCM::Gui::Dialogs::InstallPanel->new($self);
	my $controls = $hostsPanel->getWindowControls ();
    my ( $rootUser, $targetValue, $addHostsValue, $checkMnt, $rootPass, $hostagentPass ) = $self->_getUserInput();

    if ( $targetValue && ! $instconfig->isSkipped('Target') ) {
    	if ( ! $instconfig->setValue( 'Target', $targetValue ) ) {
    	   $controls->{Target}->SetFocus();
    	   $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
           return undef;
    	}
    }

    if ( ! $instconfig->setValue('AddHosts', $addHostsValue) ) {
        $controls->{HostsList}->SetFocus();
        $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
        return undef;
	}
    
    if ($checkMnt && ! $instconfig->isSkipped('CheckMnt')) {
    	if ( ! $instconfig->setValue('CheckMnt', $checkMnt) ) {
    		$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
            $controls->{CheckMnt}->SetFocus();
        	return undef;
    	}
    }

    if ( !$instconfig->isSkipped('RootUser') ){
# Reset the state of the RootPassword parameter in case of a changed value of the RootUser
# parameter. The skip property will be changed in checkRootUser only when needed.
    	$instconfig->setSkip('RootPassword', 1);
    	if( ! $instconfig->setValue('RootUser', $rootUser) ) {
    		$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
    		$controls->{RootUser}->SetFocus();
    		return undef;
    	}
    }
    
    if ( ! $instconfig->isSkipped('RootPassword') ) {
    	if ( ! $instconfig->setValue('RootPassword', $rootPass) ) {
            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
    		$controls->{RootPassword}->SetFocus();
        	return undef;
    	}
    }
    
    if ( $instconfig->isUseSAPHostagent() and ! $instconfig->isSkipped('HostagentPassword') ) {
        if( !$instconfig->setValue('HostagentPassword',$hostagentPass) ){
            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
            $controls->{HostagentPassword}->SetFocus();
            return undef;
        }
    }
    $self->GetWizard()->RefreshSkippableDialogs();

    return {};
}

sub OnListItemsUpdated {
    my ($self, ) = @_;
#    $self->{isAddHostParamaterSet} = 0;
}

1;
