package LCM::Gui::Dialogs::FinalizeDialog;

use Wx qw (wxVERTICAL wxHORIZONTAL wxEXPAND wxCENTRE wxICON_EXCLAMATION wxALIGN_CENTER wxLEFT wxRIGHT wxALIGN_CENTER_VERTICAL wxOK wxTOP
    wxDefaultPosition wxDefaultSize wxVSCROLL );
use Wx::Event qw (EVT_BUTTON EVT_HYPERLINK);

use base SAPDB::Install::Wizard::Dialog::Base;
use LCM::Component;
use SDB::Install::Gui::Design;
use SDB::Install::Globals;
use LCM::Configuration::GenericStackAny qw (ADD_HOSTS);
use LCM::Configuration::RenameSystemConfiguration qw ($SYSTEM_RENAME_ACTION);
use LCM::Configuration::SLD::RegistrationConfiguration qw ($CONFIGURE_SLD_ACTION);
use LCM::Configuration::InternalNetworkConfiguration qw ($INTERNAL_NETWORK_ACTION);
use LCM::Configuration::Hosts::RemoveHosts::RemoveHostsConfiguration;
use LCM::Gui::Dialogs::UiComponentsFactory;
use LCM::Gui::Dialogs::FinalizationStepsFactory;
use LCM::Executors::ExecutionStep;
use LCM::ComponentStepWrapper;
use LCM::Configuration::GenericStackAny qw(INSTALL_ACTION UPDATE_ACTION UPDATE_COMPONENTS_ACTION UNINSTALL_ACTION);
use LCM::App::AbstractApplication qw( getURL openURL );

use strict;

sub new {
	my ($self) = shift->SUPER::new(@_);
	$self->{id}   = 'finalize';
	$self->{name} = "Finish";

	# sizers
	my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
	$self->SetSizer($outer_sizer);
	my $sizer = new Wx::BoxSizer(wxVERTICAL);
	$outer_sizer->Add($sizer, 0, wxTOP|wxLEFT|wxRIGHT|wxEXPAND, 20);
	my $scrolledPanel = new Wx::ScrolledWindow($self, -1, wxDefaultPosition, wxDefaultSize, wxVSCROLL);
	$scrolledPanel->SetSizer(new Wx::BoxSizer(wxVERTICAL));
	$scrolledPanel->SetScrollbars(20, 20, 50, 50);
	$scrolledPanel->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	$outer_sizer->Add($scrolledPanel, 1, wxLEFT|wxRIGHT|wxEXPAND, 20);
	$self->{"inner_sizer"} = $sizer;
	#   Icons
	my $imgs = new SAPDB::Install::Resources()->getImages ('icon/ready.png', 'icon/error.png', 'icon/warning.png');
	if (defined $imgs){
		$self->{bmps}->{'FINISHED_SUCCESS'} = Wx::Bitmap->new ($imgs->{'icon/ready.png'});
		$self->{bmps}->{'FINISHED_ERROR'} = Wx::Bitmap->new ($imgs->{'icon/error.png'});
		$self->{bmps}->{'FINISHED_WARNING'} = Wx::Bitmap->new ($imgs->{'icon/warning.png'});
	}
	$self->{scrolledPanel} = $scrolledPanel;
	$self->SetAutoLayout(1);
	return $self;
}

sub init {
	my ( $self, $configuration ) = @_;
	my $appliaction = Wx::wxTheApp();

	return if ($self->{initialized});

	$self->_initFinalizationSteps();
	$self->_layout($configuration);
	$self->{initialized} = 1;

	return { 'auto_next' => 1 };
}

sub _hasExecutionWarnings {
	my ( $self ) = @_;

	my $app               = Wx::wxTheApp();
	my $instconfig        = $app->getInstconfig();

	if( $instconfig->getAction() eq ADD_HOSTS ) {
		return 0;
	}

	my $finalizationSteps = $self->{finalizationSteps};
	foreach my $finalizationStep (@$finalizationSteps) {
		if ($finalizationStep->getStatus() == STATUS_FINISHED_WARNING) {
			return 1;
		}
	}

	return 0;
}

sub _initFinalizationSteps {
	my $self = shift();
	my $app = Wx::wxTheApp();
	my $processTask = $app->getInstconfig()->{processTask};
	my $finalizationSteps = [];
	if(defined $processTask){
		for my $task (@{$processTask->getAllSubtasks()}) {
			push(@{$finalizationSteps}, $task);
		}
	}
	$finalizationSteps = ExcludeSuccessfulInternalExecutionSteps($finalizationSteps);
	$self->{finalizationSteps} = $finalizationSteps;
}

sub _showLog {
	my ( $self, $event ) = @_;

	my $button = $event->GetEventObject();

	my $finalizationStep = $button->{"finalizationStep"};
	my $log_location = $finalizationStep->getLogLocation();
	
	eval { require SDB::Install::LogViewer::Dialog::XLVDialog; };
	if ($@) {
		Wx::MessageBox( "Error: $@", 'Log Viewer Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
		return undef;    # Stay in current dialog!
	} else {
		my ($frame) = SDB::Install::LogViewer::Dialog::XLVDialog->new(
			$self,
			$finalizationStep->getName() . " - XML Log Viewer",
			Wx::Point->new( 300, 100 ),
			Wx::Size->new( 640,  800 )
		);
		
		$frame->LoadFileAfterShow( $log_location );		
		$frame->SetSize( 640, 800 );
		$frame->SetMinSize( [ 450, 600 ] );
		$frame->ShowModal();
		$frame->Destroy();
		$frame = undef;
	}
}

sub _getStatusText {
	my ($self, $task) = @_;
	# TODO: FIX AFTER REFACTORING END: remove
	if($task->can('getStatus')){ # after refactoring the method accepts task instead of state
		my $status = $task->getStatus();
		if ($status->isInInitialState()) {
			return 'Not processed';
		} 
		if ($status->isInErrorState()) {
			return 'Failed';
		}
		if ($status->isInFinishedState() && $task->hasWarningMessages()) {
			return 'Warning';
		}
		if ($status->isInFinishedState()) {
			return 'Successful';
		}
		
		return 'Unknown';
	} else{
		my $status = $task;
		
		if ($status == STATUS_INITIAL) {
			return 'Not processed';
		} 
		if ($status == STATUS_FINISHED_ERROR) {
			return 'Failed';
		}
		if ($status == STATUS_FINISHED_WARNING) {
			return 'Warning';
		}
		if ($status == STATUS_FINISHED_SUCCESS) {
			return 'Successful';
		}
		
		return 'Unknown';
	}
}

sub _getStatusIcon {
	my ($self, $task) = @_;
	
	# TODO: FIX AFTER REFACTORING END: remove
	if($task->can('getStatus')){ # after refactoring the method accepts task instead of state
		my $status = $task->getStatus();
		
		if ($status->isInErrorState()) {
			return $self->{'bmps'}->{'FINISHED_ERROR'};
		}
		if ($status->isInFinishedState() && $task->hasWarningMessages()) {
			return $self->{'bmps'}->{'FINISHED_WARNING'};
		}
		if ($status->isInFinishedState()) {
			return $self->{'bmps'}->{'FINISHED_SUCCESS'};
		}
	
		return undef;
	} else{
		my $status = $task;
		
		if ($status == STATUS_FINISHED_ERROR) {
			return $self->{'bmps'}->{'FINISHED_ERROR'};
		}
		if ($status == STATUS_FINISHED_WARNING) {
			return $self->{'bmps'}->{'FINISHED_WARNING'};
		}
		if ($status == STATUS_FINISHED_SUCCESS) {
			return $self->{'bmps'}->{'FINISHED_SUCCESS'};
		}
	
		return undef;
	}
}

sub Process{
	my ($self,$config) = @_;

    $self->GetWizard()->KillPreviousDialogs ();
    
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    
    $app->CleanUp ();
    $self->GetWizard->LogButton('&View Log',sub {
            my ($self,$evt) = @_;
            eval{
                require SDB::Install::LogViewer::Dialog::XLVDialog;
            };
            if ($@){
                Wx::MessageBox( "Error: $@", 'Log Viewer Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self ); 
                return undef; # Stay in current dialog!
            } else {
                my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
                my ($frame) = SDB::Install::LogViewer::Dialog::XLVDialog->new( $self, "$flavourProductName - XML Log Viewer", Wx::Point->new(300,100), Wx::Size->new(640,800) );
                $app->{with_timestamp} = 1;
                $frame->LoadMsgLstAfterShow ($app->getMsgLst());
                $frame->SetSize(640,800);
                $frame->SetMinSize([450,600]);
                $frame->ShowModal();
                $frame->Destroy();
                $frame = undef;
            }
      } );
    
	$self->GetWizard->{'cbutton'}->SetFocus;
		
	return {};
}

sub Destroy{
	my ($self) = @_;
    
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }
	
    foreach my $element ('text', 'inner_sizer', 'bmps' ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

# TODO: FIX AFTER REFACTORING END: remove
# BEGIN of DELETE AFTER REFACTORING
sub IsFinalizationWithComponentSteps {
	my $cfgFinalization = IsConfigurationFinalization();
	my $execFinalization = IsExecutionStepFinalization();
	if(!$cfgFinalization && !$execFinalization){
		return 1;
	}
	return 0;
}

sub IsConfigurationFinalization {
	my $app = Wx::wxTheApp;
	my $instconfig = $app->getInstconfig();
	my $actionsWithCfgSteps = GetConfigurationStepsActions();
	if (grep { $_ eq $instconfig->getAction() } (@$actionsWithCfgSteps)){
		return 1;
	}
	return 0;
}

sub IsExecutionStepFinalization {
	my $app = Wx::wxTheApp;
	my $instconfig = $app->getInstconfig();
	my $actionsWithExecutionSteps = GetExecutionStepsActions();

	if (grep { $_ eq $instconfig->getAction() } (@$actionsWithExecutionSteps)){
		return 1;
	}
	return 0;
}

sub GetConfigurationStepsActions{
	my $actionsWithConfigurationSteps = [ $CONFIGURE_SLD_ACTION , $INTERNAL_NETWORK_ACTION, 'unregister_system', 'unregister_instance' ];
	return $actionsWithConfigurationSteps;
}

sub GetExecutionStepsActions{
	my $actionsWithExecutionSteps = [ ADD_HOSTS , $SYSTEM_REMOVE_ACTION, $SYSTEM_RENAME_ACTION ];
	return $actionsWithExecutionSteps;
}
# END of DELETE AFTER REFACTORING

sub ExcludeSuccessfulInternalExecutionSteps {
	my ( $finalizationSteps ) = @_;

	return [] if ( scalar @$finalizationSteps == 0 );
	# TODO: Fix after refactoring
	if ($$finalizationSteps[0]->can('isHidden')) { # After refactoring call
		my $filteredExecutionSteps = [];
		for my $task (@$finalizationSteps) {
			if ($task->getStatus()->isInFinishedState() && !$task->shouldBeShownOnSummaryPage()) {
				next;
			}
			push @$filteredExecutionSteps, $task;
		}
		return $filteredExecutionSteps;
	} else { # Before refactoring call, delete after refactoring end
		my $filteredExecutionSteps = [];
		for my $component (@$finalizationSteps) {
			my $isStatusSuccess = ($component->getStatus() == STATUS_FINISHED_SUCCESS);
# Nasty workaround for AdditionalHosts component
			if ($isStatusSuccess && $component->isInternal()) {
				next;
			}
			push @$filteredExecutionSteps, $component;
		}
		return $filteredExecutionSteps;
	}
}

sub _createWarningsArea{
	my ( $self ) = @_;
	my $finalizationSteps = $self->{finalizationSteps};
	my $parent_sizer        = $self->{"inner_sizer"};
	my $wrn_icon = $self->{'bmps'}->{'FINISHED_WARNING'};

	foreach my $finalizationStep (@$finalizationSteps) {
		my $warnings;
		# TODO: FIX AFTER REFACTORING END: remove
		if($finalizationStep->can('getWarningMessages')){ # the new name after refactoring
        	$warnings = $finalizationStep->getWarningMessages();
		}
		else{
			$warnings = $finalizationStep->getWarnings();
		}
		
        my $wrnSize = 0;
        if(defined $warnings ){
            $wrnSize = @$warnings;
            if($wrnSize > 0 ){
                my $warningSizer = new Wx::FlexGridSizer( $wrnSize, 2, 10, 15 );
                $parent_sizer->Add($warningSizer);
	            for my $warningMessage (@$warnings) {
	                if (defined $wrn_icon) {
	                    my $image = new Wx::StaticBitmap($self,0, $wrn_icon);
	                    $warningSizer->Add($image,0, wxALIGN_CENTER_VERTICAL );
	                } else {
	                    $warningSizer->AddSpacer(1);
	                }
	                my $label = new Wx::StaticText( $self, 0, $warningMessage);
	                $warningSizer->Add($label,0, wxALIGN_CENTER_VERTICAL );
	            }
                $parent_sizer->AddSpacer(10);
            }
        }
	}
    $parent_sizer->AddSpacer(10);	
}

sub _createTitleArea{
	my ( $self, $config ) = @_;
    
    my $app               = Wx::wxTheApp();
    my $executor          = $app->{executor};
    my $instconfig        = $app->getInstconfig();
    my $parent_sizer      = $self->{"inner_sizer"};

    my $lbl_text = CreateTitle($self, "");
    $parent_sizer->Add($lbl_text, 0, wxALIGN_CENTER);
    
    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    my $message = undef;
    if ( ! defined $executor ) {
	    if(defined $config->{'error_state'} && $config->{'error_state'} == 1){
			if ($instconfig->getAction() eq 'unregister_system') {
	            $message = "Unregistration of $flavourProductName System failed.";
	        } elsif ($instconfig->getAction() eq 'unregister_instance') {
	            $message = "Unregistration of $flavourProductName instance failed."
	        } else {
				$message = 'An error occurred. For detailed information, see the log files below.';
	        }
	    } elsif ($instconfig->{'error_state'}) {
	        $message = $instconfig->{'error_state'};
	    } else {
			if ($instconfig->getAction() eq 'unregister_system') {
	            $message = "$flavourProductName System unregistered.";
	        } elsif ($instconfig->getAction() eq 'unregister_instance') {
	            $message = "$flavourProductName instance unregistered.";
	        } else {
				$message = '';
	        }
	    }
    } elsif (defined $config->{'error_state'} && $config->{'error_state'} == 1){
    	# TODO: FIX AFTER REFACTORING END: remove
		if($executor->can('getActionFailed')){ # the old name before refactoring
	    	if ( defined $executor->getActionFailed() ) {
				$message = $executor->getFinalMessage( $executor->getActionFailed() );
			} else {
				$message = $executor->getStatus()->getMessage();
				if (!defined $message) {
					$message = 'An error occurred.';
		 		}
			}
		}
		else{
			$message = $executor->getStatus()->getMessage();
			if (!defined $message) {
		        $message = 'An error occurred.';
			}
		}
		
	    $message .= ' For detailed information, see the log files below.';
    } elsif ($instconfig->{'error_state'}) {
        $message = $instconfig->{'error_state'};
    } else {
    	# TODO: FIX AFTER REFACTORING END: remove
		if($executor->can('getActionDone')){ # the old name before refactoring
			if( defined $executor->getActionDone() ){
				my $actionDone = $executor->getActionDone() . '.' if $executor->hasActionStatusDone();
				$actionDone = $executor->getActionDone() . ' with warnings.' if $executor->hasActionStatusDoneWithWarnings();
				$message = $executor->getFinalMessage( $actionDone );
			} else {
				if( $executor->hasActionStatusDone() || $executor->hasActionStatusDoneWithWarnings() ){
					$message = '';
				}
			} 
		}
		else{
	    	if($executor->getStatus()->isInFinishedState()) {
	    		$message = $executor->getStatus()->getMessage();	
	    	}
			if(!defined $message) {
				$message = '';
			}
		}
    }
    $lbl_text->SetLabel($message);
    $parent_sizer->AddSpacer(20);   
}

sub _createSummaryArea{
    my ( $self ) = @_;

    my $finalizationSteps = $self->{finalizationSteps};
	my $scrolledPanel = $self->{scrolledPanel};
	my $parent_sizer        = $scrolledPanel->GetSizer();
    my $counter = 0;
    if(defined $finalizationSteps){
        $counter = @$finalizationSteps;	
    }
    my $sizer = undef;
    my $app = Wx::wxTheApp;
    my $config = $app->{instconfig};
    my $is_gtk1 = Wx::wxGTK1();
    
    foreach my $finalizationStep (@$finalizationSteps) {
        if(!defined $sizer){
            $sizer = new Wx::FlexGridSizer( $counter + 2 , 4, 10, 15 );
            $parent_sizer->Add($sizer);
            $sizer->AddSpacer (1);
            $sizer->Add(CreateTitle($scrolledPanel, "Status", $is_gtk1));
            $sizer->Add(CreateTitle($scrolledPanel, 'Execution Step', $is_gtk1));
            $sizer->Add(CreateTitle($scrolledPanel, "Logs", $is_gtk1));
        }
        # TODO: FIX AFTER REFACTORING END: remove
        my $icon = undef;
        if ( $finalizationStep->can('getStatus') && defined $finalizationStep->getStatus() ){ # previously the method didn't accept task but rather status enumeration
        	if ( $finalizationStep->getStatus()->can('getState') ) {
            	$icon = $self->_getStatusIcon($finalizationStep);
        	} else {
            	$icon = $self->_getStatusIcon($finalizationStep->getStatus());
        	}
        }
        
        # TODO: FIX AFTER REFACTORING END: remove
        my $statusText = undef;
        if ( $finalizationStep->can('getStatus') && defined $finalizationStep->getStatus() ){ # previously the method didn't accept task but rather status enumeration
        	if ( $finalizationStep->getStatus()->can('getState') ) {
            	$statusText = new Wx::StaticText( $scrolledPanel, -1, $self->_getStatusText($finalizationStep));
        	} else {
            	$statusText = new Wx::StaticText( $scrolledPanel, -1, $self->_getStatusText($finalizationStep->getStatus()));
        	}
        }

        my $stepName = new Wx::StaticText( $scrolledPanel, -1, $finalizationStep->getName());

        # Add elements to sizer
        if (defined $icon) {
            my $image = new Wx::StaticBitmap($scrolledPanel,-1, $icon);
            $sizer->Add($image, 0, wxALIGN_CENTER_VERTICAL );
        } else {
            $sizer->AddSpacer (1);
        }
        $sizer->Add($statusText, 0, wxALIGN_CENTER_VERTICAL );
        $sizer->Add($stepName, 0, wxALIGN_CENTER_VERTICAL );

        if ($finalizationStep->getLogLocation()) {
            my $button = new Wx::Button( $scrolledPanel, -1, 'View Log', [-1,-1], [-1, 25] );
            $button->{"finalizationStep"} = $finalizationStep;
            EVT_BUTTON( $self, $button, \&_showLog );
            $sizer->Add($button, 0, wxALIGN_CENTER_VERTICAL );
        } else {
            my $label_no_log = new Wx::StaticText( $scrolledPanel, -1, "Not available");
            $sizer->Add($label_no_log, 0, wxALIGN_CENTER_VERTICAL );
        }
    }
}

sub _createFeedbackLink{
	my $self = shift();
	my $app = Wx::wxTheApp;

	my $feedbackLabel = new Wx::StaticText($self, -1, $app->getFeedbackMessageLabel().':');
	my $feedbackLink = new Wx::HyperlinkCtrl($self, -1, 'feedback', $app->getFeedbackUrl());
	EVT_HYPERLINK($self, $feedbackLink->GetId(), sub {
		openURL(getURL());
	});
	my $feedbackWrapper = Wx::BoxSizer->new(wxHORIZONTAL);
	$feedbackWrapper->Add($feedbackLabel, 0, wxALIGN_CENTER);
	$feedbackWrapper->Add($feedbackLink, 0, wxALIGN_CENTER);

	my $parent_sizer = $self->{"inner_sizer"};
	$parent_sizer->AddSpacer(20);
	$parent_sizer->Add($feedbackWrapper, 0, wxALIGN_CENTER);
}

sub _layout{
	my $self = shift();
	my $app = Wx::wxTheApp;
	# TODO: FIX AFTER REFACTORING END: remove
	if(defined $_[1]){ # before refactoring
		my ($configuration, $isFinalizationWithComponentSteps ) = @_;
		
		$self->_createTitleArea($configuration);
		$self->_createWarningsArea();
		$self->_createSummaryArea($isFinalizationWithComponentSteps);
	}
	else{
	    my ($configuration ) = @_;
	    
	    $self->_createTitleArea($configuration);
	    $self->_createWarningsArea();
	    $self->_createSummaryArea();
	}

	if ($app->checkFeedbackFormExistance()){
		$self->_createFeedbackLink();
	}
}

1;
