package LCM::Gui::Dialogs::HostsPanel;

use strict;

use Wx qw ( wxHORIZONTAL wxALIGN_LEFT wxALIGN_CENTER_VERTICAL wxEXPAND wxGROW wxDefaultPosition wxDefaultSize wxDefaultValidator
			wxBORDER_SIMPLE wxLC_SINGLE_SEL wxLC_REPORT wxTE_PASSWORD wxLIST_AUTOSIZE_USEHEADER wxLIGHT_GREY);
use Wx::Event qw (EVT_BUTTON EVT_LIST_ITEM_SELECTED EVT_LIST_ITEM_DESELECTED);

use LCM::Gui::DialogUtilities qw ( GetAppConfig );
use LCM::Configuration::GenericStackAny qw ( UPDATE_ACTION UPDATE_COMPONENTS_ACTION );
use LCM::Gui::Dialogs::HostsPanelButtonListener qw ( OnAssignRoles OnAddHost OnEditHost OnRemoveHost );
use LCM::Gui::Dialogs::HostsPanelTableListener qw ( OnListItemSelected InsertListItem GetListItem UpdateListItem );
use SDB::Install::Configuration::NewServerConfig qw ( checkHostName );
use LCM::AdditionalHostHelper;
use SDB::Install::NewDBUser;
use SDB::Install::Gui::Design;

sub new{
    my ($class, $window) = @_;
    my $self = {};
    $self->{'window'}=$window;
    bless $self, $class;

    return $self;	
}

sub getWindow{
	my $self = shift;
	return $self->{'window'};
}

sub _isUpdate {
	my $config = LCM::Gui::DialogUtilities::GetAppConfig();
	return $config->getAction() eq UPDATE_ACTION || $config->getAction() eq UPDATE_COMPONENTS_ACTION;
}

sub addNewHostPanel {
	my ($self, $boxSizerOrientation, $proportion, $sizerFlag, $space, $addHostsSizerFlag) = @_;

	my $sizer = new Wx::BoxSizer ($boxSizerOrientation);
	my $window = getWindow();
	my $fieldsSizer = $self->newFieldsSizer();
    if(defined $fieldsSizer) {
		$sizer->Add($fieldsSizer, $proportion, $sizerFlag);
		$sizer->AddSpacer($space);
		$window->{_fieldsSizer} = $fieldsSizer;
    }
    
	my $addHostsSizer = $self->newAddHostsSizer();
	$sizer->Add($addHostsSizer, 1, $addHostsSizerFlag);
    
    $window->{_hostPanelSizer} = $sizer;
    $self->setFieldProperties(LCM::Gui::DialogUtilities::GetAppConfig());
    return $sizer;
}

sub newFieldsSizer {
	return undef;
}

sub fieldsSizer {
    my ($self, $instconfig, ) = @_;
    my $window = $self->getWindow();
    my $sizer = new Wx::FlexGridSizer( 3, 2, 5, 10 );
    $sizer->SetFlexibleDirection(wxHORIZONTAL );
    $sizer->AddGrowableCol(1);  

   	$self->_addRootUserName($sizer,$instconfig);
   	$self->_addRootUserPassword($sizer,$instconfig);

    $self->_addHostagentPassword($sizer,$instconfig);
    $window->{_fieldsSizer} = $sizer;
    return $sizer;
}

sub _addAutoAddXs2RolesCheckBox {
    my ($self,$sizer,$instconfig)=@_;
    my $window = $self->getWindow();
    my $parameter = $instconfig->{params}->{'AutoAddXS2Roles'};
    my $label = new Wx::StaticText($window, -1, '');
    my $checkBox = new Wx::CheckBox ($window, -1, $parameter->{'str'}, [-1,-1], [-1,-1]);
    my $value = $instconfig->hasValue('AutoAddXS2Roles') ? $instconfig->getValue('AutoAddXS2Roles') : 1;

    $checkBox->SetFont(SDBFONT_NormalText) if (!Wx::wxGTK1());
    $checkBox->SetValue($value);

    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL);
    $sizer->Add($checkBox, 0, wxALIGN_CENTER_VERTICAL);
    $self->addWindowControl('AutoAddXS2RolesLabel', $checkBox);
    $self->addWindowControl('AutoAddXS2Roles', $checkBox);
}

sub _addRootUserName{
    my ($self,$sizer,$instconfig)=@_;
    my $window = $self->getWindow();
    my $rootUserParam = $instconfig->{params}->{'RootUser'};
    my $label = new SDB::Install::Gui::Control::Label( $window, -1, $rootUserParam->{str}, 1);

    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL  );
    $self->addWindowControl( 'RootUserLabel', $label);
    $self->addWindowControl( 'RootUser', new Wx::TextCtrl($window, -1, $instconfig->getDefault("RootUser") ? $instconfig->getDefault("RootUser") : "", wxDefaultPosition, [200, -1]) );
    $sizer->Add($window->{Controls}->{'RootUser'}, 0, wxALIGN_CENTER_VERTICAL);
}
sub _addRootUserPassword{
    my ($self,$sizer,$instconfig)=@_;
    my $window = $self->getWindow();
    my $rootPassParam = $instconfig->{params}->{'RootPassword'};
    my $rootPassword = $instconfig->getValue("RootPassword") ? $instconfig->getValue("RootPassword") : "";
    my $label = new SDB::Install::Gui::Control::Label( $window, -1, $rootPassParam->{str}, 0);

    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
    $self->addWindowControl( 'RootPasswordLabel', $label);
    $self->addWindowControl(  'RootPassword', new Wx::TextCtrl($window, -1, $instconfig->getDefault("RootPassword") ? $instconfig->getDefault("RootPassword") : "", wxDefaultPosition, [200, -1], wxTE_PASSWORD) );
    $sizer->Add( $window->{Controls}->{'RootPassword'}, 0, wxALIGN_CENTER_VERTICAL );
}

sub _addHostagentPassword{
    my ($self,$sizer,$instconfig)=@_;
    my $window = $self->getWindow();
    my $remoteExecutionValue = $instconfig->getValue("RemoteExecution");
    my $isHostagentPasswordRequired = (defined $remoteExecutionValue && $remoteExecutionValue eq "saphostagent")?1:0;
    my $saphostAgentParam = $instconfig->{params}->{'HostagentPassword'};
    my $label = new SDB::Install::Gui::Control::Label( $window, -1, $saphostAgentParam->{str}, $isHostagentPasswordRequired);

    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
    $self->addWindowControl( 'HostagentPasswordLabel', $label);
    $self->addWindowControl( 'HostagentPassword', new Wx::TextCtrl($window, -1, $instconfig->getDefault('HostagentPassword') ? $instconfig->getDefault('HostagentPassword') : "", wxDefaultPosition, [200, -1], wxTE_PASSWORD) );
    $sizer->Add( $window->{Controls}->{'HostagentPassword'}, 0, wxALIGN_CENTER_VERTICAL );
}

sub newAddHostsSizer {
   return undef;
}

sub addHostsPanel {
    my ($self, $sizer)= @_;
    my $app = Wx::wxTheApp();
    my $config = $app->{'instconfig'};
    my $window = $self->getWindow();
    my $hostsList = $self->createHostsListCtrl($window);
    $self->addWindowControl( 'HostsList',  $hostsList);
    $sizer->Add( $hostsList, 1, wxEXPAND | wxGROW);
    
    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    if ($self->_isUpdate()) {
        my $label = new SDB::Install::Gui::Control::Label( $window, -1, '');
        $label->{textctrl}->SetLabel("* Existing hosts in $flavourProductName System");
        $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL  );
    }
    $sizer->AddSpacer(10);

    EVT_LIST_ITEM_SELECTED($window, $hostsList->GetId, \&OnListItemSelected );
    my $buttonsSizer = Wx::BoxSizer->new(wxHORIZONTAL);
    my $addButton = new SDB::Install::Gui::Control::Button($window, -1, '&Add Host...', wxDefaultPosition, wxDefaultSize);
    $self->addWindowControl( 'addButton',  $addButton);
    EVT_BUTTON($window,$addButton->GetId, sub { $self->_onAddHost(@_); });
    $buttonsSizer->Add( $addButton, 0 );
    $buttonsSizer->AddSpacer(5);

    my $editButton = new SDB::Install::Gui::Control::Button($window, -1, '&Edit Host...', wxDefaultPosition, wxDefaultSize);
    $self->addWindowControl( 'editButton',  $editButton);
    $editButton->Enable(0);  
    EVT_BUTTON($window,$editButton->GetId, sub { $self->_onEditHost(@_); });
    $buttonsSizer->Add( $editButton, 0 );
    $buttonsSizer->AddSpacer(5);

    my $removeButton = new SDB::Install::Gui::Control::Button($window, -1, '&Remove Host', wxDefaultPosition, wxDefaultSize);
    $self->addWindowControl( 'removeButton',  $removeButton);
    $removeButton->Enable(0);    
    EVT_BUTTON($window,$removeButton->GetId, sub { $self->_onRemoveHost(@_); });
    $buttonsSizer->Add( $removeButton, 0 );
    $buttonsSizer->AddSpacer(5);

    my $editRolesButton = new SDB::Install::Gui::Control::Button($window, -1, '&Assign Roles...', wxDefaultPosition, wxDefaultSize);
    $self->addWindowControl( 'editRolesBtn',  $editRolesButton);
    $editRolesButton->Enable(0);    
    EVT_BUTTON($window,$editRolesButton->GetId, sub { $self->_onAssignRoles(@_); });
    $buttonsSizer->Add( $editRolesButton, 0 );

    EVT_LIST_ITEM_DESELECTED($window, $hostsList, sub {
        $removeButton->Enable(0);
        $editButton->Enable(0);
        $editRolesButton->Enable(0);
    });
    $sizer->Add($buttonsSizer, 0 , wxALIGN_LEFT);

    return $sizer;
}

sub createHostsListCtrl {
    my($self, $window) = @_;
    my $list = $self->_createListCtrl();
    my $column_index = 0;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    $list->{minColWidths} = [200, 100, 200, 150, 150];
    if ($self->_isUpdate()) {
        $list->InsertColumn($column_index, "");
        $list->SetColumnWidth($column_index++, 15);
        splice @{$list->{minColWidths}}, 0, 0, 15;
    }

    $list->InsertColumn($column_index, "Hostname");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);
    $list->InsertColumn($column_index, "Role(s)");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);
    $list->InsertColumn($column_index, "High-Availability Group");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);
    $list->InsertColumn($column_index, "Worker Group");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);
    $list->InsertColumn($column_index, "Storage Partition");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);

    return $list;
}

sub _createListCtrl {
    my $self = shift();
    my $window = $self->getWindow();
    my $styleFlags = wxBORDER_SIMPLE|wxLC_REPORT|wxLC_SINGLE_SEL|wxEXPAND|wxGROW;

    return new Wx::ListCtrl($window, 0, wxDefaultPosition, wxDefaultSize, $styleFlags, wxDefaultValidator);
}

sub fillAddHostsFromCmdLine {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{instconfig};
    my $hostParameter = _getHostParameter();
    my $addHostsBatchValue = $instconfig->getBatchValue($hostParameter);

    return if !$addHostsBatchValue;

    require SDB::Install::Configuration::AddHostsParser;
    my $parser = new SDB::Install::Configuration::AddHostsParser ();
    $parser->setMsgLstContext([$app->getMsgLst()]);

    if (!defined $parser->parse ($addHostsBatchValue)){
        $app->ShowErrorMsg ("Error parsing command line option --addhosts", $parser->getErrMsgLst());
        return;
    }

    my $window = $self->getWindow();
    for my $host (sort @{$parser->getHosts()}){
        next if (!$host);

        my $roles = $parser->getRoles($host);
        my $workerGroups = $parser->getValue($host, 'workergroup') || [];
        my $workerGroupsString = scalar(@{$workerGroups}) > 0 ? join(',', @{$workerGroups}) : undef;
        my $hostObj = {
             host => $host,
             role => join(',', @$roles),
             workergroup => $workerGroupsString,
             group => $parser->getValue($host, 'group'),
             storage_partition => $parser->getValue($host, 'storage_partition')
        };
            
        InsertListItem( $window, new LCM::AdditionalHostHelper($hostObj) );
    }
}

sub _getHostParameter {
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	return ( 'remove_hosts' eq $instconfig->getAction() ) ? 'RemoveHosts' : 'AddHosts';
}

sub buildAddHostsOptionValue {
	my ($self) = @_;
    my $window = $self->getWindow();
	my $addHostsOption = "";
	my $listCtrl = $window->{Controls}->{'HostsList'};
	my $itemCount = $listCtrl->GetItemCount();
	
	my %roles = ();
	for my $index (0 .. $itemCount-1) {
		my $item = GetListItem( $window, $index );
		my ($host, $role) = ($item->getHost(), $item->getRole());
		my @roles = split( ",", $role );
		for ( @roles ) {
			if(exists $roles{$host}) {   
				push( @{$roles{$host}}, $_ );
			} else {
				$roles{$host} = [$_];
			}
		}
	}
				
	for my $i ( 0 .. $itemCount-1 ) {
		if ($addHostsOption) {$addHostsOption.= ","};

		my $host = GetListItem( $window, $i );

		my $hostValue = $host->getHost();
		foreach my $role (@{$roles{$host->getHost()}}){
			$hostValue .= ":role=" . $role;
		}		
		$hostValue .= ":group=" . $host->getGroup() if $host->getGroup();
		$hostValue .= ":storage_partition=" . $host->getStoragePartition() if $host->getStoragePartition();
		if($host->getWorkerGroups()){
			my @groups = split(',', $host->getWorkerGroups());
			$hostValue .= ":workergroup=" . join(":workergroup=", @groups);
		}
		$addHostsOption .= $hostValue;
	}

	return $addHostsOption;
}

sub addWindowControl {
	my ($self, $controlName, $control ) = @_;
	my $window = $self->getWindow();
	$window->{Controls}->{$controlName} = $control;
}

sub getWindowControls {
	my ($self) = @_;
	my $window = $self->getWindow();
	return $window->{Controls};
}

sub setFieldProperties{
	my ($self,$instconfig) = @_;
    $self->_setParameterControlsVisibility($instconfig, 'RootUser');
    # In AddHost scenario we are unskipping the SHA passwd in checkAddHosts
    # They are on one page and we should not hide it
    $self->_setParameterControlsVisibility($instconfig, 'HostagentPassword');
    
}

sub _setParameterControlsVisibility{
	my($self, $instconfig, $parameterId) = @_;
	
    my $window = $self->getWindow();
	my $parameterCtrl = $window->{Controls}->{$parameterId};
	my $isExistingParameter = exists($instconfig->{params}->{$parameterId});
	my $isExistingUIControl = defined($parameterCtrl);
	my $isExistingUILabel = defined($parameterCtrl);

#	Deffensive style - call subs only on existing parameter and UI controls
	unless( $isExistingParameter && $isExistingUIControl && $isExistingUILabel ){
		return undef;
	}

    my $parameterLabel = $window->{Controls}->{"${parameterId}Label"};
	my $isParameterSkipped = $instconfig->isSkipped($parameterId);
	my $showControl = ! $isParameterSkipped;

	$parameterCtrl->Show( $showControl );
	$parameterLabel->Show( $showControl );

    # RootPassword should be visible if RootUser is visible!
    # By default RootPassword is skipped, which is ok onNext
    # but during RootUser validation we may unskip the RootPassword

    if ( $parameterId eq 'RootUser' and $isParameterSkipped ) {
    	$self->_setParameterControlsVisibility($instconfig, 'RootPassword');
    }
}

sub addHost {
	my($self, $host, $isLocalHost, $markHost) = @_;
	my $window = $self->getWindow();
	my $listCtrl = $window->{Controls}->{'HostsList'};
	my $id = $listCtrl->GetItemCount();
	my $column_index = $self->_isUpdate() ? 1 : 0;

	my $item;
	my $valid = 1;
	for my $index (0 .. ($id-1)) {
		$item = $listCtrl->GetItem($index, $column_index);
		$valid = $self->_isNewHostItemValid($item->GetText(), $host->getHost());
		if ( ! $valid ) {
			last;
		}
	}
	
	if ( $valid ) {
		$item = new Wx::ListItem();
		$item->SetId($id);
		$item->SetBackgroundColour(wxLIGHT_GREY) if($isLocalHost);
		$listCtrl->InsertItem($item);

		$listCtrl->SetItem($id, 0, '*') if ($markHost);

		UpdateListItem( $window, $id, $host );
	}
	my $label = $window->{Controls}->{'HostagentPasswordLabel'};
	if ( ! $label ){
		$label = $window->{Controls}->{'RootUserLabel'};
	}
	$label->{required} = $id ? 1 : 0;
}

sub _isNewHostItemValid {
	my ($self, $insertedItemText, $newCandidateItem ) = @_;

	if ($insertedItemText eq $newCandidateItem) {
	    return 0;
	}

    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    return checkHostName($instconfig, $newCandidateItem, 1);
}

sub _onAssignRoles {
	my ($self, $window) = @_;
	&OnAssignRoles($window);
}

sub _onRemoveHost {
	my ($self, $window) = @_;
	&OnRemoveHost($window);
}

sub _onEditHost {
	my ($self, $window) = @_;
	&OnEditHost($window);
}

sub _onAddHost {
	my ($self, $window) = @_;
	&OnAddHost($window);
}

1;
