package LCM::Gui::Dialogs::HostsPanelTableListener;

use base qw ( Exporter );
our @EXPORT = qw ( OnListItemSelected InsertListItem GetListItem UpdateListItem UpdateListItemAfterEdit );

use LCM::Configuration::HdbLcmInstalledActionConfiguration qw ( IsHostPartOfSystem );
use LCM::Configuration::GenericStackAny qw ( UPDATE_ACTION UPDATE_COMPONENTS_ACTION );
use SDB::Install::Configuration::NewServerConfig qw ( checkHostName );
use LCM::Gui::DialogUtilities qw ( GetAppConfig );
use LCM::AdditionalHostHelper;

sub OnListItemSelected {
	my ($window, $event) = @_;

    my $itemId = $event->GetIndex();
	$window->{selectedItemIndex} = $itemId;
    # Assign Roles must be enabled for each kind of host
    my $btn = $window->{Controls}->{'editRolesBtn'};	
    $btn->Enable(1);

    if ( _shouldEnableButtons($window, $itemId) ) {
        _enableButtons($window);
    }
}

sub isUpdate {
	my $config = LCM::Gui::DialogUtilities::GetAppConfig();
	return $config->getAction() eq UPDATE_ACTION || $config->getAction() eq UPDATE_COMPONENTS_ACTION;
}

sub _shouldEnableButtons {
	my ( $window, $itemId ) = @_;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

	my $column_index = 0;
	$column_index = 1 if isUpdate();
	my $hostListCtrl = $window->{Controls}->{'HostsList'};
	my $selectedItem = $hostListCtrl->GetItem($itemId, $column_index);
	my $selectedItemHostName = $selectedItem->GetText();

    if($window->can("isHostExist")){
    	return ! $window->isHostExist($selectedItemHostName);
	}

	if ( 'add_hosts' ne $instconfig->getAction() or IsHostPartOfSystem() ) {
		return 1;
	}

    return !checkHostName($instconfig, $selectedItemHostName);
}

sub _enableButtons {
    my ($window, ) = @_;

    for ( 'removeButton', 'editButton', 'editRolesBtn' ) {
    	my $btn = $window->{Controls}->{$_};	
    	$btn->Enable(1) if (defined $btn);
    }
}

sub UpdateListItem {
	my($window, $index, $host, $checkListValidity ) = @_;
	my $listCtrl = $window->{Controls}->{'HostsList'};
	
	my $column_index = 0;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	$column_index = 1 if isUpdate();
	my $currentItem = $listCtrl->GetItem($index, $column_index);
	if ( $checkListValidity ) {
		if ( ! isNewHostItemValid($currentItem->GetText(), $host->getHost()) ) {
	        my $app = Wx::wxTheApp();		
	        $app->ShowErrorMsg ("Host ".$host->getHost()." is already added.");		
			return;
		}
	}

	my $colCount = $listCtrl->GetColumnCount();
	$listCtrl->SetItem($index, $column_index++, $host->getHost());
	$listCtrl->SetItem($index, $column_index++, $host->getRoleDisplayValue());
	if ($colCount > $column_index) {
		$listCtrl->SetItem($index, $column_index++, $host->getGroupDisplayValue());
		$listCtrl->SetItem($index, $column_index++, $host->getWorkerGroups());
		$listCtrl->SetItem($index, $column_index, $host->getStoragePartitionDisplayValue());
	}

    $window->OnListItemsUpdated();
	AdjustListCtrlColumnWidths( $window, $listCtrl );
}

sub UpdateListItemAfterEdit {
	my($window, $index, $host ) = @_;
	
	my $listCtrl = $window->{Controls}->{'HostsList'};
	my $id = $listCtrl->GetItemCount();

	my $column_index = 0;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	$column_index = 1 if isUpdate();
	my $item;
	for my $i ( 0 .. ( $id-1 ) ) {
		next if ( $index == $i );
		
		$item = $listCtrl->GetItem($i, $column_index);
		if ( ! isNewHostItemValid($item->GetText(), $host->getHost()) ) {
			my $app = Wx::wxTheApp();		
	        $app->ShowErrorMsg ("Host ".$host->getHost()." is already added.");		
			return;
		}
	}
	
	$listCtrl->SetItem($index, $column_index++, $host->getHost());
	$listCtrl->SetItem($index, $column_index++, $host->getRoleDisplayValue());
	$listCtrl->SetItem($index, $column_index++, $host->getGroupDisplayValue());
	$listCtrl->SetItem($index, $column_index++, $host->getWorkerGroups());
	$listCtrl->SetItem($index, $column_index, $host->getStoragePartitionDisplayValue());

    $window->OnListItemsUpdated();
	AdjustListCtrlColumnWidths( $window, $listCtrl );
}


sub GetListItem {
	my($window, $index) = @_;

	my $column_index = 0;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	$column_index = 1 if isUpdate();
	my $listCtrl = $window->{Controls}->{'HostsList'};
	my $host = $listCtrl->GetItem($index, $column_index++)->GetText(),
	my $role = $listCtrl->GetItem($index,$column_index++)->GetText(),
	my $group = $listCtrl->GetItem($index, $column_index++)->GetText(),
	my $workergroup = $listCtrl->GetItem($index, $column_index++)->GetText(),
	my $storage_partition = $listCtrl->GetItem($index, $column_index)->GetText();
	if ($storage_partition eq $SP_AUTO_ASSIGN or $storage_partition eq $SP_NA ) {
		$storage_partition = undef;
	}

	my $hostObj = new LCM::AdditionalHostHelper({
		host => $host,
		role => $role,
		group => $group,
		workergroup => $workergroup,
		storage_partition => $storage_partition
	});
	
	return $hostObj;
}

sub InsertListItem {
	my($window, $host, $isLocalHost) = @_;

	my $column_index = 0;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	$column_index = 1 if isUpdate();
	my $listCtrl = $window->{Controls}->{'HostsList'};
	my $id = $listCtrl->GetItemCount();

	my $item;
	my $valid = 1;
	for my $index (0 .. ($id-1)) {
		$item = $listCtrl->GetItem($index, $column_index);
		$valid = isNewHostItemValid($item->GetText(), $host->getHost());
		if(!$valid) {
			last;
		}
	}

	if ( $valid ) {	    
		$item = new Wx::ListItem();
		$item->SetId($id);
		$item->SetBackgroundColour(wxLIGHT_GREY) if($isLocalHost) ;
		$listCtrl->InsertItem($item);

	    my $checkListValidity = 0;
		UpdateListItem( $window, $id, $host, $checkListValidity );
	}
	my $label = $window->{Controls}->{'HostagentPasswordLabel'};
	if ( ! $label ) {
	    $label = $window->{Controls}->{'RootUserLabel'};
	}
	$label->{required} = $id ? 1 : 0;
}

sub isNewHostItemValid {
	my ( $insertedItemText, $newCandidateItem ) = @_;

	if ($insertedItemText eq $newCandidateItem) {
	    return 0;
	} 

    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    return checkHostName($instconfig, $newCandidateItem, 1);
}

sub AdjustListCtrlColumnWidths {
	my($window, $listCtrl) = @_;

	my $column_index_start = 0;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	$column_index_start = 1 if isUpdate();
	my $colCount = $listCtrl->GetColumnCount();
	for (my $i = $column_index_start; $i < $colCount; $i++) {
		$listCtrl->SetColumnWidth($i, wxLIST_AUTOSIZE );
		my $colWidth = $listCtrl->GetColumnWidth($i);
		if ($colWidth < $listCtrl->{minColWidths}->[$i]) {
			$listCtrl->SetColumnWidth($i, $listCtrl->{minColWidths}->[$i] );
		}
	}	
}

1;