package LCM::Gui::Dialogs::LSSPropertiesDialog;

use strict;
use SDB::Install::Globals qw ($gShortProductNameLSS);
use SDB::Common::Utils qw(createUsername createGroupname);
use parent 'SDB::Install::Gui::Dialogs::GenericParameter';

sub new {
    my ( $self ) = shift->SUPER::new( @_ );

    $self->{id}         = 'LSSPropertiesDialog';
    $self->{label_text} = "Specify $gShortProductNameLSS Properties";
    $self->{name}       = "Define $gShortProductNameLSS Properties";

    return $self;
}

sub getParamKeys {
    my ( $self ) = @_;
    return ['LSSInstPath', 'LSSUserID', 'LSSGroupID', 'LSSUserHomeDir', 'LSSUserShell'];
}

sub getAlreadySetParamKeys{
    my ($self) = @_;
    my $alreadySetParamKeys = [];
    my $config = Wx::wxTheApp->getInstconfig();
    my $sid = $config->getValue('SID');

    my $username = createUsername('LSSUserID', $sid);
    my $existingUserId = $config->getExistingUserId($username);
    push @$alreadySetParamKeys, 'LSSUserID' if(defined $existingUserId);

    my $groupname = createGroupname('LSSGroupID', $sid);
    my $existingGroupId = $config->getExistingGroupId($groupname);
    push @$alreadySetParamKeys, 'LSSGroupID' if(defined $existingGroupId);
    return $alreadySetParamKeys;
}

1;