package LCM::Gui::Dialogs::PendingSummaryDialog;

use Wx qw ( wxVERTICAL wxHORIZONTAL wxEXPAND wxLEFT wxRIGHT wxTOP wxBOTTOM wxALIGN_CENTER );
use Wx::Event qw (EVT_SIZE);

use parent qw(LCM::Gui::Dialogs::SAPDSignerVerificationDialog);
use SDB::Install::Gui::Design;
use SDB::Install::Globals;
use LCM::SummaryTreeBuilder;
use LCM::Gui::Dialogs::UiComponentsFactory;
use LCM::Gui::Dialogs::SummaryDialog;
use LCM::Gui::Dialogs::InstallDialog;
use LCM::Gui::Dialogs::FinalizeDialog;
use LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog;
use LCM::Gui::Dialogs::SelectComponentsForUpdateDialog;
use LCM::Gui::Dialogs::Update::ResumePendingUpdatePropsDialog;
use LCM::Configuration::GenericStackAny qw(UPDATE_COMPONENTS_ACTION);
use strict;

our $ID = 'pending_summary';
our $is_gtk1 = 0;    #Wx::wxGTK1 ();

sub new {
	my ($self) = shift->SUPER::new(@_);
	$self->{id}   = $ID;
	$self->{name} = 'Pending update information';
	return $self;
}

sub init {
	my ( $self) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $sizer = Wx::BoxSizer->new(wxVERTICAL);

	if ( $^O =~ /mswin/i ) {
		$self->{'tree_ctrl'} = Wx::TreeCtrl->new( $self, -1, [ -1, -1 ], [ -1, -1 ] );
	} else {    #   avoid Gdk warnings
		$self->Show(1);
		$self->{'tree_ctrl'} = Wx::TreeCtrl->new( $self, -1, [ -1, -1 ], [ -1, -1 ] );
		$self->Show(0);
	}

	$self->{'titel_big'} = CreateTitle($self, "Pending update information", $is_gtk1 );
	$sizer->Add( $self->{'titel_big'}, 0, wxLEFT | wxTOP | wxBOTTOM, 20 );
	$sizer->Add( $self->{'tree_ctrl'}, 1, wxEXPAND | wxLEFT | wxRIGHT, 20 );
	my $pendingConfig = $instconfig->getPendingConfiguration();
	my $summaryTree = LCM::SummaryTreeBuilder::buildSummaryTree($pendingConfig, $pendingConfig->getComponentManager());
	$self->_addTreeNode($summaryTree);
	$self->{'tree_ctrl'}->ExpandAll();
	$self->{'resume_checkbox'} = new Wx::CheckBox ($self, -1, 'Continue using these parameters', [-1,-1], [-1,-1]);
	$sizer->Add($self->{'resume_checkbox'}, 0, wxLEFT | wxTOP | wxBOTTOM, 20);
	$self->{'resume_checkbox'}->SetFont(SDBFONT_NormalText) if (!Wx::wxGTK1());
	$self->{'resume_checkbox'}->SetValue(1);

	$self->SetSizer($sizer);
	$self->SetAutoLayout(1);
	$self->GetWizard()->unterminateChain();
	return {};
}

sub _addTreeNode {
	my ( $self, $summaryNodeRef, $parentTreeNode ) = @_;

	my $treeControl = $self->{'tree_ctrl'};
	my $currentTreeNode;
	my $currentNodeText = $summaryNodeRef->{"text"};
	if ( !defined $parentTreeNode ) {
		$currentTreeNode = $treeControl->AddRoot($currentNodeText);
	} else {
		$currentTreeNode = $treeControl->AppendItem( $parentTreeNode, $currentNodeText );
	}

	my $childrenRef = $summaryNodeRef->{"children"};
	if ( !defined $childrenRef ) {
		return;
	}
	$treeControl->SetItemFont( $currentTreeNode, SDBFONT_BoldText ) if ( !$is_gtk1 );
	$treeControl->SetItemText( $currentTreeNode, $currentNodeText ) if ( !$is_gtk1 );
	foreach my $childRef ( @{$childrenRef} ) {
		$self->_addTreeNode( $childRef, $currentTreeNode );
	}
}

sub Process {
    my ($self) = @_;
    my $instconfig       = Wx::wxTheApp()->getInstconfig();
    my $componentManager = $instconfig->getComponentManager ();
    my $curFlavour       = $componentManager->getHANAFlavour();
	my $value            = $self->{resume_checkbox}->IsChecked() ? 1 : 0;
	if(! $instconfig->setValue('ContinueUpdate', $value)) {
		Wx::wxTheApp()->ShowErrorMsg( "Configuration error", $instconfig->getErrMsgLst() );
		return {'errstate' => 1};
	}
	my $wizard = $self->GetWizard();
	$wizard->unterminateChain();
	$instconfig->{params}->{SelectedComponents}->{set_interactive}=0;
	my $verificationStatusOfResume = 1;
	if(! $value){
		if($instconfig->getAction() eq UPDATE_COMPONENTS_ACTION){
			require LCM::Gui::Dialogs::SelectComponentsForResidentUpdateDialog;
			$wizard->AddDialog (new LCM::Gui::Dialogs::SelectComponentsForResidentUpdateDialog ($wizard));
		}else{
			$wizard->AddDialog (new LCM::Gui::Dialogs::SelectComponentsForUpdateDialog ($wizard));
			$wizard->AddCondensedStep('input','Configure');
			$self->_addCondensedSteps();
		}
	} else {
		$verificationStatusOfResume = $self->_verifyResumedComponents();
		my $pendingResumePropsDialog = new LCM::Gui::Dialogs::Update::ResumePendingUpdatePropsDialog($wizard);
		$wizard->AddDialog($pendingResumePropsDialog);
	}
	$wizard->AddDialog (new LCM::Gui::Dialogs::SummaryDialog ($wizard));
	my $installDialog = new LCM::Gui::Dialogs::InstallDialog ($wizard);
	$installDialog->{name} = "Execute";
	$wizard->AddDialog ($installDialog);
    if ( $curFlavour eq $gFlavourPlatform ) {
        $wizard->AddDialog (new LCM::Gui::Dialogs::FinalizeDialog ($wizard));
    } else {
        $wizard->AddDialog (new LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog ($wizard));
    }
	$wizard->terminateChain();
	$wizard->SkipDialog($ID, 1);
	return ($verificationStatusOfResume) ? {} : {errstate => 1};
}

sub _verifyResumedComponents {
	my ($self) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig  = $app->getInstconfig();
# Set to 0 because at this point the user has already chosen to resume and cannot
# select other components. Also allows setBatchValueOfRequiredParams to fail accordingly
	$instconfig->setInteractive('SelectedComponents', 0);
	return $instconfig->setBatchValueOfRequiredParams('SelectedComponents');
}

sub _addCondensedSteps {
	my ($self) = @_;

	my $configuration = Wx::wxTheApp()->{instconfig};
	my $wizard = $self->GetWizard();
	my $controller = $wizard->{controller};
	my $previousDialogId = $self->GetNext()->GetID();
	$wizard->ResetCondensedStep('input');
	my $condensedSteps = $controller->getCondensedSteps();
	my $mapDialogIdToSkipPredicates = $controller->getMapDialogIdToSkipPredicates();

	foreach my $dialog (@{$condensedSteps}){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $mapDialogIdToSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();
	}
}

sub Back {
	my ($self) = @_;
	$self->GetWizard()->terminateChain();
	return {};
}

sub Destroy {
	my ($self) = @_;
	if ( defined $self->GetSizer ) {
		$self->GetSizer->Clear(1);
	}
	foreach my $element ( 'tree_ctrl', 'titel_big', 'resume_checkbox') {
		if ( defined $self->{$element} ) {
			delete $self->{$element};
		}
	}
	$self->SUPER::Destroy;
}

sub DESTROY {
	my ($self) = @_;
	print ">>>> destroying $self\n" if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
