package LCM::Gui::Dialogs::RemoveHostRoles::CurrentRolesDialog;

use strict;
use parent qw(LCM::Gui::Dialogs::AdditionalRolesDialog);

use Wx qw ( wxVERTICAL wxALL wxEXPAND wxALIGN_LEFT wxOK wxCANCEL wxHORIZONTAL wxDefaultPosition wxDefaultSize wxID_OK wxTAB_TRAVERSAL);
use Wx::Event qw (EVT_CHECKBOX);
use SDB::Install::Gui::Design qw (SDBBGCOLOUR_WizardDialog);
use SDB::Install::Globals qw ( GetAllRoles GetHostRoleProperties );
use LCM::App::RemoveHostRolesUtils qw(getRemovableRolesForExistingHosts);
use experimental qw (smartmatch);

sub CreateInputFormSizer {
    my ( $self, ) = @_;

    my @validRoles = @{GetAllRoles()};
    my $roleProperties = GetHostRoleProperties();
    my $validRoleslength = scalar @validRoles;
    my $sizer = new Wx::FlexGridSizer( $validRoleslength , 2, 5, 10 );
    $sizer->SetFlexibleDirection(wxHORIZONTAL);
    $sizer->AddGrowableCol(1);

    $sizer->Add(new Wx::StaticText($self,-1,""), 0, wxALIGN_LEFT);
    $sizer->Add( new Wx::StaticText($self,-1,"Deselect the roles you want to remove"), 0, wxALIGN_LEFT );

    for my $validRole ( @validRoles ) {
        if($self->{hideDbRoles} && $roleProperties->{$validRole}->{isColumnStore}){
            next;
        }

        $self->{"role_$validRole"} = new Wx::CheckBox( $self, -1, $roleProperties->{$validRole}->{str}, wxDefaultPosition, wxDefaultSize );
        $sizer->Add( new Wx::StaticText($self,-1,""), 0, wxALIGN_LEFT );
        $sizer->Add( $self->{"role_$validRole"}, 1, wxALIGN_LEFT );
        EVT_CHECKBOX( $self, $self->{"role_$validRole"}->GetId(), \&_onCLBRoles );
    }
    return $sizer;
}

sub _onCLBRoles {
    my ($self, $evt) = @_;
    $self->_fillSelectedItems();
    my $enableOkButton = scalar @ { $self->{_selectedRoles} } > 0;
    $self->_getOKButton()->Enable( $enableOkButton );
}

sub handleRolesAccessability {
    my ($self, $hostObj) = @_;
    my $config = LCM::Gui::DialogUtilities::GetAppConfig();
    my @allValidRoles = @{GetAllRoles()};
    my $mHostToValidRemovableRoles = getRemovableRolesForExistingHosts($config);
    my $aValidRemovableRoles = $mHostToValidRemovableRoles->{$hostObj->getHost()};
    for my $validRole (@allValidRoles) {
        my $isValidRemovableRole = (defined $aValidRemovableRoles && $validRole ~~ @$aValidRemovableRoles) ? 1 : 0;
        if (!$isValidRemovableRole) {
            $self->{"role_$validRole"}->Enable(0);
        } else {
            $self->{"role_$validRole"}->Enable(1);
        }
    }
}

sub getCSVRoles {
    my ($self, ) = @_;
    return join(',', $self->{_csvRoles});
}

1;
