# This along with all of the Dialogs::RemoveHostRoles and
# the dialogs in Diaglos::AddHostRoles should be refactored
# to use common base classes at some point.
package LCM::Gui::Dialogs::RemoveHostRoles::RemoveHostRolesPanel;
use parent 'LCM::Gui::Dialogs::AddHostRoles::AddHostRolesPanel';

use strict;
use LCM::Gui::Dialogs::HostsPanelTableListener qw(OnListItemSelected GetListItem UpdateListItem);
use Wx qw (wxVERTICAL wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD wxGROW wxEXPAND wxDefaultSize  wxLIST_AUTOSIZE_USEHEADER wxALIGN_LEFT);
use Wx::Event qw (EVT_BUTTON EVT_LIST_ITEM_SELECTED EVT_LIST_ITEM_DESELECTED);

# Name is inherited from LCM::Gui:Dialogs::HostsPanel
# Should refactor at some point
sub newAddHostsSizer {
    my ( $self ) = @_;
    my $sizer = new Wx::BoxSizer(wxVERTICAL);
    my $window = $self->getWindow();
    my $hostsList = $self->createHostsListCtrl($window);
    $self->addWindowControl( 'HostsList',  $hostsList);
    $sizer->Add( $hostsList, 1, wxEXPAND | wxGROW);

    $sizer->AddSpacer(10);

    EVT_LIST_ITEM_SELECTED($window, $hostsList->GetId, \&OnListItemSelected );
    my $buttonsSizer = Wx::BoxSizer->new(wxHORIZONTAL);

    my $editRolesButton = new SDB::Install::Gui::Control::Button($window, -1, '&Remove Roles...', wxDefaultPosition, wxDefaultSize);
    $self->addWindowControl( 'editRolesBtn',  $editRolesButton);
    $editRolesButton->Enable(0);
    EVT_BUTTON($window,$editRolesButton->GetId, sub { $self->_onRemoveRoles(@_); });
    $buttonsSizer->Add( $editRolesButton, 0 );

    EVT_LIST_ITEM_DESELECTED($window, $hostsList, sub {
        $editRolesButton->Enable(0);
    });
    $sizer->Add($buttonsSizer, 0 , wxALIGN_LEFT);

    return $sizer;
}

sub _onRemoveRoles {
    my ($self, $window) = @_;
    &OnRemoveRoles($window);
}

sub OnRemoveRoles {
    my ($window) = @_;

    my $itemIndex = $window->{selectedItemIndex};

    my $host = GetListItem( $window, $itemIndex );

    require LCM::Gui::Dialogs::RemoveHostRoles::CurrentRolesDialog;
    my $dlg = new LCM::Gui::Dialogs::RemoveHostRoles::CurrentRolesDialog($window, $host->getHost());
    my $isLocalHost = 1;
    $dlg->handleSelectedHostRolesCB( $host, $isLocalHost );

    my $retCode = $dlg->ShowModal();
    $dlg->Destroy();
    if ( $retCode != $dlg->GetAffirmativeId() ) {
        return;
    }

    $host->{role} = $dlg->getCSVRoles();
    my $checkListValidity = 0;
    UpdateListItem( $window, $itemIndex, $host, $checkListValidity );
}

1;