package LCM::Gui::Dialogs::RemoveHostRoles::RemoveHostRolesPropertiesDialog;

use strict;
use parent qw(LCM::Gui::Dialogs::AddHostRoles::AddHostRolesPropertiesDialog);
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD wxGROW);
use SDB::Install::Gui::Design;
use SDB::Install::Configuration qw($bool_true_pattern);
use SDB::Install::MsgLst;
use SDB::Install::Globals qw($gHostRoleCacheServer);
use LCM::Gui::Dialogs::RemoveHostRoles::RemoveHostRolesPanel;
use LCM::App::RemoveHostRolesUtils qw(getRemovableRolesForExistingHosts);
use LCM::Gui::Dialogs::UiComponentsFactory;
use experimental qw (smartmatch);

sub new {
    my($self) = shift()->SUPER::new(@_);
    @$self{qw(id label_text name)} = ('RemoveHostRolesPropertiesDialog', 'Specify Roles to Remove', 'Define Roles to Remove');
    return $self;
}

sub init {
    my ($self, ) = @_;

    if ( ! $self->{dialogInitialized} ) {
        my $app        = Wx::wxTheApp;
        my $instconfig = $app->{instconfig};
        $instconfig->setBatchValueOfRequiredParams('AutoInitializeServices');

        my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
        $self->SetSizer($outer_sizer);

        my $sizer = new Wx::BoxSizer(wxVERTICAL);
        $self->{sizer} = $sizer;
        $outer_sizer->Add( $sizer, 1, wxALL | wxEXPAND, 20 );

        my $is_gtk1 = Wx::wxGTK1 ();
        my $title = CreateTitle($self, 'Remove Host Roles', $is_gtk1);
        $sizer->Add($title, 0);
        $sizer->AddSpacer(20);

        my $hostRolesPanel = LCM::Gui::Dialogs::RemoveHostRoles::RemoveHostRolesPanel->new($self);
        my $componentsSizer = $hostRolesPanel->addNewHostPanel( wxVERTICAL, 0, wxEXPAND, 40, wxEXPAND | wxGROW );
        $sizer->Add( $componentsSizer, 1, wxEXPAND );
        $self->{removeHostRolesPanel} = $hostRolesPanel;
    }

    $self->_addExistingHostsToPanel();
    $self->SetAutoLayout(1);
    $self->{dialogInitialized} = 1;
    return {};
}

sub Process {
    my ($self,) = @_;
    my $app = Wx::wxTheApp();
    my $configuration = $app->getInstconfig();

    $configuration->resetError();
    $self->_resetRemoveRoles();

    if (!$self->_setRemoveRolesFromHostsListControl()) {
        return $self->errorState();
    }

    if (!$self->_validateRootCredentials()) {
        return $self->errorState();
    }
    if(!$self->_validateSidadmPassword()) {
        return $self->errorState();
    }
    $self->GetWizard()->RefreshSkippableDialogs();
    return {};
}

sub _resetRemoveRoles {
    my ($self) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    my $removeRolesParamValues = $instconfig->{params}->{RemoveRoles}->{value};
    for my $host (keys(%$removeRolesParamValues)) {
        delete $instconfig->{params}->{RemoveRoles}->{value}->{$host};
    }
}

sub _setRemoveRolesFromHostsListControl {
    my ($self) = @_;
    my $hostsList = $self->{Controls}->{'HostsList'};
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    my $instance = $instconfig->getOwnInstance();
    my $numberOfHosts = $hostsList->GetItemCount();
    my $mHostToValidRemovableRoles = getRemovableRolesForExistingHosts($instconfig);

    my $numberOfHostsWithRemovedRoles = 0;
    for my $index (0 .. ($numberOfHosts-1)) {
        my $item = LCM::Gui::Dialogs::HostsPanel::GetListItem($self, $index);
        my ($host, $roles) = ($item->{host}, $item->{role});
        my @rolesLeft = split(',', $roles);
        my $currentHostRoles = $instance->getHostRolesByIniFile($host);
        if (!defined $currentHostRoles) {
            $self->AddError("Could not get current host roles for host '$host'.");
            return 0;
        }
        my $aValidRemovableRoles = $mHostToValidRemovableRoles->{$host};
        next if (!defined $aValidRemovableRoles);
        my @removedRoles = grep {$_ ~~ @$aValidRemovableRoles && !($_ ~~ @rolesLeft)} @$currentHostRoles;
        next if (! scalar(@removedRoles));

        $numberOfHostsWithRemovedRoles++;
        my $removedRolesCsv = join(",", @removedRoles);
        if (!$instconfig->setMapValueItem('RemoveRoles', $host, $removedRolesCsv)) {
            $hostsList->SetFocus();
            return 0;
        }
    }
    if (!$numberOfHostsWithRemovedRoles) {
        $instconfig->AddError("There must be at least one removed role to proceed!");
        $hostsList->SetFocus();
        return 0;
    }
    if (!$instconfig->checkAllMapValues('RemoveRoles')) {
        $hostsList->SetFocus();
        return 0;
    }
    return 1;
}

# Handles batch values as well
sub _addExistingHostsToPanel {
    my ($self) = @_;
    my $app        = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
    my $removeHostRolesPanel = $self->{removeHostRolesPanel};

    my $ownInstance = $instconfig->getOwnInstance();
    my $hostRolesInfo = $ownInstance->getHostRolesInfo();

    my $mRemoveRolesValue = $instconfig->getValueOrBatchValue('RemoveRoles');
    my $oldContext = $instconfig->setMsgLstContext([new SDB::Install::MsgLst(), new SDB::Install::MsgLst()]);

    for my $host (keys %$hostRolesInfo) {
        my $csvRoles = join(',', split(' ', $hostRolesInfo->{$host}));
# Prevent autovivification
        my $batchValueRoles = (exists $mRemoveRolesValue->{$host}) ? $mRemoveRolesValue->{$host} : undef;
        if (defined $batchValueRoles && length($batchValueRoles)) {
            my @filteredBatchRoles = grep { $_ ne $gHostRoleCacheServer } split(',', $batchValueRoles);
            my @validBatchRoles = grep { $instconfig->checkRole($_) } @filteredBatchRoles;
            if (@validBatchRoles) {
                my @aBatchValueRoles = split(',', $batchValueRoles);
                my @aHostRoles = split(',', $csvRoles);
                @aHostRoles = grep {! ($_ ~~ @aBatchValueRoles)} @aHostRoles;
                $csvRoles = join(',', @aHostRoles);
            }
        }
        my $hostObj = {
            host => $host,
            role => $csvRoles,
        };
        $removeHostRolesPanel->addHost( new LCM::AdditionalHostHelper($hostObj) );
    }
    $instconfig->setMsgLstContext($oldContext);
}

1;