package LCM::Gui::Dialogs::RemoveHosts::RemoveHostsAnalyzer;

use strict;
use warnings;
use LCM::Hosts::HostsDetector;

my $hostsDetector = undef;

sub IsLocalHostSelected {
	my $removeHosts = LCM::Gui::DialogUtilities::GetAppConfig()->getValue('RemoveHosts');
	my $detector = _getHostsDetector();

	return $detector->userInputContainsLocalhost($removeHosts);
}

sub RemoteHosts {
	my $removeHosts = LCM::Gui::DialogUtilities::GetAppConfig()->getValue('RemoveHosts');
	my $detector = _getHostsDetector();
	my $selectedRemoteHosts = $detector->getSelectedRemoteHosts($removeHosts);

	return scalar(@{$selectedRemoteHosts});
}

sub _getHostsDetector {
	if(!$hostsDetector){
		my $config = LCM::Gui::DialogUtilities::GetAppConfig();
		$hostsDetector = new LCM::Hosts::HostsDetector($config->getInstaller(), $config->getMsgLstContext());
	}
	return $hostsDetector;
}

1;
