#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

CertificatesDialog

=head1 DESCRIPTION

Sets certificates hosts values.
=cut

#===============================================================================
package LCM::Gui::Dialogs::Rename::RenameCertificatesDialog;

use strict;

use Wx qw ( wxVERTICAL wxTOP wxEXPAND wxGROW wxALL wxDefaultPosition wxDefaultSize wxDefaultValidator wxBORDER_SIMPLE 
	wxLC_SINGLE_SEL wxLC_REPORT  wxLIST_AUTOSIZE wxLIST_NEXT_ALL wxLIST_STATE_SELECTED wxLIST_AUTOSIZE_USEHEADER);
use Wx::Event qw (EVT_BUTTON EVT_LIST_ITEM_SELECTED EVT_LIST_ITEM_DESELECTED);
use SAPDB::Install::Resources;
use SDB::Install::Gui::Control::Label;
use SDB::Install::Gui::Control::Button;
use SDB::Install::Gui::Design;
use LCM::Gui::Dialogs::Rename::AlterHostPropsDialog;
use base qw (SAPDB::Install::Wizard::Dialog::Base);

our $is_gtk1 = 0;
our $resources = new SAPDB::Install::Resources ();
our $images = $resources->getImages (qw(icon/warning.png));

sub new {
	my ( $self ) = shift->SUPER::new ( @_ );

	my $is_gtk1    = Wx::wxGTK1 ();
	my $app        = Wx::wxTheApp;
	my $instconfig = $app->{instconfig};
	
	$self->{id}   = 'CertificatesDialog';
	$self->{name} = "Define Certificates Properties";

	my $outersizer = new Wx::BoxSizer ( wxVERTICAL );
	$self->SetSizer ( $outersizer );

	my $sizer = new Wx::BoxSizer ( wxVERTICAL );
	$self->{'sizer_inner'} = $sizer;
	$outersizer->Add ( $sizer, 1, wxALL | wxEXPAND | wxGROW, 20 );
	$self->SetAutoLayout ( 1 );
	return $self;
}

sub init {
	my ( $self, $config ) = @_;
    
    my $app        = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
    
	if ( $self->{isInitialized} ) {
		return {} if(! $instconfig->isa('LCM::Configuration::RenameSystemConfiguration'));
		$self->_fillHostsList ( $instconfig );
		return {};
	}

	$self->_addHostsProperties ( $instconfig, $self->{'sizer_inner'}, Wx::wxGTK1 () );
	$self->_fillHostsList ( $instconfig );
	$self->SetAutoLayout ( 1 );
	
	$self->{isInitialized} = 1;
	return {};
}

sub _addHostsProperties {
	my ( $self, $instconfig, $sizer, $is_gtk1 ) = @_;

	my $title = new Wx::StaticText ( $self, -1, 'Enter Certificates Hosts Properties', wxDefaultPosition,
		wxDefaultSize );
	$title->SetFont ( SDBFONT_DialogTitle ) if ( !$is_gtk1 );
	$sizer->Add ( $title, 0 );
	$sizer->AddSpacer ( 20 );

	my $addHostsSizer = $self->_createHostsSizer ( $instconfig );
	$sizer->Add ( $addHostsSizer, 1, wxEXPAND | wxGROW );

	return 1;
}

sub _fillHostsList {
	my ( $self, $instconfig, $isInitialized ) = @_;
    
    my $certificatesMap = $instconfig->{params}->{CertificatesHostmap}->{default_map};
    
	my $listCtrl = $self->{hostsList};
    $listCtrl->DeleteAllItems();
	foreach my $originHost ( keys %{$certificatesMap} ) {
        my $count = $listCtrl->GetItemCount();
        my $item = new Wx::ListItem ();
		$item->SetId          ( $count );
		$listCtrl->InsertItem ( $item );

		$listCtrl->SetItem ( $count, 0, $originHost );
		$listCtrl->SetItem ( $count, 1, $certificatesMap->{$originHost} );
		$count++;
	}

	$self->adjustListCtrlColumnWidths ( $listCtrl );

	return 1;
}

sub _createHostsSizer {
	my ( $self, $instconfig ) = @_;

	my $sizer = new Wx::BoxSizer ( wxVERTICAL );
	my $list =
		Wx::ListCtrl->new ( $self, 0, wxDefaultPosition, wxDefaultSize,
		wxBORDER_SIMPLE | wxLC_REPORT | wxLC_SINGLE_SEL | wxEXPAND | wxGROW,
		wxDefaultValidator );

    $list->InsertColumn ( 0, "Source Host Name" );
	$list->InsertColumn ( 2, "Certificate Host Name" );

	$list->SetColumnWidth ( 0, wxLIST_AUTOSIZE_USEHEADER );
	$list->SetColumnWidth ( 1, wxLIST_AUTOSIZE_USEHEADER );

	$list->{minColWidths} = [ 200, 200 ];

	$self->{hostsList} = $list;
	$sizer->Add ( $self->{hostsList}, 1, wxEXPAND | wxGROW );
	$sizer->AddSpacer ( 10 );

	my $editButton = new SDB::Install::Gui::Control::Button( $self, -1, '&Edit Certificate Host...', wxDefaultPosition, wxDefaultSize );
	$self->{editButton} = $editButton;
	$editButton->Enable ( 0 );
	EVT_BUTTON ( $self, $editButton->GetId, \&_onEditHost );
	$sizer->Add ( $editButton, 0 );
	$sizer->AddSpacer ( 5 );

	EVT_LIST_ITEM_SELECTED (
		$self,
		$list->GetId,
		sub {
			$editButton->Enable ( 1 );
		}
	);
	EVT_LIST_ITEM_DESELECTED (
		$self, $list,
		sub {
			$editButton->Enable ( 0 );
		}
	);
    my $scope = $instconfig->getValue('Scope');
    if ( defined $scope && $scope eq 'instance' && $instconfig->isDistributedSystem(1) ) {
    	$self->_createNoteForRemoteHosts( $sizer );
    }

	return $sizer;
}

sub _onEditHost {
	my ( $self ) = @_;
	
	my $listCtrl       = $self->{hostsList};
	my $itemIndex      = $listCtrl->GetNextItem ( -1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED );
	my $targetCertificateHostName = $listCtrl->GetItem ( $itemIndex, 1 )->GetText ();
	
	my $dlg = new LCM::Gui::Dialogs::Rename::AlterHostPropsDialog ( $self, 'Enter Target Certificate Host Name', 'Target Certificate Host Name');
	$dlg->SetHost ( $targetCertificateHostName );

	my $retCode = $dlg->ShowModal ();
	$dlg->Destroy ();
	if ( $retCode != $dlg->GetAffirmativeId () ) {
		return;
	}

	$targetCertificateHostName = $dlg->GetHost ();
	$listCtrl->SetItem ( $itemIndex, 1, $targetCertificateHostName );
	$self->adjustListCtrlColumnWidths ( $listCtrl );
}

sub _createNoteForRemoteHosts {
    my ( $self, $sizer) = @_;
    my $images    = $resources->getImages(qw(icon/warning.png));
    my $is_gtk1 = Wx::wxGTK1 ();
    
    my $wrngIcon = Wx::StaticBitmap->new( $self, -1, new Wx::Bitmap( $images->{'icon/warning.png'} ) );
    $sizer->Add( $wrngIcon, 0, wxTOP , 20 );
    
    my $wrngText = new Wx::StaticText($self,-1, "Cannot retrieve current certificate hostnames for remote hosts, because scope parameter is set to instance.", wxDefaultPosition, wxDefaultSize);
    $sizer->Add( $wrngText, 0, wxTOP, 5 );
    
    $wrngText = new Wx::StaticText($self,-1, "Enter value for 'Certificate Host Name' only if you want to generate certificates for remote hosts.", wxDefaultPosition, wxDefaultSize);
    $sizer->Add( $wrngText, 0, wxTOP, 5 );
}

sub adjustListCtrlColumnWidths() {
	my ( $self, $listCtrl ) = @_;

	my $colCount = $listCtrl->GetColumnCount ();
	for ( my $i = 0; $i < $colCount; $i++ ) {
		$listCtrl->SetColumnWidth ( $i, wxLIST_AUTOSIZE );
		my $colWidth = $listCtrl->GetColumnWidth ( $i );
		if ( $colWidth < $listCtrl->{minColWidths}->[$i] ) {
			$listCtrl->SetColumnWidth ( $i, $listCtrl->{minColWidths}->[$i] );
		}
	}
}

sub Process {
	my ( $self, $config ) = @_;
	my $app = Wx::wxTheApp ();
	my $instconfig = $app->{instconfig};
	$instconfig->resetError();
	my $msgLst = new SDB::Install::MsgLst ();

	my $listCtrl = $self->{hostsList};
	my $count = $listCtrl->GetItemCount ();
	for ( my $i = 0; $i < $count; $i++ ) {
	    $instconfig->resetError();
		my $sourceHostName = $listCtrl->GetItem ( $i, 0 )->GetText ();
		my $targetCertificateHostName = $listCtrl->GetItem ( $i, 1 )->GetText ();
		my $exitCode = $instconfig->setCertificatesHostmap($sourceHostName, $targetCertificateHostName, 1);
		$msgLst->appendMsgLst ( $instconfig->getErrMsgLst() ) unless $exitCode;
	}
	
	if ( !$msgLst->isEmpty () ) {
		$app->ShowErrorMsg ( 'Configuration error', $msgLst );
		return undef;
	}

	return {};
}

1;
