#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

RenameSystemProgressHandler

=head1 DESCRIPTION

Progress for the rename system scenario.
=cut

#===============================================================================
package LCM::Gui::Dialogs::Rename::RenameSystemProgressHandler;

use SDB::Install::Gui::Dialogs::Install;
use SDB::Common::Utils qw( trim );
our @ISA = ('SDB::Install::Gui::Dialogs::PackageProgressHandler');
use strict;

sub new {
    my $self = shift->SUPER::new (@_);
    $self->{label} = $_[1];
    $self->{id} = 'RenameSystemProgressHandler';
    $self->{value} = 0;
    return $self;
}

sub StepFinished{
    my ($self,$error,$progress) = @_;
   
    $self->{value} = 0;
    if ($error){
        if(defined $progress)
        {
            $self->{'plan'}->SetProgress ($progress);
        }
        $self->addLine($error);
        $self->{'plan'}->Next('FINISHED_ERROR');
    } else{
        $self->addLine("");    
        $self->{'plan'}->SetProgress (100);
        $self->{'plan'}->Next ('FINISHED_SUCCESS');
    }
}

sub SetProgress ($$) {
    my ($self) = @_;    
    $self->{value} += 5;
    if($self->{value} > 95) {
        $self->{value} = 95;
    }
    $self->{plan}->SetProgress($self->{value});
    Wx::Yield ();   
}

sub addLine{
    my ($self, $text) = @_;
    $self->{label}->SetLabel (trim($text));
    $self->SetProgress ($text);
}

1;