package LCM::Gui::Dialogs::Rename::XSAPropertiesDialog;

use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gShortProductNameXS2 $gProductNameXS2);
use base qw(SAPDB::Install::Wizard::Dialog::Base);
use SDB::Common::Utils qw(createXSSpaceSAPUserName createXSSpaceProdUserName);
use strict;
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD wxSP_ARROW_KEYS);

sub new {
	my($self) = shift->SUPER::new(@_);

	$self->{id} = 'XSAdvancedRenameProperties';
	$self->{label_text} = "Specify $gShortProductNameXS2 Properties";
	$self->{name} = "Define $gShortProductNameXS2 Properties";

	return $self;
}

sub _getSID {
	my ($self, $config) = @_;
	return $config->hasValue('newSID') ? $config->getValue('newSID') : $config->getSID();
}

sub init {
	my ($self,$config) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};
	my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
	my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
	my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);
	my $sid = $self->_getSID($instconfig);

	$mainSizer->AddSpacer (20);
	$dialogTitle->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
	$mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
	$mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);

	if(!$instconfig->isSkipped('XsEaDataPath')){
		$self->_addParameterControls('XsEaDataPath', $gridSizer, $instconfig, 'string', 1);
	}
	if(!$instconfig->isSkipped('XSSpaceUserIdSAP')){
		$self->_createDisabledControls($gridSizer, 'XSSpaceUserSAP', 'OS User for XS Advanced SAP Space', createXSSpaceSAPUserName($sid));
		$self->_addParameterControls('XSSpaceUserIdSAP', $gridSizer, $instconfig, 'number', 1);
	}
	if(!$instconfig->isSkipped('XSSpaceUserIdProd')){
		$self->_createDisabledControls($gridSizer, 'XSSpaceUserProd', 'OS User for XS Advanced Customer Space', createXSSpaceProdUserName($sid));
		$self->_addParameterControls('XSSpaceUserIdProd', $gridSizer, $instconfig, 'number', 1);
	}
    if(!$instconfig->isSkipped('XsDomainName')){
        $self->_addParameterControls('XsDomainName', $gridSizer, $instconfig, 'string', 1);
    }

	$gridSizer->AddGrowableCol( 1 );
	$self->SetSizerAndFit($mainSizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	$self->Show(1);

	return {};
}

sub _addParameterControls {
	my ($self, $parameterName, $gridSizer, $instconfig, $type) = @_;

	# Nothing to create if parameter is skipped, hidden or not existent
	return unless(exists($instconfig->{params}->{$parameterName}));
	return if($instconfig->isSkipped($parameterName));
	return if($instconfig->isHidden($parameterName));

	my $parameter = $instconfig->{params}->{$parameterName};
	my $parameterValue = (defined $parameter->{value} ? $parameter->{value} : $instconfig->getDefault($parameterName));
	my $isMandatory = $parameter->{mandatory} ? 1 : 0;
	my $parameterString = $parameter->{str};

	$parameterValue = '' if (!defined $parameterValue);

	my $label = SDB::Install::Gui::Control::Label->new($self, -1, $parameterString, $isMandatory);
	my $inputControl = $self->_createUserInputControl($type, $parameterValue);
	$label->SetToolTip ($parameter->{desc});
	$inputControl->SetToolTip($parameter->{desc});
	$gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($inputControl, 1, wxEXPAND  );
	$self->{_uiControls}->{"_${parameterName}Label"} = $label;
	$self->{_uiControls}->{"_${parameterName}Control"} = $inputControl;
}

sub _createDisabledControls {
	my ($self, $gridSizer, $id, $labelText, $value) = @_;
	my $label = new SDB::Install::Gui::Control::Label($self, -1, $labelText);
	my $inputControl = new Wx::TextCtrl($self, -1, $value, [-1,-1], [-1,-1]);
	$label->Enable(0);
	$inputControl->Enable(0);
	$gridSizer->Add($label, 0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($inputControl, 1, wxEXPAND);
	$self->{_uiControls}->{"_${id}Label"} = $label;
	$self->{_uiControls}->{"_${id}Control"} = $inputControl;
}

sub Process {
	my ($self,) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

	$instconfig->resetError ();

	for my $parameterId ('XsEaDataPath', 'XSSpaceUserIdSAP', 'XSSpaceUserIdProd', 'XsDomainName') {
		if(!$self->_setParameter($app, $instconfig, $parameterId)){
			return undef;
		}
	}
	return {};
}

sub _setParameter {
	my ($self, $app, $instconfig, $parameterId) = @_;
	my $parameterControl = $self->{_uiControls}->{"_${parameterId}Control"};

	# Nothing to do if controls do not exist
	return 1 unless(defined($parameterControl));

	my $value = $parameterControl->GetValue();
	my $parameterString = $instconfig->{params}->{$parameterId}->{str};
	if(! $value) {
	    my $isMandatory = $instconfig->{params}->{$parameterId}->{mandatory};
        return 1 if (!$isMandatory);
		$app->ShowErrorMsg( "$parameterString is empty" );
		$parameterControl->SetFocus();
		return undef;
	}
	if(! $instconfig->setValue($parameterId, $value)) {
		$app->ShowErrorMsg( "$parameterString value", $instconfig->getErrMsgLst() );
		$parameterControl->SetFocus();
		return undef;
	}
	return 1;
}

sub _createUserInputControl {
	my ($self, $type, $value) = @_;
	if ($type eq 'number') {
		return new Wx::SpinCtrl($self, -1, $value, [-1,-1], [-1,-1], wxSP_ARROW_KEYS(), 0, 29999)
	} else {
		return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1]);
	}
}

sub Back{
	my ($self) = @_;
	$self->Reset();
}

sub Reset{
	my ($self) = @_;

	if(defined $self->GetSizer()){
		$self->GetSizer->Clear (1);
	}
	delete($self->{_uiControls});
	$self->SUPER::Reset();
}

sub Destroy{
	my ($self) = @_;
	$self->Reset();
	$self->SUPER::Destroy();
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n" if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;