package LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog;

use strict;

use base qw (SDB::Install::Gui::Dialogs::GenericParameter);
use Wx qw ( wxCENTRE wxICON_EXCLAMATION wxOK wxTE_PASSWORD wxALIGN_CENTER_VERTICAL wxEXPAND );
use LCM::Gui::DialogUtilities qw ( GetAppConfig );
our $ID = 'ResumePendingInstallDialog';

sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = $ID;
    $self->{label_text} = "Enter Pending Install Properties";
    $self->{name} = "Define Pending Install Properties";

    return $self;
}

sub init {
	my $self = shift;
	my $initializationState = $self->SUPER::init(@_);
	$self->_addPasswordConfirmation();
	return $initializationState;
}

sub _addPasswordConfirmation {
	my ($self, ) = @_;
	my $configuration = GetAppConfig();
	my $isSkippedOrHidden = $configuration->isSkipped('SQLSysPasswd') || $configuration->isHidden('SQLSysPasswd');
	return if ($isSkippedOrHidden || $configuration->getType('SQLSysPasswd') ne 'initial_passwd');

	my $isPasswordMandatory = $configuration->isMandatory('SQLSysPasswd');
	my $passwordString = $configuration->getString('SQLSysPasswd');

	my $confirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$passwordString Confirmation", $isPasswordMandatory);
	my $confirmationControl = new Wx::TextCtrl ($self, -1, '',[-1,-1], [-1,-1], wxTE_PASSWORD);
	my %options = (
		'parameterId' => 'SQLSysPasswd',
		'controlType' => 'label',
		'controlOptions' => [0, wxALIGN_CENTER_VERTICAL | wxEXPAND]
	); 
	$self->addControlToGridSizer($confirmationLabel, \%options );
	$options{controlType} = 'ctrl_confirmation';
	$self->addControlToGridSizer($confirmationControl, \%options );
}

sub getParamKeys{
	my ($self, $configuration) = @_;

	my @parametersIds = @{$configuration->getParamIds()};
	my @filteredParamIds = ();
	my $persistenceData = $configuration->pers_load();

	$configuration->setBatchValueOfRequiredParams('UseMasterPassword');
	for my $parameterId (@parametersIds) {
		next if $configuration->isSkipped($parameterId);
		next if $configuration->isHidden($parameterId);
		next if defined $configuration->getValue( $parameterId );
		next if defined $persistenceData->{$parameterId}; 
		push @filteredParamIds, $parameterId;
	}
	return \@filteredParamIds;
}

sub Process {
	my $self = shift;
	if ( ! defined $self->SUPER::Process(@_) ) {
		return undef;
	}
	return $self->_validateSystemUserPassword();
}

sub _validateSystemUserPassword {
	my ($self,) = @_;
	my $configuration = GetAppConfig();
	my $parameterId = 'SQLSysPasswd';
	my $passwordControl = $self->{dynctrl}->{$parameterId . '_ctrl'};
	my $passwordControlConfirmation = $self->{dynctrl}->{$parameterId . '_ctrl_confirmation'};
	return {} if (!defined $passwordControl || !defined $passwordControlConfirmation);

	my $value = $configuration->getValueFromUIString ($parameterId, $passwordControl->GetValue ());
	my $confirmationValue = $configuration->getValueFromUIString ($parameterId, $passwordControlConfirmation->GetValue ());

	if( ! defined $confirmationValue || $confirmationValue eq '' ) {
	    Wx::MessageBox("Checking " . $configuration->getString($parameterId) . " failed.\nConfirmation value is empty", "Configuration Error", wxOK|wxCENTRE|wxICON_EXCLAMATION, $self);
	    $passwordControlConfirmation->SetFocus();
	    return undef;
    }
    if ( $value ne $confirmationValue ) {
	    Wx::MessageBox("Checking " . $configuration->getString($parameterId) . " failed.\nPasswords do not match", "Configuration Error", wxOK|wxCENTRE|wxICON_EXCLAMATION, $self);
	    $passwordControl->SetFocus();
	    return undef;
    }
    return {};
}

1;
