package LCM::Gui::Dialogs::RootUserDialog;

use base qw(SDB::Install::Gui::Dialogs::GenericParameter);
use strict;

sub new{
    my($self) = shift->SUPER::new(@_);
    
    $self->{id} = 'RootUser';
    $self->{label_text} = "Root Username";
    $self->{name} = 'Enter Root Username';
    
    return $self;
}

sub getParamKeys{
    return ['RootUser'];
}

sub Process{
	my $self = shift;
	my $returnValue = $self->SUPER::Process(@_);

	my $app = Wx::wxTheApp();
   	my $instconfig = $app->{'instconfig'};
	if (defined $returnValue && !$instconfig->getErrMsgLst()->isEmpty()) {
		my $productName = $instconfig->getProductName();
		$app->ShowErrorMsg("$productName failed", $instconfig->getErrMsgLst());
	    $returnValue = {'errstate' => 1};
	}

	my $rootUserCtrl = $self->getParamCtrl( 'RootUser' );
	my $rootUser = $rootUserCtrl->GetValue();

	if ( ! defined $rootUser || $rootUser eq '' ) {
		$instconfig->appendErrorMessage('Root User cannot be empty!');
        $app->ShowErrorMsg( "Configuration error", $instconfig->getErrMsgLst() );
        return undef;
    }

	return $returnValue;
}

1;