package LCM::Gui::Dialogs::SelectActivityDialog;

use strict;

use Wx qw (wxVERTICAL wxLEFT wxBLACK wxDefaultPosition wxDefaultSize wxEXPAND wxALL wxLC_REPORT wxNO_BORDER wxLC_NO_HEADER);

use SDB::Install::Gui::Design;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::SAPSystem qw (@STEP_NAMES getPendingInfoFromPersFile);
use SDB::Install::Globals qw ($gFlavourCockpit $gSAPLocation);
use LCM::Utils::CommonUtils qw(getCockpitProductVersion);
use LCM::PersistencyUtils qw (getAllPendingInstallInfo getAllPendingUpdateInfo existsHdblcmPendingUpdate);

use base 'SAPDB::Install::Wizard::Dialog::Base';

sub _createDescriptionSizer{
	my ( $self ) = @_;
	my $is_gtk1 = Wx::wxGTK1 ();
	
	$self->{'description_box'} = Wx::StaticBox->new($self,-1,'System Description');
    $self->{'description_box'}->SetFont( SDBFONT_BoldText ) if (!$is_gtk1);
    $self->{'description_box'}->SetForegroundColour (wxBLACK);
    $self->{'description_box'}->Refresh (1);
    $self->{'description_box'}->Show(0);
	my $descriptionInnerSizer = Wx::StaticBoxSizer->new($self->{'description_box'},wxVERTICAL);	

	$self->{'description_list'} = Wx::ListCtrl->new( $self, -1, wxDefaultPosition, wxDefaultSize, wxLC_REPORT | wxLC_NO_HEADER | wxNO_BORDER);
	$self->{'description_list'}->InsertColumn( 1, "Parameter" );
	$self->{'description_list'}->InsertColumn( 2, "Value" );
	$self->{'description_list'}->Show(0);	
	
    $self->{'description_list'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
	$descriptionInnerSizer->Add($self->{'description_list'},1,wxEXPAND | wxALL ,20);
	my $descriptionOuterSizer = Wx::BoxSizer->new(wxVERTICAL);
    $descriptionOuterSizer->Add($descriptionInnerSizer,1,wxEXPAND | wxLEFT);
    
    return $descriptionOuterSizer;
}

sub _getSystemVersion {
	my ($self, $sapSystem, $isPendingInstall) = @_;

	my $systemFlavour = $sapSystem->getHANAFlavour();
	return $sapSystem->GetVersion() if ($systemFlavour ne $gFlavourCockpit);

	my $configuration;
	if($isPendingInstall){
		$configuration = new LCM::Configuration::GenericStackInstallConfiguration();
	} else {
		$configuration = new LCM::Configuration::GenericStackUpdateConfiguration();
	}
	my $isPending = $isPendingInstall ? 1 : existsHdblcmPendingUpdate($sapSystem->get_sid());
	return $configuration->getCockpitProductInfo($sapSystem, $isPending);
}

sub _fillSystemDescription{
	my ($self, $isPendingInstall) = @_;
	
	my $sapSystem = $self->_getSapSystem();
	return undef if (!defined $sapSystem);
	
	$self->{'description_list'}->DeleteAllItems;
	
	my $count = 0;
	my $item = $self->{'description_list'}->InsertStringItem($count++,"System Id");
	$self->{'description_list'}->SetItem($item,1,$sapSystem->get_sid);

	$item = $self->{'description_list'}->InsertStringItem($count++,"Instance Number");
	
	my $instances = $sapSystem->getNewDBInstances ();
	my $instance;
	if (defined $instances && defined $instances->[0]){
		$instance = $instances->[0];
	}
	
	my $instanceNr = defined $instance ? $instance->{_nr} : undef;
	if( ! defined $instanceNr) {
		require LCM::Configuration::GenericStackInstallConfiguration;
		my $config = new LCM::Configuration::GenericStackInstallConfiguration();
		$config->{sapSys} = $sapSystem;
		$config->{current_sid} = $sapSystem->get_sid();
		my $persistenceData = $config->pers_load();
		$instanceNr = $persistenceData->{InstanceNumber} if exists $persistenceData->{InstanceNumber};
	}
	$self->{'description_list'}->SetItem($item,1,defined $instanceNr ? $instanceNr : '<unknown>');

	$item = $self->{'description_list'}->InsertStringItem($count++,"Version");
	my $versionMessage = $self->_getSystemVersion($sapSystem, $isPendingInstall);
	my @lines = split "\n", $versionMessage;
	$self->{'description_list'}->SetItem($item,1, $lines[0]);
	if ($#lines > 0) {
		for (1 .. $#lines) {
			$item = $self->{'description_list'}->InsertStringItem($count++,'');
			$self->{'description_list'}->SetItem($item,1, $lines[$_]);
		}
	}
	
	$item = $self->{'description_list'}->InsertStringItem($count++,"Installation Path");
	if ($isWin){
		$self->{'description_list'}->SetItem($item,1,$sapSystem->getUsrSapSid ());
	} else{
		my $instPath = $sapSystem->get_target() ? $sapSystem->get_target() : substr ($sapSystem->get_globalSidDir(), 0, -4);
		$self->{'description_list'}->SetItem($item,1,$instPath);
	}

	if(defined $instance){
		$item = $self->{'description_list'}->InsertStringItem($count++,"Hosts");
		my @hosts = @{$instance->getAllHostsWithRoles(1)};
		$self->{'description_list'}->SetItem($item,1,shift @hosts);
		foreach my $host (@hosts){
			$item = $self->{'description_list'}->InsertStringItem($count++,'');
			$self->{'description_list'}->SetItem($item,1, $host);
		}
	
		my $pluginInstallations = $instance->getPluginInstallations();
		my @pluginKeys;
		my $plugins;
		if (defined $pluginInstallations && @$pluginInstallations){
			foreach my $inst (@$pluginInstallations){
				push @pluginKeys, $inst->getProductKey();
			}
			$plugins .= join(', ', @pluginKeys) if (@pluginKeys);
		}
		if ($plugins) {
			$item = $self->{'description_list'}->InsertStringItem($count++,"Plugins");
			$self->{'description_list'}->SetItem($item,1,$plugins);
		}
	}

	my $app = Wx::wxTheApp;
	my $configuration = $app->{instconfig};
	my $pendingInfo;
	if ($isPendingInstall) {
		my $sid = $sapSystem->get_sid();
		my $instconfig = new LCM::Configuration::GenericStackInstallConfiguration();
		$instconfig->{sapSys}                    = $sapSystem;
		$instconfig->{current_sid}               = $sid;
		$instconfig->{params}->{SID}->{value}    = $sid;
		$instconfig->{params}->{Target}->{value} = $sapSystem->get_target();
		$pendingInfo = getAllPendingInstallInfo($instconfig, 1, $configuration->getMsgLst());
	} else {
		$pendingInfo = getAllPendingUpdateInfo($sapSystem, '', '', 1, $configuration->getMsgLst());
	}
    $self->_addPendingInfo($pendingInfo, $count) if $pendingInfo;
    $self->_sizeAndShowDescriptionList();
}

sub _fillLSSpendingInstallDescription {
    my ($self) = @_;

    my $sid = $self->_getLSSPendingInstallSID();
    return undef if(!defined $sid);

    $self->{'description_list'}->DeleteAllItems;

    my $count = 0;
    my $item = $self->{'description_list'}->InsertStringItem($count++,"System Id");
    $self->{'description_list'}->SetItem($item,1,$sid);

    $item = $self->{'description_list'}->InsertStringItem($count++,"Instance Number");

    require LCM::Configuration::GenericStackInstallConfiguration;
    my $config = new LCM::Configuration::GenericStackInstallConfiguration();
    $config->{current_sid} = $sid;
    $config->setValue('SID', $sid);
    my $persistenceData = $config->pers_load();
    my $instanceNr = $persistenceData->{InstanceNumber} if exists $persistenceData->{InstanceNumber};

    $self->{'description_list'}->SetItem($item,1,defined $instanceNr ? $instanceNr : '<unknown>');

    $item = $self->{'description_list'}->InsertStringItem($count++,"Installation Path");
    if ($isWin){
        $self->{'description_list'}->SetItem($item,1,File::Spec->catfile($gSAPLocation, $sid));
    } else{
        my $instPath = $persistenceData->{Target} if exists $persistenceData->{Target};
        $self->{'description_list'}->SetItem($item,1,defined $instPath ? $instPath : '<unknown>');
    }

    my $app = Wx::wxTheApp;
    my $configuration = $app->getInstconfig();
    my $pendingInfo = getAllPendingInstallInfo($config, 0, $configuration->getMsgLst());
    $self->_addPendingInfo($pendingInfo, $count) if $pendingInfo;
    $self->_sizeAndShowDescriptionList();
}

sub _addPendingInfo {
    my ($self, $pendingInfo, $count) = @_;
    my $item;
    my @pendingLines = split("\n", $pendingInfo);
    for (my $i = 0; $i < @pendingLines; $i++) {
        if ($i == 0) {
            $item = $self->{'description_list'}->InsertStringItem($count++, "Pending action");
        } else {
            $item = $self->{'description_list'}->InsertStringItem($count++, "");
        }
        $self->{'description_list'}->SetItem($item, 1, $pendingLines[$i]);
    }
}

sub _sizeAndShowDescriptionList {
    my ( $self ) = @_;
    $self->{'description_list'}->SetColumnWidth(0,-1);
    if ($^O =~ /mswin/i){
        $self->{'description_list'}->SetColumnWidth(1,-2);
    } else{
        $self->{'description_list'}->SetColumnWidth(1,-1);
    }
    $self->{description_list}->SetColumnWidth (0,$self->{description_list}->GetColumnWidth (0) + 20);
    $self->{description_box}->Show(1);
    $self->{description_list}->Show(1);
    $self->Layout ();
}

1;
