package LCM::Gui::Dialogs::SelectActivityExternalDialog;

use strict;

use Wx qw (wxVERTICAL wxHORIZONTAL wxTOP wxLEFT wxRIGHT wxDefaultPosition wxDefaultSize wxALIGN_CENTER_VERTICAL wxEXPAND wxALL wxOK wxCENTRE wxICON_INFORMATION);
use SDB::Install::Gui::Design;
use Wx::Event qw (EVT_RADIOBUTTON EVT_COMBOBOX);
use LCM::Gui::Dialogs::PendingSummaryDialog;
use LCM::Gui::Dialogs::SelectComponentsForInstallDialog;
use LCM::Gui::Dialogs::AdditionalSystemDialog;
use SDB::Install::Gui::Dialogs::VolumePaths;
use SDB::Install::Gui::Dialogs::User;
use SDB::Install::Gui::Dialogs::SQLUser;
use LCM::Gui::Dialogs::SummaryDialog;
use LCM::Gui::Dialogs::InstallDialog;
use LCM::Gui::Dialogs::FinalizeDialog;
use LCM::Gui::Dialogs::SelectComponentsForUpdateDialog;
use LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog;
use SDB::Install::Globals qw($gKeynameEngine $gProductNameEngine $gFlavourPlatform);
use SDB::Install::Configuration::NewDB;
use LCM::Gui::Dialogs::UiComponentsFactory;
use LCM::Configuration::GenericStackUpdateConfiguration;
use LCM::Gui::Dialogs::SelectComponentsDialog;
use LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog;
use LCM::Gui::Controllers::ControllersFactory qw (CreateControllerForScenario);
use LCM::Gui::Dialogs::LSSPropertiesDialog;
use LCM::PersistencyUtils qw (getPendingUpdateSIDs existsHdblcmPendingUpdate existsHdblcmPendingInstall);
use SDB::Install::System qw (isSidadmin isAdmin);
use SDB::Install::SAPSystem qw (CollectSAPSystems);
use LCM::Configuration::GenericStackUpdateConfiguration qw($unableToContinueUpdateMsg);
use LCM::Configuration::PersistenceManager;
use LCM::Configuration::GenericStackAny qw(INSTALL_ACTION);
use LCM::Task::GenericStackTask::InstallProcessTask;
use LCM::Task::GenericStackTask::UpdateProcessTask;

use parent qw(LCM::Gui::Dialogs::SelectActivityDialog LCM::Gui::Dialogs::SAPDSignerVerificationDialog);

sub new {
    my($self) = shift->SUPER::new(@_);
    
    $self->{id} = 'SelectActivityExternal';
	$self->{name} = "Select Activity";
	
    my $outersizer = new Wx::BoxSizer (wxVERTICAL);
    my $innerSizer = new Wx::BoxSizer (wxVERTICAL);
    $outersizer->Add($innerSizer, 1, wxALL | wxEXPAND, 20);
    my $leftInnerSizer = new Wx::BoxSizer(wxVERTICAL);
    $self->{leftInnerSizer} = $leftInnerSizer;

	my $is_gtk1 = Wx::wxGTK1 ();
	$self->{'title'} = CreateTitle($self, 'Choose system to update, or choose installation', $is_gtk1);
    $innerSizer->Add($self->{'title'}, 0);

	my $existingInstallations = $self->_getExistingInstallations ();
	my $existsInstallations = scalar @{$existingInstallations} > 0;
	my $updateSIDs = $self->_getUpdateSIDs();
	my $existsUpdateSIDs = (scalar @{$updateSIDs}) > 0;

	if ($existsUpdateSIDs || !$existsInstallations) {
		$self->_createUpdateControls( $is_gtk1 );
	}

	if ( $self->{_existsPendingInstall} ){
		$self->_createPendingInstallationControls( $is_gtk1 );
	}

	$self->_createInstallControls( $is_gtk1 );

	my $descriptionSizer = $self->_createDescriptionSizer ();
	my $innerHorizontalSizer = new Wx::GridSizer(1, 2, 0, 70);

	$innerHorizontalSizer->Add($leftInnerSizer, 1, wxEXPAND);
	$innerHorizontalSizer->Add($descriptionSizer, 1, wxEXPAND);
	$innerSizer->Add ($innerHorizontalSizer, 1, wxEXPAND | wxTOP, 30);

	$self->SetSizer($outersizer);
	$self->SetAutoLayout (1);
    return $self;
}

sub _createUpdateControls {
	my ( $self, $is_gtk1 ) = @_;
	my $leftInnerSizer = $self->{leftInnerSizer};

	$self->{'rb_update'} = CreateRadioButton($self, "&Update existing system",  $is_gtk1 );
    $leftInnerSizer->Add( $self->{'rb_update'}, 0, wxEXPAND|wxRIGHT, 20 );
    $leftInnerSizer->AddSpacer( 12 );
    EVT_RADIOBUTTON( $self, $self->{'rb_update'}->GetId(), \&OnRBUpdate );

    $self->{'lb_installations'} = new Wx::StaticText( $self,-1,"Select system:", wxDefaultPosition, wxDefaultSize );
    $self->{'cb_installations'} = CreateComboBox($self, '', $is_gtk1, new Wx::Size(100, -1), new Wx::Size(100, -1));
    EVT_COMBOBOX( $self, $self->{'cb_installations'}->GetId(), \&OnComboBoxUpdate );

    my $update_sizer = new Wx::BoxSizer( wxHORIZONTAL );
    $update_sizer->Add( $self->{'lb_installations'},0, wxALIGN_CENTER_VERTICAL );
    $update_sizer->Add( $self->{'cb_installations'},0,  wxLEFT | wxRIGHT,10 );
    
    $leftInnerSizer->Add( $update_sizer, 0 , wxLEFT, 20 );
    $leftInnerSizer->AddSpacer( 30 );

    $self->{_isUpdateCtrlsCreated} = 1;
}

sub _createInstallControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_install'} = CreateRadioButton($self, "&Install New System", $is_gtk1); 
    $leftInnerSizer->Add($self->{'rb_install'},0, wxEXPAND|wxRIGHT, 20);
    $leftInnerSizer->AddSpacer(30);
    EVT_RADIOBUTTON ($self, $self->{'rb_install'}->GetId(), \&OnRBInstall);
}

sub _createPendingInstallationControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_pendingInstall'} = CreateRadioButton($self, "&Resume pending installation", $is_gtk1);
    $leftInnerSizer->Add($self->{'rb_pendingInstall'},0, wxEXPAND|wxRIGHT, 20);
    $leftInnerSizer->AddSpacer(12);
    EVT_RADIOBUTTON ($self, $self->{'rb_pendingInstall'}->GetId(), \&OnRBPendingInstall);

    $self->{'label_pendingInstall'} = new Wx::StaticText( $self,-1,"Select system:", wxDefaultPosition, wxDefaultSize );
    $self->{'combo_pendingInstall'} = CreateComboBox($self, '', $is_gtk1, new Wx::Size(100, -1), new Wx::Size(100, -1));
    EVT_COMBOBOX($self, $self->{'combo_pendingInstall'}->GetId(), \&OnComboBoxPendingInstall);

    my $pendingInstallSizer = new Wx::BoxSizer(wxHORIZONTAL);
    $pendingInstallSizer->Add( $self->{'label_pendingInstall'},0, wxALIGN_CENTER_VERTICAL );
    $pendingInstallSizer->Add( $self->{'combo_pendingInstall'},0, wxLEFT | wxRIGHT,10 );

    $leftInnerSizer->Add($pendingInstallSizer, 0 , wxLEFT, 20);
    $leftInnerSizer->AddSpacer( 30 );

    $self->{_isPendingInstallCtrlsCreated} = 1;
}

sub init{
	my ($self,$config) = @_;

   	my $existingInstallations = $self->_getExistingInstallations ();
	my $existsInstallations = (scalar @{$existingInstallations}) > 0;
	my $updateSIDs= $self->_getUpdateSIDs();

	my $app = Wx::wxTheApp();
	my $instconfig = $app->getActionConfiguration();
	my $mediumComponentManager = $instconfig->getComponentManager ();

	if ($existsInstallations) {
		$self->{'title'}->SetLabel( 'Choose system to update, or choose installation' );
	}

    if ($self->{_isUpdateCtrlsCreated}) {
    	if(!$self->{'isUpdateInitialized'}) {
			$self->_enableUpdateUi(1);
			$self->_appendUpdates($updateSIDs);
            $self->{'rb_update'}->Enable (1);
    	}
    }

    if (!$existsInstallations) {
        $self->{'rb_install'}->SetValue (1);
        $self->{'rb_update'}->Enable (0);
		$self->_enableUpdateUi(0);
		my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
        $self->{'title'}->SetLabel( "Install new $flavourProductName System" );
    }

    if ($self->{_existsPendingInstall} && !$self->{'isPendingInstallInitialized'}) {
		my $pendingInstallSIDs = $self->_getPendingInstallSIDs();
		$self->_appendPendingInstallations($pendingInstallSIDs);
    }

    if (!defined $mediumComponentManager || !$mediumComponentManager->hasComponents ()){
        $app->ShowErrorMsg ('No component found', defined $mediumComponentManager ? $mediumComponentManager->getErrMsgLst() : undef);
        return undef;
    }
    $app->getMsgLst()->appendMsgLst ($mediumComponentManager->getMsgLst ());
    $mediumComponentManager->setMsgLstContext( [ $app->getMsgLst() ] );

	$self->_setUiAction($instconfig);
    $self->Layout();

    if ($self->_isActionGivenViaCommandLine()) {
        return {auto_next => 1};
    }
	return {};
}

sub _isActionGivenViaCommandLine {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getActionConfiguration();
    my $cmdLineActionValue = $instconfig->getCommandLineValue('Action');
    my $cmdLineSidValue = $instconfig->getCommandLineValue('Action_SID');
    my $installedSystemsComboboxSelection = $self->{cb_installations}->GetStringSelection();

    if (defined $cmdLineSidValue && $cmdLineActionValue eq 'update' && $cmdLineSidValue eq $installedSystemsComboboxSelection) {
         return 1;
    }
    return 0;
}

sub _getExistingInstallations {
    my ($self) = @_;

    if (defined $self->{_installedSIDs}) {
    	return $self->{_installedSIDs};
    }

    my $app = Wx::wxTheApp;
    my $configuration = $app->getInstconfig();
	my $actionConfig = $app->getActionConfiguration();

    my $curFlavour = LCM::App::ApplicationContext::getInstance()->getApplication()->getFlavour(1);
    my $newDBConfig = new SDB::Install::Configuration::NewDB();
    my $installedSystems     = {};
    my ($pendingInstallations, $pendingServerInstallations) = $actionConfig->getHdbLcmPendingInstallations();
    my $pendingServerInstallSIDs = join(',', map { $_->get_sid() } @{$pendingServerInstallations});

    my @installedSIDs = $newDBConfig->getNewDBInstallations($installedSystems,
                                                         $pendingServerInstallations);
    my $pendingInstallSIDs = join(',', map { $_->get_sid() } @{$pendingInstallations});
    my @installedOwnedSIDs = ();
    foreach my $currSID (@installedSIDs) {
        next if (grep( /^$currSID/, split(',', $pendingInstallSIDs)));
        next if (!isAdmin() && !isSidadmin($currSID));

        my $sapSys = $installedSystems->{$currSID};
        my $systemFlavour = $sapSys->getHANAFlavour();

        if(defined($curFlavour) && defined($systemFlavour)){
            next if($curFlavour ne $systemFlavour);
        }

        push @installedOwnedSIDs, $currSID;
    }

    my $filteredPendingInstallations = [];
    foreach my $currPending (@$pendingInstallations) {
        $configuration->{sapSys} = $currPending;
        my $systemFlavour        = $currPending->getHANAFlavour();

        if(defined($curFlavour) && defined($systemFlavour)){
            # Filter out the pending install only when its flavour
            # differs from the one found in the current installation kit
            next if($curFlavour ne $systemFlavour);
        }

        push @$filteredPendingInstallations, $currPending;
	}
	foreach my $pendingServerInstallation (@$pendingServerInstallations){
		$installedSystems->{$pendingServerInstallation->get_sid()} = $pendingServerInstallation;
	}

    my $lssPendingInstallationsSIDs = $actionConfig->getLSSPendingInstallations();

	$self->{_installedSIDs} = \@installedOwnedSIDs;
	$self->{_detectedSystems} = $installedSystems;
	$self->{_pendingInstallSystems} = $filteredPendingInstallations;
	$self->{_pendingLSSInstallationSIDs} = $lssPendingInstallationsSIDs;
	$self->{_existsPendingInstall} = scalar @{$filteredPendingInstallations} > 0 || scalar @{$lssPendingInstallationsSIDs} > 0;
	$actionConfig->setPendingServerInstallations($pendingServerInstallSIDs);

	return \@installedOwnedSIDs;
}

sub _getPendingInstallSIDs {
    my ($self) = @_;

    if (!defined $self->{_pendingInstallSystems} || !defined $self->{_pendingLSSInstallationSIDs}) {
		$self->_getExistingInstallations();
    }

	my $pendingInstallations = $self->{_pendingInstallSystems};
	my @pendingInstallSIDs = ();

	for my $currPendingSystem (@{$pendingInstallations}) {
		my $currPendingSID = $currPendingSystem->get_sid();
		push @pendingInstallSIDs, $currPendingSID;
	}

	for my $currentSID (@{$self->{_pendingLSSInstallationSIDs}}) {
        push @pendingInstallSIDs, $currentSID;
    }

	return \@pendingInstallSIDs;
}

sub _getUpdateSIDs {
	my ($self) = @_;

	if (defined $self->{_updateSIDs}) {
		return $self->{_updateSIDs};
	}

	my $existingInstallations = $self->_getExistingInstallations ();
	my @updateSIDs = ();

	foreach my $existingInstalledSid (@$existingInstallations) {
		push @updateSIDs, $existingInstalledSid;
	}

	$self->{_updateSIDs} = \@updateSIDs;
	return \@updateSIDs;
}

sub _appendUpdates {
	my ($self, $updateSIDs) = @_;

	for my $row (@{$updateSIDs}){
		$self->{'cb_installations'}->Append($row);
	}
	$self->{'isUpdateInitialized'} = 1;
 	$self->{'cb_installations'}->SetSelection(0);
}

sub _appendPendingInstallations {
	my ($self, $pendingInstallSIDs) = @_;

	for my $currPendingSID (@{$pendingInstallSIDs}) {
        $self->{'combo_pendingInstall'}->Append($currPendingSID);
    }
    $self->{'isPendingInstallInitialized'} = 1;
    $self->{'combo_pendingInstall'}->SetSelection(0);
}

sub _enableUpdateUi {
	my ($self, $enable) = @_;
	return if ! $self->{_isUpdateCtrlsCreated};

	$self->{'lb_installations'}->Enable($enable) if defined $self->{'lb_installations'};
    $self->{'cb_installations'}->Enable($enable) if defined $self->{'cb_installations'};
}

sub _showUpdateUi {
	my ($self, $enable) = @_;
	return if ! $self->{_isUpdateCtrlsCreated};

    $self->{'rb_update'}->Show($enable);
	$self->{'lb_installations'}->Show($enable);
    $self->{'cb_installations'}->Show($enable);
}

sub _showPendingInstallUi {
	my ($self, $show) = @_;
	return if ! $self->{_isPendingInstallCtrlsCreated};

	$self->{'rb_pendingInstall'}->Show($show);
    $self->{'label_pendingInstall'}->Show($show);
    $self->{'combo_pendingInstall'}->Show($show);
}

sub _enablePendingInstallUi {
	my ($self, $enable) = @_;
	return  if ! $self->{_isPendingInstallCtrlsCreated};

	$self->{'label_pendingInstall'}->Enable($enable);
    $self->{'combo_pendingInstall'}->Enable($enable);
}

sub _setUiAction {
	my ($self, $instconfig) = @_;

	my $paramAction = $instconfig->getParamByOpt('action');
	if(defined $paramAction->{value}) {
		$self->_setComandLineAction($paramAction->{value});
	} else {
		$self->_setDefaultAction();
	}
}

sub _setComandLineAction {
	my ($self, $action) = @_;

    if ($action eq 'update') {
    	$self->_setConcreteUpdateRadioButton();
    } else {
		$self->_selectInstall();
    }
}

sub _setConcreteUpdateRadioButton {
	my ($self) = @_;

	my $app = Wx::wxTheApp();
	my $instconfig = $app->getActionConfiguration();
	# Batch value is set even if the tool is not started in batch mode
	my $sid = $instconfig->{params}->{Action_SID}->{batchValue}; 

	if (!defined $sid) {
		$self->_setDefaultAction();
		return;
	}
	$self->_selectUpdate();
}

sub _setDefaultAction {
	my ($self) = @_;
	if ($self->{_isUpdateCtrlsCreated} && (scalar @{$self->{_installedSIDs}} > 0)) {
        $self->_selectUpdate();
        return;
    }
    if ($self->{_isPendingInstallCtrlsCreated}) {
    	$self->_selectPendingInstall();
    	return;
    }
	$self->_selectInstall();
}

sub _setSidValueToUpdateComboBox {
	my ($self, $cb_SIDs) = @_;

	if (!defined $cb_SIDs) {
		return undef;
	}

	my $app = Wx::wxTheApp();
    my $instconfig = $app->getActionConfiguration();
    # Batch value is set even if the tool is not started in batch mode
    my $sid = $instconfig->{params}->{Action_SID}->{batchValue}; 
    if (defined $sid) {
    	my @systems = $cb_SIDs->GetStrings();
    	my $index = -1;    	
    	for (@systems) {
    		$index+=1;
    		if ($_ eq $sid) {
    			$cb_SIDs->SetSelection($index);
    			return 1;
    		}
    	}
    }

    return undef;
}

sub Process {
    my ($self, $config) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getActionConfiguration();
    my $wizard = $self->GetWizard ();

    $self->_initSelectedAction();
    $self->_addGuiDialogsInWizard();

    if ($self->_isInstall() || $self->_isPendingInstall()) {
        if(!$self->_isServerAvailable()) {
            $instconfig->setErrorMessage("$gProductNameEngine was not detected from the provided resources.");
            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
            return {'errstate' => 1};
        }
        if ($self->_isPendingInstall()) {
            my $sid = $self->{combo_pendingInstall}->GetValue();
            $app->getActionConfiguration()->setValue('Action_SID', $sid);
        }
        $instconfig = $app->createConfiguration('install', $self->_isPendingInstall());
        bless ($self->GetNext(), 'LCM::Gui::Dialogs::SelectComponentsForInstallDialog') if ( ! $self->_isPendingInstall() );
    } elsif ($self->_isUpdate()) {
        bless ($self->GetNext(), 'LCM::Gui::Dialogs::SelectComponentsForUpdateDialog');
        $instconfig = $app->createConfiguration('update');
        if ( $instconfig->isOnlyComponentDetected($gProductNameEngine) ) {
            $self->GetNext()->disableButtonsForComponentsSelection();
        }
    } elsif ($self->_isPendingUpdate()) {
        $instconfig = $app->createConfiguration('update');
    }
    if (!$instconfig->InitDefaults()) {
        $app->ShowErrorMsg("Fatal Error", $instconfig->getErrMsgLst());
        return undef;
    }
    $app->setInstconfig($instconfig);

    my $executor = $self->createExecutor($instconfig);
    $app->setExecutor($executor);
    
    if (!$app->getCLIParser()->parse(0)) {
        return {'errstate' => 1};
    }

    my $controller = CreateControllerForScenario($instconfig->getAction(), $instconfig, $wizard);
    $wizard->{controller} = $controller;
    my $shouldSkipSelectComponentsDialog = defined $controller->getMapDialogIdToSkipPredicates()->{'SelectComponents'} && $controller->getMapDialogIdToSkipPredicates()->{'SelectComponents'}->();
    $wizard->SkipDialog('SelectComponents') if $shouldSkipSelectComponentsDialog;

    $instconfig->{'params'}->{'SelectedComponents'}->{'set_interactive'} = 0;
    if ($self->_isUpdate() || $self->_isPendingUpdate()) {
        if (defined $instconfig->{'params'}->{'Timezone'}) {
            $instconfig->{'params'}->{'Timezone'}->{'skip'} = 1;
        }
    }

    $wizard->init();
    my $isGui = $app->isGUIApplication();
    my $isNotResume;
    if ($self->_isUpdate() || $self->_isPendingUpdate()) {
        my $sid = $self->{cb_installations}->GetValue();
        if (!$instconfig->setValue('SelectedSystem', $sid)) {
            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
            return undef;
        }
        if($self->_isPendingUpdate() && $isGui){
            my $wizard = $self->GetWizard ();
            $instconfig->setDialogsDependOnPersistedComponents($wizard);
            my $pendingConfig = $instconfig->getPendingConfiguration();
            if ($pendingConfig){
                my $msg = $pendingConfig->getErrorString();
                Wx::MessageBox($unableToContinueUpdateMsg."\n".$msg , "Info", wxOK | wxCENTRE | wxICON_INFORMATION, $self )if ($msg);
            }
        }
# Make sure that Action_SID is set, because this will trigger the needed call for preparing the
# execution environment in case of sidadm execution. This might result in repeated values in LD_LIBRARY_PATH
# in case of Next->Back->Next !!!!
        $app->getActionConfiguration()->setValue('Action_SID', $sid);
    }

    $instconfig->setPendingInstallation(0);
    if ($self->_isPendingInstall()) {
        my $sid = $self->{combo_pendingInstall}->GetValue();
        $app->getActionConfiguration()->setValue('Action_SID', $sid);

        $instconfig->setPendingInstallation(1);
        $instconfig->{current_sid} = $sid;
        my $sapSystems = CollectSAPSystems();
        if( defined $sapSystems->{$sid} ){
            $instconfig->{params}->{Target}->{value} = $sapSystems->{$sid}->get_target();
        }
        $instconfig->setValue('SID',$sid);
        $instconfig->handlePendingInstall($sid);
    }

    if (!$instconfig->CheckParams(0)) {
        $app->ShowErrorMsg ('Error', $instconfig->getErrMsgLst());
        return {errstate => 1};
    }
    my $componentManager = $instconfig->getComponentManager();
    my $curFlavour = $componentManager->getHANAFlavour();
    if ($curFlavour ne $gFlavourPlatform && !$instconfig->setBatchValueOfRequiredParams('SelectedComponents')) {
        return {errstate => 1};
    }
    $instconfig->setSkip('SelectedSystem', 1);

    my $oldcontext = $instconfig->setMsgLstContext($app->getMsgLstContext());
    if (!defined $instconfig->checkSystemRequirements ($app->GetSysInfo())){
        if ($instconfig->getIgnore ('check_hardware')){
           $app->{msglst}->addMessage ("Ignoring error due to command line switch '--ignore=check_hardware'");
        }
        else{
           $app->ShowErrorMsg ('Installation failed', $instconfig->getErrMsgLst());
           return {'errstate' => 1};
        }
    }
    $instconfig->setMsgLstContext($oldcontext);

    if ( $self->_isPendingInstall() && ! $instconfig->validatePersistency() ) {
        $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
        return {'errstate' => 1};
    }
    if ( $self->_shouldAddCondensedSteps() || ($self->_isPendingUpdate() && !$instconfig->canContinueUpdate()) ) {
        $self->_addCondensedSteps();
    }
    return {};
}

sub _shouldAddCondensedSteps {
	my ($self) = @_;

	if ($self->_isPendingInstall()) {
		return 0;
	}

	my $selectedSid = $self->{'cb_installations'}->GetValue();

	if ($self->_isPendingUpdate() && existsHdblcmPendingUpdate($selectedSid)) {
		return 0;
	}

	return 1;
}

sub _addCondensedSteps {
    my ($self) = @_;

	my $configuration = Wx::wxTheApp()->{instconfig};
	my $wizard = $self->GetWizard();
	my $controller = $wizard->{controller};
	my $previousDialogId = $self->GetNext()->GetID();
	$wizard->ResetCondensedStep('input');
	my $condensedSteps = $controller->getCondensedSteps();
	my $mapDialogIdToSkipPredicates = $controller->getMapDialogIdToSkipPredicates();

	foreach my $dialog (@{$condensedSteps}){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $mapDialogIdToSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();
	}
}

sub _initSelectedAction {
    my ($self) = @_;
    my $app = Wx::wxTheApp;
	my $actionConfig = $app->getActionConfiguration();
	$actionConfig->setPendingInstallation(0);

	$self->_setInstall(0);
	$self->_setPendingInstall(0);
	$self->_setUpdate(0);
	$self->_setPendingUpdate(0);
	if ( defined $self->{'rb_install'} && $self->{'rb_install'}->GetValue() ) {
		$self->_setInstall(1);
	} elsif ( defined $self->{'rb_pendingInstall'} && $self->{'rb_pendingInstall'}->GetValue() ) {
		$self->_setPendingInstall(1);
		$actionConfig->setPendingInstallation(1);
	} elsif ( defined $self->{'rb_update'} && $self->{'rb_update'}->GetValue() ) {
		my $selectedSid = $self->{'cb_installations'}->GetValue();
		my $app = Wx::wxTheApp();
		my $instconfig = $app->getActionConfiguration();
		my $isPending = grep { $_ eq $selectedSid } @{$self->_getPendingUpdateSIDs()};
		my $isPendingUpdateIgnored = grep { $_ =~ /check_pending_upgrade/} @ARGV;
		$isPending && ! $isPendingUpdateIgnored ? $self->_setPendingUpdate(1) : $self->_setUpdate(1);
	}
}

sub _getPendingUpdateSIDs {
	my ($self) = @_;
	if (! defined($self->{_pendingUpdateSIDs})) {
		$self->{_pendingUpdateSIDs} = [ getPendingUpdateSIDs({}) ];
	}
	return $self->{_pendingUpdateSIDs};
}

sub _setInstall {
	$_[0]->{_isInstall} = $_[1];
}

sub _isInstall {
	return $_[0]->{_isInstall};
}

sub _setUpdate {
	$_[0]->{_isUpdate} = $_[1];
}

sub _isUpdate {
	return $_[0]->{_isUpdate};
}

sub _setPendingInstall {
	$_[0]->{_isPendingInstall} = $_[1];
}

sub _isPendingInstall {
	return $_[0]->{_isPendingInstall};
}

sub _setPendingUpdate {
	$_[0]->{_isPendingUpdate} = $_[1];
}

sub _isPendingUpdate {
	return $_[0]->{_isPendingUpdate};
}

sub _addGuiDialogsInWizard {
	my ($self) = @_;

	my $wizard = $self->GetWizard ();
	$wizard->unterminateChain();
	my $selectedSid = $self->{'cb_installations'}->GetValue();

	if(! $self->_isPendingUpdate()) {
		$self->_addActionGuiDialogsInWizard();
		$self->_removeActionGuiDialogsFromWizard();
		$self->_addSummaryExecutionFinalizeDialogs($wizard);
	}

	$wizard->terminateChain();
}

sub _addSummaryExecutionFinalizeDialogs {
	my ($self, $wizard) = @_;

	$wizard->AddDialog (new LCM::Gui::Dialogs::SummaryDialog ($wizard));
	my $installDialog = new LCM::Gui::Dialogs::InstallDialog ($wizard);
	$installDialog->{name} = "Execute";
	$wizard->AddDialog ($installDialog);
	
    my $app = Wx::wxTheApp;
    my $configuration = $app->getInstconfig();
    my $componentManager = $configuration->getComponentManager ();
    my $curFlavour = $componentManager->getHANAFlavour();
	if( $curFlavour ne $gFlavourPlatform) {
	   $wizard->AddDialog (new LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog ($wizard));
	} else {
        $wizard->AddDialog (new LCM::Gui::Dialogs::FinalizeDialog ($wizard));
	}
}

sub _addActionGuiDialogsInWizard {
	my ($self) = @_;
	my $wizard = $self->GetWizard ();

	$wizard->AddDialog (new LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog ($wizard))		if $self->_isPendingInstall();
	$wizard->AddDialog (new LCM::Gui::Dialogs::SelectComponentsDialog ($wizard))					if ($self->_isInstall() || $self->_isUpdate());
	$wizard->AddCondensedStep('input','Configure')													if ($self->_isInstall() || $self->_isUpdate());
}

sub _removeActionGuiDialogsFromWizard {
	my ($self) = @_;
	my $wizard = $self->GetWizard ();
	if ( $self->_isPendingUpdate() ) {
		$wizard->TryToRemoveDialog($LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog::ID);
		$wizard->TryToRemoveDialog($LCM::Gui::Dialogs::SelectComponentsDialog::ID);
	} elsif ( $self->_isPendingInstall() ) {
		$wizard->TryToRemoveDialog($LCM::Gui::Dialogs::PendingSummaryDialog::ID);
		$wizard->TryToRemoveDialog($LCM::Gui::Dialogs::SelectComponentsDialog::ID);
	} else {
		$wizard->TryToRemoveDialog($LCM::Gui::Dialogs::PendingSummaryDialog::ID);
		$wizard->TryToRemoveDialog($LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog::ID);
	}
}

sub _isServerAvailable  {
	my ($self) = @_;

    my $instconfig = Wx::wxTheApp()->{instconfig};
    my $mediumComponentManager = $instconfig->getComponentManager();
    my $allComponents = $mediumComponentManager->getAllComponents();
    my $serverComponent = $mediumComponentManager->getComponentByKeyName($gKeynameEngine);

    return $serverComponent;
}

sub BackInit{
    my ($self, $config) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};

    $instconfig->resetMsgLstContext ();
    $self->GetWizard()->unterminateChain();

    return ($self->_isActionGivenViaCommandLine()) ? {auto_back => 1} : {};
}

sub OnComboBoxUpdate {
	my ($self, $evt) = @_;
	$self->_fillSystemDescription();
}

sub OnComboBoxPendingInstall {
    my ($self, $evt) = @_;
    $self->_fillSystemDescription(1);
    $self->_fillLSSpendingInstallDescription();
}

sub OnRBUpdate{
	my ($self, $evt) = @_;

	$self->_enableUpdateUi(1);
	$self->_enablePendingInstallUi(0);
    $self->_fillSystemDescription();
}

sub OnRBInstall{
	my ($self, $evt) = @_;

	$self->_enableUpdateUi(0);
	$self->_enablePendingInstallUi(0);
	$self->_hideSystemDescription();
}

sub OnRBPendingInstall{
    my ($self, $evt) = @_;

    $self->_enableUpdateUi(0);
    $self->_enablePendingInstallUi(1);
    $self->_fillSystemDescription(1);
    $self->_fillLSSpendingInstallDescription();
}

sub _hideSystemDescription{
	my ($self) = @_;

	$self->{description_box}->Show(0);
	$self->{description_list}->Show(0);	
}

sub _getSapSystem {
	my ($self) = @_;

	my $systemId;
	if ($self->{_isUpdateCtrlsCreated} && $self->{rb_update}->GetValue()) {
		$systemId = $self->{'cb_installations'}->GetValue();
	} elsif ($self->{_isPendingInstallCtrlsCreated} && $self->{rb_pendingInstall}->GetValue()) {
		$systemId = $self->{'combo_pendingInstall'}->GetValue();
	} else {
		return undef;
	}

	return $self->{_detectedSystems}->{$systemId};
}

sub _getLSSPendingInstallSID {
    my ($self) = @_;
    my $sid;

    if($self->{_isPendingInstallCtrlsCreated} && $self->{rb_pendingInstall}->GetValue()) {
        $sid = $self->{'combo_pendingInstall'}->GetValue();
        return $sid if( ! defined $self->{_detectedSystems}->{$sid});
    }
    return undef;
}

sub _selectUpdate{
	my($self) = @_;
    $self->{'rb_update'}->Enable(1);
    $self->{'rb_update'}->SetFocus();
    $self->{'rb_install'}->SetValue(0);
    $self->{'rb_update'}->SetValue(1);
    $self->{'combo_pendingInstall'}->Enable(0) if defined $self->{'combo_pendingInstall'};
    $self->_setSidValueToUpdateComboBox($self->{'cb_installations'});
    $self->OnRBUpdate();
}

sub _selectInstall{
    my ($self) = @_;
    $self->{'rb_install'}->SetFocus();
    $self->{'rb_install'}->SetValue(1);
    $self->{'cb_installations'}->Enable(0) if defined $self->{'cb_installations'};
    $self->{'combo_pendingInstall'}->Enable(0) if defined $self->{'combo_pendingInstall'};
}

sub _selectPendingInstall{
    my ($self) = @_;
    $self->{'rb_pendingInstall'}->SetFocus();
    $self->{'rb_pendingInstall'}->SetValue(1);
    $self->{'cb_installations'}->Enable(0) if defined $self->{'cb_installations'};
	$self->OnRBPendingInstall();
}

sub createExecutor() {
    my ($self, $configuration) = @_;

    my $processTask;
    if($configuration->getAction()  eq INSTALL_ACTION){
        require LCM::Task::GenericStackTask::InstallProcessTask;
        $processTask =  LCM::Task::GenericStackTask::InstallProcessTask->new($configuration);
    } else {
        require LCM::Task::GenericStackTask::UpdateProcessTask;
        $processTask =  LCM::Task::GenericStackTask::UpdateProcessTask->new($configuration);
    }
    $configuration->{processTask} = $processTask;
    return $processTask;
    
}
1;
