package LCM::Gui::Dialogs::SelectActivityInstalledDialog;

use strict;

use Wx qw (wxVERTICAL wxHORIZONTAL wxTOP wxRIGHT wxDefaultPosition wxDefaultSize wxEXPAND wxALL wxALIGN_BOTTOM wxICON_ERROR wxCENTRE wxOK wxICON_INFORMATION wxVSCROLL);

use SDB::Install::SysVars qw($isWin);
use SDB::Install::System qw(isAdmin);
use SDB::Install::Saphostagent qw(getSaphostexecPath);
use SDB::Install::Gui::Design;
use SDB::Install::SAPSystem;
use LCM::Installer;
use LCM::Configuration::ActionConfiguration;
use LCM::Gui::Dialogs::Uninstall::SelectComponentsDialog;
use LCM::Gui::Dialogs::UiComponentsFactory;
use LCM::Gui::PagePredicates qw ( ShouldSkipHostagentPasswordPage ShouldSkipDatabaseCredentials
	ShouldSkipEsStoragePage ShouldSkipRDSyncStoragePage ShouldSkipAcceleratorPropertiesPage ShouldSkipOSLevelCredentials ShouldSkipXSSpaceIsolationPropertiesPage
	ShouldSkipSystemPropertiesPage ShouldSkipXSAdvancedRenamePropertiesPage);
use LCM::Configuration::GenericStackUpdateConfiguration qw($unableToContinueUpdateMsg);
use LCM::Configuration::GenericStackAny qw(UPDATE_ACTION);

use base 'LCM::Gui::Dialogs::SelectActivityDialog';

our $resources = new SAPDB::Install::Resources ();
our $images = $resources->getImages (qw(icon/warning.png));

sub new{
    my($self) = shift->SUPER::new(@_);
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{instconfig};

    $self->{id} = 'SelectActivityInstalled';
    $self->{name} = "Select Activity";

    my $is_gtk1 = Wx::wxGTK1 ();
    my $outerSizer = new Wx::BoxSizer (wxVERTICAL);
    my $innerSizer = new Wx::BoxSizer (wxVERTICAL);
    my $leftInnerSizer = new Wx::BoxSizer(wxVERTICAL);
    my $scrolledPanel = new Wx::ScrolledWindow($self, -1, wxDefaultPosition, wxDefaultSize, wxVSCROLL);

    $scrolledPanel->SetSizer($leftInnerSizer);
    $scrolledPanel->SetScrollbars(20, 20, 50, 50);
    $scrolledPanel->SetBackgroundColour(SDBBGCOLOUR_WizardDialog);
    $outerSizer->Add($innerSizer, 1, wxALL | wxEXPAND, 20);
    $self->{'title'} = CreateTitle($self, 'Select activity',$is_gtk1);
    $innerSizer->Add($self->{'title'}, 0);

    my $numberOfApplicableActions = $self->_createRadioButtonsForApplicableActions($instconfig, $scrolledPanel, $leftInnerSizer);
    my $numberOfNotApplicableActions = $self->_createRadioButtonsForNotApplicableActions($instconfig, $scrolledPanel, $leftInnerSizer);

    if ($numberOfApplicableActions == 0) {
    	$self->_disableNextButton();
    }
    my $innerBottomSizer;
    if ($numberOfNotApplicableActions > 0) {
    	$innerBottomSizer = new Wx::BoxSizer(wxHORIZONTAL);
    	my $message = "hdblcmgui must be started as root user if you want to select one of the disabled actions.";
    	$self->_addInformationMessage($innerBottomSizer, $message);
    } elsif ($self->_hasPendingSlaveOperation($instconfig)) {
    	my $pendingSlaveOperations = $self->_getPendingSlaveOperation($instconfig);
    	$innerBottomSizer = new Wx::BoxSizer(wxHORIZONTAL);
    	my $message = $self->_constructWarningMessageForPendingSlaveOperations($instconfig, $pendingSlaveOperations);
    	$self->_addInformationMessage($innerBottomSizer, $message);
    }
    
	my $descriptionSizer = $self->_createDescriptionSizer ();
	
	my $innerHorizontalSizer = new Wx::GridSizer(1, 2, 0, 70);
	$innerHorizontalSizer->Add($scrolledPanel, 1, wxEXPAND);
	$innerHorizontalSizer->Add($descriptionSizer, 1, wxEXPAND);

	$innerSizer->Add ($innerHorizontalSizer,1, wxEXPAND | wxTOP, 30);
	if (defined $innerBottomSizer) {
		$innerSizer->Add ($innerBottomSizer, 0, wxEXPAND | wxALIGN_BOTTOM | wxTOP, 30);
	}

	$self->SetSizer($outerSizer);
	$self->SetAutoLayout (1);

    return $self;
}

sub _constructWarningMessageForPendingSlaveOperations {
	my ($self, $instconfig, $operations) = @_;
	
	my $message = "";
	
	my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
	my %actionToScenarioMapping = (
		configure_internal_network => "Configure Inter-Service Communication",
		update_host => "Continue Update $flavourProductName System",
		rename_system => "Rename the $flavourProductName System"
	);
	
	for my $action (keys %{$operations}){
		my $scenario = $actionToScenarioMapping{$action};
		my $hosts = $operations->{$action};
		$message .= "\n" if ($message);
		$message .= "The action '${scenario}' is not finished yet. To complete it, run 'hdblcm --action=$action' on host(s):";
		for my $host (@$hosts){
			$message .= "$host, ";
		}
		$message = substr($message, 0, length($message) - 2);
	}
	return $message;
}

sub _hasPendingSlaveOperation {
	my ($self, $instconfig) = @_;
	return 0 unless ($instconfig->can('hasPendingSlaveOperations'));
	return $instconfig->hasPendingSlaveOperations();
}

sub _getPendingSlaveOperation {
	my ($self, $instconfig) = @_;
	return {} unless ($instconfig->can('getPendingSlaveOperations'));
	return $instconfig->getPendingSlaveOperations();
}

sub _createRadioButtonsForApplicableActions {
	my ($self, $instconfig, $parentPanel, $leftInnerSizer) = @_;
    my ($actionValidValues, $validUiActions) = $self->_getApplicableActions();
	
	for my $index (0 .. (@$actionValidValues-1)) {
		$self->_addButton($parentPanel, $leftInnerSizer, $actionValidValues->[$index], $validUiActions->[$index], 1);
	}
	return @$actionValidValues;
}

sub _createRadioButtonsForNotApplicableActions {
    my ($self, $instconfig, $parentPanel, $leftInnerSizer) = @_;
    my ($actionValidValues, $validUiActions) = $self->_getNotApplicableActions();

    for my $index (0 .. (@$actionValidValues-1)) {
        $self->_addButton($parentPanel, $leftInnerSizer, $actionValidValues->[$index], $validUiActions->[$index], 0);
    }
    return @$actionValidValues;
}

sub _addButton {
    my ($self, $parentPanel, $sizer, $buttonName, $buttonLabel, $enable) = @_;
    my $is_gtk1 = Wx::wxGTK1 ();
    if( $buttonLabel eq 'Update Component List'){ return; }
    $self->{"rb_$buttonName"} = CreateRadioButton($parentPanel, "&$buttonLabel", $is_gtk1);
    $sizer->Add($self->{"rb_$buttonName"}, 0, wxEXPAND |wxRIGHT, 20);
    $sizer->AddSpacer(12);	
    $self->{"rb_$buttonName"}->Enable($enable);
}

sub _disableNextButton {
	my ($self, ) = @_;
	$self->GetWizard()->DisableNextButton();
}

sub _addInformationMessage {
	my ($self, $innerBottomSizer, $message) = @_;
	
	my $informationTextMessage = new Wx::StaticText($self,-1,$message, wxDefaultPosition, wxDefaultSize);
	
    my $warningBitmap = Wx::StaticBitmap->new($self, -1, new Wx::Bitmap ($images->{'icon/warning.png'}));
    $innerBottomSizer->Add($warningBitmap,0, wxALIGN_BOTTOM, 0);
    $innerBottomSizer->AddSpacer(5);
    $innerBottomSizer->Add($informationTextMessage, 0, wxALIGN_BOTTOM, 0);
}

sub _getDetector {
	my ($self, ) = @_;
	
	if ( !defined $self->{detector} ) {
		my $app = Wx::wxTheApp();
		my $config = $app->{instconfig};
	    my $numberOfSystemHosts = getNumberOfSystemHosts();
		
		$self->{detector} = new LCM::ActionsDetector($config, $numberOfSystemHosts, $isWin, 1);
	}
	
	return $self->{detector};
}

sub _getNotApplicableActions {
	my ($self,) = @_;
	my $detector = $self->_getDetector();
	return $detector->getNotApplicableActions();
}

sub _getApplicableActions {
    my ($self,) = @_;
    my $detector = $self->_getDetector();
    return $detector->getApplicableActions();
}

sub getNumberOfSystemHosts {
    my $installer  = new LCM::Installer();
    my $sid        = $installer->getSid();
    my $allSystems = CollectSAPSystems( undef, 1 );
    my $sapSys     = (defined $sid) ? $allSystems->{$sid} : undef;
    my $instance   = (defined $sapSys && $sapSys->hasNewDB())
                     ? $sapSys->getNewDBInstances()->[0] : undef;
    my $allHosts   = (defined $instance) ? $instance->get_allhosts() : undef;

    return (defined $allHosts) ? scalar @$allHosts : 0;
}

sub init{
	my ($self,$config) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getActionConfiguration();

	$self->_fillSystemDescription();
	
	$self->_setUiAction($instconfig);
    $self->Layout();
    
	return {};
}

sub _setUiAction {
    my ($self, $instconfig) = @_;
    my $actionsDetector = $self->_getDetector();
    my $paramAction = $instconfig->{params}->{Action};
    
    if( $paramAction ) {
    	my $action = $paramAction->{batchValue};
    	if ( $actionsDetector->isActionApplicable( $action ) ) {
    		$self->{"rb_$action"}->SetValue(1);
    		return;
    	}
    }
    $self->_setDefaultAction();
}

sub _setDefaultAction {
    my ($self, ) = @_;
    my ($actionValidValues, $validUiActions) = $self->_getApplicableActions();
    my $defaultAction = $actionValidValues->[0]; 
    if(defined $defaultAction){
	    $self->{"rb_$defaultAction"}->SetValue(1);
    }
}


sub BackInit{
    my ($self, $config) = @_;
    
    my $app = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
    
    $instconfig->resetMsgLstContext ();
    $self->GetWizard()->unterminateChain();
    return {};
}

sub Process {
    my ($self,$config) = @_;
    
    my $app = Wx::wxTheApp;
    
    $self->_setAction ($app);
    my $actionConfig = $app->getActionConfiguration();
	my $action = $actionConfig->getAction();

    $app->setInstconfig($app->createConfiguration($action));
    my $instconfig = $app->getInstconfig();
    $app->setExecutor($app->createExecutor($action));
    require LCM::Gui::Wizard::SkipParameterEventHandler;
    $instconfig->addConfigurationChangeEventHandler(LCM::Gui::Wizard::SkipParameterEventHandler->new($self->GetWizard()));
    
    my $installer = new LCM::Installer();
    my $sid = $installer->getSid();
    my $logSuffix = $instconfig->getCustomLogSuffix();
	my $logName = "hdblcm" . ($logSuffix ? "_$logSuffix" : "");
    if ( !$app->defineLog( "hdblcm_$action", $logName, 0, $sid, 1) ) { # 1 for isGui == true
		$self->_showFatalError($app->getErrorString());
        return {'errstate' => 1}; 
    }
        
    if (!$instconfig->InitDefaults()) {
        $app->ShowErrorMsg("Fatal Error", $instconfig->getErrMsgLst());
        return undef;
    }
# In the resident update system case, hdblcmgui should not fail when encountering unknown parameters
    my $isUpdate = ($instconfig->getAction() eq UPDATE_ACTION) ? 1 : 0;
    if (!$app->getCLIParser()->parse($isUpdate)) {
        return {'errstate' => 1};
    }

    $instconfig->CheckParams(0);

    if (!isAdmin() && $isUpdate) {
        my $saphostexecPath = getSaphostexecPath();
        if(!defined $saphostexecPath) {
            my $currentUser = new SDB::Install::User();
            my $username = $currentUser->getname();
            my $message = "SAP Host Agent is required to perform $action as '$username' user. ";
            $message .=  "Either install SAP Host Agent or start hdblcm as root user.";;
            $self->_showFatalError($message);
            return undef;
        }
    }

	if($instconfig->can('setRequiredParamsValue')) {
		$instconfig->setRequiredParamsValue();
	}

	$self->_addGuiDialogsInWizard ();
	$self->_addConfigureDialogsInWizard ();
	require SDB::Install::ConfigurationChangeEvent;
    $instconfig->notifyConfigurationChangeEventHandlers
            (SDB::Install::ConfigurationChangeEvent->new($instconfig,undef,'skip'));
    return {};
}

sub _showFatalError {
	my ( $self, $message ) = @_;
	my $msgbox = Wx::MessageDialog->new($self,$message, "Fatal Error", wxICON_ERROR | wxCENTRE | wxOK);
	$msgbox->ShowModal();
}

sub _setAction{
	my ( $self, $app ) = @_;
	
	my ($actionValidValues, $validUiActions) = $self->_getApplicableActions();

    for (0 .. (@$actionValidValues-1)) {
    	my $actionRB = $self->{"rb_".$actionValidValues->[$_]};
    	
        my $isRBSelected = $actionRB->GetValue () if defined $actionRB;
        
        if( $isRBSelected ){
            $app->{actionInstconfig}->setValue("Action", $actionValidValues->[$_]);
            last;   
        }
    }
}

sub _addGuiDialogsInWizard{
	my ( $self, ) = @_;

	my $app = Wx::wxTheApp;
	my $instconfig = $app->{instconfig};
   	my $staticDialogs = $instconfig->getStaticDialogs ();

	my $wizard = $self->GetWizard ();
	my @dialogs = $self->_removeUnneccessaryDialogs(@$staticDialogs);

	$wizard->unterminateChain();
	$wizard->AddCondensedStep('input','Configure');
	for my $guiDialog (@dialogs){
		eval("use $guiDialog;");
		$wizard->AddDialog ($guiDialog->new ($wizard));
	}
	$wizard->terminateChain();
}

sub _addConfigureDialogsInWizard {
	my ( $self ) = @_;

	my $wizard = $self->GetWizard ();
	my $app = Wx::wxTheApp;
	my $instconfig = $app->{instconfig};
            
	my $configureDialogs = $instconfig->getConfigureDialogs ($wizard);
	
	my $pendingConfig = $instconfig->getPendingConfiguration();
	if(defined $pendingConfig){
	    my $msg = $pendingConfig->getErrorString();
	    Wx::MessageBox( $unableToContinueUpdateMsg."\n".$msg , "Info", wxOK | wxCENTRE | wxICON_INFORMATION, $self )if ($msg);
	}
	
	my $previousDialogId = $self->GetID ();
    my $shouldSkipPredicates = $self->_getShouldSkipPredicates();

	foreach my $dialog (@{$configureDialogs}){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $shouldSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();
	}
}

sub _getShouldSkipPredicates {
	return {
		"SHAPassword" => sub{ShouldSkipHostagentPasswordPage()},
		"DatabaseCredentials" => sub{ShouldSkipDatabaseCredentials()},
		"EsStoragePropertiesDialog" => sub{ShouldSkipEsStoragePage()},
		"RDSyncStoragePropertiesDialog" => sub{ShouldSkipRDSyncStoragePage()},
		"SystemUserProperties" => sub{ShouldSkipSystemPropertiesPage()},
		"AcceleratorProperties" => sub{ShouldSkipAcceleratorPropertiesPage()},
		"OSLevelCredentials" => sub{ShouldSkipOSLevelCredentials()},
		"XSSpaceIsolationProperties" => sub{ShouldSkipXSSpaceIsolationPropertiesPage()},
		"XSAdvancedRenameProperties" => sub{ShouldSkipXSAdvancedRenamePropertiesPage()},
	};
}

sub _removeUnneccessaryDialogs {
	my ($self, @dialogs) = @_;

	my $app = Wx::wxTheApp;
	my $actionConfig = $app->getActionConfiguration();
	my $action = $actionConfig->getAction();

	if($action eq 'uninstall') {
		my $wizard = $self->GetWizard ();
		my @components = LCM::Gui::Dialogs::Uninstall::SelectComponentsDialog::getExternalComponentsForUninstallation();
		if(scalar @components == 0) {
			@dialogs = grep {$_ ne 'LCM::Gui::Dialogs::Uninstall::SelectComponentsDialog'} @dialogs;
		}
	}

	return @dialogs;
}

sub _getSapSystem {
	my ($self) = @_;
	
	my $installer = new LCM::Installer ();
	return $installer->getOwnSapSystem ();
}

1;
