package LCM::Gui::Dialogs::SelectComponentSourceDialog;

use strict;

use Wx qw ( wxVERTICAL wxHORIZONTAL wxTOP wxLEFT wxRIGHT wxALIGN_LEFT wxEXPAND wxGROW wxALL wxDefaultPosition wxDefaultSize wxDefaultValidator wxICON_EXCLAMATION
	wxID_ADD wxBORDER_SIMPLE wxLC_SINGLE_SEL wxLC_REPORT wxLIST_AUTOSIZE wxOK wxICON_INFORMATION wxSYS_COLOUR_WINDOW wxLIST_AUTOSIZE_USEHEADER wxICON_ERROR wxCENTRE
	wxTE_MULTILINE wxTE_READONLY wxBORDER_NONE wxLIST_STATE_SELECTED wxLIST_STATE_FOCUSED wxLIGHT_GREY);
use Wx::Event qw (EVT_BUTTON EVT_LIST_ITEM_SELECTED EVT_LIST_ITEM_FOCUSED);

use SDB::Install::Globals qw($gShortProductNameXS2 $gProductNamePlatform $gXSAAppsOnlyDetectedMessage);
use SDB::Install::Gui::Control::Button;
use SDB::Install::Gui::Design;
use LCM::ComponentManager::MediumComponentManager;
use LCM::Gui::Dialogs::AddComponentSourceDialog;
use File::Basename;
use LCM::Gui::Dialogs::UiComponentsFactory;
use base qw (SAPDB::Install::Wizard::Dialog::Base);

our $SYSTEM_BACKGROUND = Wx::SystemSettings::GetColour ( wxSYS_COLOUR_WINDOW );
our $COLOR_LIGHT_BLUE = new Wx::Colour ( 229, 241, 255 );

sub new {
	my ( $self ) = shift->SUPER::new ( @_ );
	my $is_gtk1 = Wx::wxGTK1 ();

	$self->{id}   = 'ComponentSource';
	$self->{name} = "Select Software Locations";

	my $sizer = new Wx::BoxSizer ( wxVERTICAL );

	my $title = CreateTitle ($self, 'Select Software Component Locations', $is_gtk1);
	$sizer->Add ( $title, 0, wxLEFT | wxRIGHT | wxTOP, 20 );
	$sizer->AddSpacer ( 5 );

	my $detectedComponentsSizer = $self->_createDetectedComponentsSizer ();
	
	my $warning = $self->_addWarning();
	$detectedComponentsSizer->Add ( $warning, 0, wxLEFT | wxEXPAND | wxGROW | wxALL, 10 );
	$self->{warning} = $warning;
	
	$sizer->Add ( $detectedComponentsSizer, 1, wxLEFT | wxEXPAND | wxGROW | wxALL, 20 );
	
	$self->SetSizer ( $sizer );
	$self->SetAutoLayout ( 1 );
	return $self;
}

sub _createDetectedComponentsSizer {
	my ( $self ) = @_;
	my $sizer = new Wx::BoxSizer ( wxVERTICAL );

	my $title = new Wx::StaticText ( $self, -1, 'Detected Software Components ', wxDefaultPosition,
		wxDefaultSize );
	$sizer->Add ( $title, 0, wxLEFT | wxRIGHT | wxTOP, 0 );
	$sizer->AddSpacer ( 10 );

	my $componentsList = $self->_createComponentsListCtrl ();
	$self->{componentsList} = $componentsList;
	$sizer->Add ( $componentsList, 1, wxLEFT | wxEXPAND | wxGROW | wxRIGHT, 0 );
	$sizer->AddSpacer ( 10 );

	my $buttonsSizer = Wx::BoxSizer->new ( wxHORIZONTAL );
	$self->_addButtons ( $buttonsSizer );
	$sizer->Add ( $buttonsSizer, 0, wxALIGN_LEFT | wxLEFT, 0 );

	return $sizer;
}

sub _addWarning() {
	my ($self) = @_;
    my $warning = new Wx::TextCtrl ( $self, ,-1, "",[-1,-1], [-1,100], wxTE_MULTILINE | wxTE_READONLY | wxBORDER_NONE);
	return $warning;
}

sub _createComponentsListCtrl {
	my ( $self ) = @_;
	my $list = Wx::ListCtrl->new ( $self, 0, wxDefaultPosition, wxDefaultSize, wxBORDER_SIMPLE | wxLC_REPORT | wxLC_SINGLE_SEL | wxEXPAND | wxGROW, wxDefaultValidator );

	$list->InsertColumn ( 0, "Component" );
	$list->InsertColumn ( 1, "Version" );
	$list->InsertColumn ( 2, "Location" );

	$list->SetColumnWidth ( 0, wxLIST_AUTOSIZE_USEHEADER );
	$list->SetColumnWidth ( 1, wxLIST_AUTOSIZE_USEHEADER );
	$list->SetColumnWidth ( 2, wxLIST_AUTOSIZE_USEHEADER );

	EVT_LIST_ITEM_SELECTED($list, $list->GetId, $self->can('_disableSelection'));
	EVT_LIST_ITEM_FOCUSED($list, $list->GetId, $self->can('_disableSelection'));

	return $list;
}

sub _disableSelection {
	my($list, $event) = @_;
	$list->SetItemState($event->GetIndex(), 0, wxLIST_STATE_SELECTED);
	$list->SetItemState($event->GetIndex(), 0, wxLIST_STATE_FOCUSED);
}

sub _addButtons {
	my ( $self, $buttonsSizer ) = @_;

	my $addButton = new SDB::Install::Gui::Control::Button ( $self, wxID_ADD, '&Add Component Location...', wxDefaultPosition, wxDefaultSize );
	EVT_BUTTON ( $self, $addButton->GetId, \&_addButtonAction );
	$buttonsSizer->Add ( $addButton );
	$buttonsSizer->AddSpacer ( 5 );

	my $restoreButton = new SDB::Install::Gui::Control::Button ( $self, -1, '&Restore default', wxDefaultPosition, wxDefaultSize );
	EVT_BUTTON ( $self, $restoreButton->GetId, \&_restoreButtonAction );
	$buttonsSizer->Add ( $restoreButton );
}

sub _addButtonAction {
	my ( $self, $evt ) = @_;

	my $dlg = new LCM::Gui::Dialogs::AddComponentSourceDialog ( $self );
	my $retCode = $dlg->ShowModal ();
	if ( $retCode != $dlg->GetAffirmativeId () ) {
		return;
	}

	my $path = $dlg->GetSelectedPath ();
	my $instconfig = Wx::wxTheApp ()->{instconfig};
	
	#use new component manager here to override default selection
	my $mcm = new LCM::ComponentManager::MediumComponentManager($instconfig);
	
	my $rc;
	if ( $dlg->IsSearchRecursive () ) {
	      $rc = $mcm->detectComponentsByFsRoot ( $path, 1 );
	} else {
	      $rc = $mcm->detectComponentsByDirectoryList ( [$path], undef, 1 );
	}
	if($rc == 2 ) {
	      my $errorString = $mcm->getErrorString();
	      my $msgDialog = new Wx::MessageDialog ( $self, $errorString, "Error", wxOK | wxICON_ERROR);
	      $msgDialog->ShowModal ();
	      return;
	}

	my $detectedComponents = [ @{$mcm->getAllComponents()}, @{$mcm->getXs2ApplicationComponents()} ];
	if ( not scalar @$detectedComponents ) {
		my $msgDialog =
			new Wx::MessageDialog ( $self, "No components were found in the specified location",
			"Info", wxOK | wxICON_INFORMATION );
		$msgDialog->ShowModal ();
		return;
	}
	
	
	$self->_setWarning($mcm);

	foreach my $component ( @$detectedComponents ) {
		$self->_getInstconfig();
		if ($self->_getInstconfig()->isBootstrapFromResident() && $component->isServer() && $self->isComponentLocationChanged($component)) {
			next;
		}
		$self->_addComponent ( $component );
		$self->{changed} = 1;
	}
}

sub _addComponent {
	my ( $self, $component ) = @_;

	return if ( $component->isInternal () );

	my $components = $self->_getComponentList     ();
	my $listCtrl   = $self->_getComponentListCtrl ();

	my $id;
	my $componentIndex = $self->_getComponentIndex ( $component );
	if ( defined $componentIndex ) {
		splice( @$components, $componentIndex, 1, $component );
		$id = $componentIndex;
	} else {
		push @$components, $component;
		$id = $#$components;
		my $item = new Wx::ListItem ();
		$item->SetId          ( $id );
		$listCtrl->InsertItem ( $item );
	}

	$listCtrl->SetItem ( $id, 0, $component->getComponentName () );
	$listCtrl->SetItem ( $id, 1, $component->getVersion       () );
	$listCtrl->SetItem ( $id, 2, $component->getPath          () );

	my $locationChanged = $self->isComponentLocationChanged ( $component );
	my $isBootstrap = $self->_getInstconfig()->isBootstrapFromResident();
	my $defaultColor = ($isBootstrap && $component->isServer()) ? wxLIGHT_GREY : $SYSTEM_BACKGROUND;

	my $color = $locationChanged ? $COLOR_LIGHT_BLUE : $defaultColor;
	$listCtrl->SetItemBackgroundColour ( $id, $color );

	$listCtrl->SetColumnWidth ( 0, wxLIST_AUTOSIZE );
	$listCtrl->SetColumnWidth ( 1, wxLIST_AUTOSIZE );
	$listCtrl->SetColumnWidth ( 2, wxLIST_AUTOSIZE );
}

sub _restoreButtonAction {
	my ( $self, $evt ) = @_;

	$self->fillDefaultComponentLocations ();
	$self->_setColumnsSize               ();
	if ( !$self->{componentManagerChanged} ) {
		$self->{changed} = 0;
	}
}

sub _getComponentIndex {
	my ( $self, $component ) = @_;

	my $components = $self->_getComponentList ();
	for ( my $i = 0; $i <= $#$components; $i++ ) {
		if ( $component->getComponentKeyName () eq $components->[$i]->getComponentKeyName () ) {
			return $i;
		}
	}
	return undef;
}

sub _getComponentList {
	my ( $self ) = @_;
	if ( not defined $self->{components} ) {
		$self->{components} = [];
	}
	return $self->{components};
}

sub _clearComponentList {
	my ( $self ) = @_;
	if ( defined $self->{components} ) {
		$self->{components} = [];
	}
}

sub _getComponentListCtrl() {
	return $_[0]->{componentsList};
}

sub _getInstconfig() {
	return Wx::wxTheApp->getActionConfiguration ();
}

sub _getComponentManager {
	return Wx::wxTheApp->{instconfig}->getComponentManager ();
}

sub init {
	$_[0]->fillDefaultComponentLocations ();
	return {};
}

sub fillDefaultComponentLocations {
	my ( $self ) = @_;
	
	my $componentList = $self->_clearComponentList ();
	$self->_getComponentListCtrl ()->DeleteAllItems ();

	if ( !$self->{originalComponents} ) {
		my $mcm   = $self->_getComponentManager ();
		$self->{originalComponents} = [ @{$mcm->getAllComponents()}, @{$mcm->getXs2ApplicationComponents()} ];
		$self->_setWarning($mcm);
	}
	my $components = $self->{originalComponents};
	for my $component ( @{$components} ) {
		$self->_addComponent ( $component );
	}
}

sub _setWarning() {
	my ($self, $componentManager) = @_;
	my $error = $componentManager->getErrorString();
	$self->_setWarningText($error);
}

sub _setWarningText() {
	my ($self, $warningText) = @_;
	my $warning = $self->{warning};
	if ($warningText) {
		$warningText = "Warning: ". $warningText;
		$warning->Show(1);
	} else {
		$warningText = "";
		$warning->Show(0);
	}

    $warning->AppendText($warningText);	
	return $warning;
}

sub isComponentLocationChanged {
	my ( $self, $component ) = @_;
	my $originalComponents = $self->{originalComponents};
	for my $originalComponent ( @$originalComponents ) {
		if ( $component->getComponentKeyName () eq $originalComponent->getComponentKeyName () ) {
			my $cmpPath      = $component->getPath();
			my $originalPath = $originalComponent->getPath();

			return not( $cmpPath eq $originalPath );
		}
	}
	return 1;
}

sub Process {
	my ( $self, $config ) = @_;

	my @allComponents = ( @{ $self->_getComponentList () } );
    if ( scalar @allComponents == 0) {
		Wx::wxTheApp ()->ShowErrorMsg ( "You must select component(s) before next page." );
		return;
	}

	my @hanaPlatformComponents = grep { !$_->getManifest()->isXS2Application() } @allComponents;
	my @xsaApplications        = grep { $_->getManifest()->isXS2Application() } @allComponents;
	if (scalar(@hanaPlatformComponents) == 0) {
		my $errorMessage = "There are no $gProductNamePlatform components that could be installed or updated.";
		if (scalar(@xsaApplications) > 0) {
			$errorMessage .= " $gXSAAppsOnlyDetectedMessage";
		}
		Wx::MessageBox($errorMessage, "Error", wxOK|wxCENTRE|wxICON_EXCLAMATION, $self);
		return;
	}

	my $componentDirs = {};
	foreach my $component ( @allComponents ) {
		next if (!defined($component->getPath()));

		my $path = $component->getPath();
		$componentDirs->{$path} = 1;
	}

	my $componentsDirCsv = join(',', keys(%{$componentDirs}));

	if ( ! $self->{changed} ) {
		if ( ! $self->_getInstconfig ()->setValue ( 'ComponentDirs', $componentsDirCsv ) ) {
	        Wx::wxTheApp ()->ShowErrorMsg (${$self->_getInstconfig()->{errlst}->{msg_lst}->[0]->getMsgString()});
			return undef;
		}
		return {};
	}

	if ( ! $self->_resetParams ( $componentsDirCsv ) ) {
        Wx::wxTheApp ()->ShowErrorMsg (${$self->_getInstconfig()->{errlst}->{msg_lst}->[0]->getMsgString()});
        return undef;
    }
    
	$self->{componentManagerChanged} = 1;
	return {};
}

sub _resetParams {
	my ( $self, $componentsDirCsv ) = @_;

	$self->_getComponentManager ()->clearDetectedComponents ();

	$self->_getInstconfig ()->resetParam ( 'DvdPath' );
	undef $self->_getInstconfig ()->{params}->{'DvdPath'}->{init_with_default};

	$self->_getInstconfig ()->resetParam ( 'ComponentFsRoot' );
	undef $self->_getInstconfig ()->{params}->{'ComponentFsRoot'}->{init_with_default};

	return $self->_getInstconfig ()->setValue ( 'ComponentDirs', $componentsDirCsv );
}

sub _setColumnsSize {
	my ( $self ) = @_;

	my $listCtrl = $self->_getComponentListCtrl ();
	if ( $listCtrl->GetItemCount () ) {
		return;
	}

	my $numberOfColumns = $listCtrl->GetColumnCount ();
	for ( 0 .. $numberOfColumns ) {
		$listCtrl->SetColumnWidth ( $_, wxLIST_AUTOSIZE_USEHEADER );
	}
}

1;