package LCM::Gui::Dialogs::SelectComponentsDialog;

use base qw (LCM::Gui::Dialogs::SAPDSignerVerificationDialog);

use Wx qw (wxVERTICAL wxHORIZONTAL wxEXPAND wxTOP wxBOTTOM wxLEFT wxRIGHT wxDefaultPosition wxDefaultSize wxALIGN_LEFT wxOK wxCENTRE wxICON_EXCLAMATION wxGROW wxALL wxTE_MULTILINE wxTE_READONLY wxBORDER_NONE
	wxICON_ERROR wxCENTRE wxCANCEL wxID_OK);
use Wx::Event qw (EVT_BUTTON);

use SDB::Install::Gui::Design;
use SDB::Install::Gui::Control::Button;
use SAPDB::Install::Resources;
use LCM::Configuration::GenericStackAny qw ( INSTALL_ACTION UPDATE_ACTION);
use LCM::Gui::Dialogs::UiComponentsFactory;
use experimental qw (smartmatch);

use strict;

our $ID = 'SelectComponents';
our $resources = new SAPDB::Install::Resources();
our $images    = $resources->getImages(qw(icon/hint.png));

sub new{
    my($self) = shift->SUPER::new(@_);
	my $is_gtk1 = Wx::wxGTK1 ();
    $self->{id} = $ID;
	$self->{name} = "Select Components";

    my $sizer = new Wx::BoxSizer(wxVERTICAL);

    $self->{'title'} = CreateTitle($self, 'Choose components to be installed', $is_gtk1);
    $sizer->Add($self->{'title'}, 0, wxLEFT | wxRIGHT | wxTOP, 20);
    $sizer->AddSpacer(10);

	$self->{'title2'} = CreateTitle($self, 'Select additional components for installation', $is_gtk1);
    $sizer->Add($self->{'title2'}, 0, wxLEFT | wxRIGHT | wxTOP ,20);
	$sizer->AddSpacer(10);

	$self->{'checklist'} = CreateCheckListBox($self, $is_gtk1);
    $sizer->Add($self->{'checklist'}, 1, wxEXPAND | wxLEFT | wxRIGHT, 20);
    $sizer->AddSpacer(10);

	$self->{'gridSizerBottom'} = new Wx::StdDialogButtonSizer();
    $sizer->Add($self->{'gridSizerBottom'}, 0, wxALIGN_LEFT | wxBOTTOM , 10);

    $self->{'selectAllBtn'} = new SDB::Install::Gui::Control::Button($self, -1, '&Select All', wxDefaultPosition, wxDefaultSize);
	EVT_BUTTON($self, $self->{'selectAllBtn'}, \&_onSelectAllBtn);
	$self->{'gridSizerBottom'}->Add($self->{'selectAllBtn'}, 0, wxLEFT, 20);
	
	$self->{'deselectAllBtn'} = new SDB::Install::Gui::Control::Button($self, -1, '&Deselect All', wxDefaultPosition, wxDefaultSize);
	EVT_BUTTON($self, $self->{'deselectAllBtn'}, \&_onDeselectAllBtn);
	$self->{'gridSizerBottom'}->Add($self->{'deselectAllBtn'}, 0, wxLEFT, 5);

    my $boxSizer = new Wx::BoxSizer ( wxHORIZONTAL );
    $self->{'info_icon'} = Wx::StaticBitmap->new( $self, -1, new Wx::Bitmap( $images->{'icon/hint.png'} ) );
    $boxSizer->Add( $self->{'info_icon'}, 0, wxLEFT | wxTOP, 10 );
    my $info = $self->_getInfoTextCtrl();
    $boxSizer->Add ( $info, 1, wxLEFT | wxEXPAND | wxGROW | wxALL, 10 );
    $sizer->Add( $boxSizer, 1, wxALL | wxEXPAND, 10 );

    $self->SetSizer($sizer);
    $self->SetAutoLayout (1);
    return $self;
}

sub init {
    my ($self,$config) = @_;
	if (not defined $self->{initialized}) {
		my $app = Wx::wxTheApp ();
		my $instconfig = $app->getInstconfig();
		$instconfig->setBatchValueOfRequiredParams('VerifySignature');
		$instconfig->initializeSelectedComponents();

		$self->_fillCheckList();
        $self->_setInfoFromConfiguration();
		$self->_initializeCondensedSteps();
		$self->{initialized} = 1;
	}
	
	$self->Layout();
	
	return {};
}

sub _initializeCondensedSteps {
	my $self = shift;
	my $action = Wx::wxTheApp()->getInstconfig()->getAction();
	return if ($action eq INSTALL_ACTION || $action eq UPDATE_ACTION);

	my $previousDialogId = $self->GetID ();
	my $wizard = $self->GetWizard ();
	$wizard->ResetCondensedStep('input');
	my $condensedSteps = $self->_getCondensedSteps();
	my $shouldSkipPredicates = $self->_getShouldSkipPredicates();
	
	foreach my $dialog (@{$condensedSteps}){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $shouldSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();	
	}
}

sub _fillCheckList{
	my $self = shift;
	my $app = Wx::wxTheApp ();
	my $instconfig = $app->{'instconfig'};
	$self->{'allComopnents'} = [];
	
	$self->{'checklist'}->Clear();
	
	my $componentManager = $instconfig->{componentManager};
	my ($orderedKeynames, $componentKeynameToAction) = $instconfig->getComponentKeynameToAction();
	my $batchValueSelectedComponents = $instconfig->getBatchValue('SelectedComponents');
	if (defined $batchValueSelectedComponents){
		if (!$instconfig->getValue('VerifySignature')) {
			$instconfig->setValue('SelectedComponents', $batchValueSelectedComponents);
		} else {
# setValue here is called only so that we can properply fill the default selection
# in the component checklist. In this case we temporarily unset VerifySignature
			$instconfig->{params}->{VerifySignature}->{value} = 0;
			$instconfig->setValue('SelectedComponents', $batchValueSelectedComponents);
			$instconfig->{params}->{VerifySignature}->{value} = 1;
		}
	}
	my $index = 0;
	for my $componentKeyname ( @{$orderedKeynames} ) {
		my $action = $componentKeynameToAction->{$componentKeyname};
		next if ( $action =~ /^Uninstall/);
		my $component = $componentManager->getComponentByKeyName($componentKeyname);
		if ($component->isInternal() or !$component->canSelectComponent()) {
			next;
		}
		push(@{$self->{'allComopnents'}}, $component);
		
		my $requiresSystemRestart = $component->requireSystemRestart() && $instconfig->isUpdate();
		my $actionName = $action . ($requiresSystemRestart ? ' * ' : '');
		$self->{'checklist'}->Append($actionName);

        my $isComponentSelected;
        if (defined $batchValueSelectedComponents){
            $isComponentSelected = $component->isComponentSelected();
        } else {
    		$isComponentSelected = $self->_isComponentSelected($component);
        } 
		$self->{'checklist'}->Check($index, $isComponentSelected);

		$index++;
	}
}

sub _setInfoFromConfiguration{
    my $self = shift;
    my $app = Wx::wxTheApp ();
    my $instconfig = $app->{'instconfig'};
    
    $self->_setInfoText($instconfig->getCannotBeSelectedMessage());
}

sub _isComponentSelected{
	my ($self, $component) = @_;
	
	if ($component->isComponentSelected()) {
		return 1;
	}

	my $app = Wx::wxTheApp ();
	my $instconfig = $app->getInstconfig();
	my $defaultSelectedComponents = $instconfig->getDefault('SelectedComponents');	
	if( $defaultSelectedComponents eq 'all' ) {
		return 1;
	}
	
	my @defaultSelectedCmpBatchKeys = split(/\s*,\s*/, $defaultSelectedComponents);
	my $batchKey = $component->getComponentBatchKey();
	if ($batchKey ~~ @defaultSelectedCmpBatchKeys){
		return 1;
	}
	return 0;
}

sub _getInfoTextCtrl() {
    my ($self) = @_;
    $self->{info} = new Wx::TextCtrl ( $self, ,-1, "",[-1,-1], [-1,100], wxTE_MULTILINE | wxTE_READONLY | wxEXPAND | wxBORDER_NONE);
    return $self->{info};
}

sub _setInfoText() {
    my ($self, $infoText) = @_;
    if (!$infoText) {
        $infoText = "";
    }
    my $info = $self->{info};
    my $infoIcon = $self->{info_icon};
    if ($infoText eq "") {
        $info->Show(0);
        $infoIcon->Show(0);
    } else {
        $info->Show(1);
        $infoIcon->Show(1);
    }    
    $info->AppendText($infoText);
    return $info;
}

sub disableButtonsForComponentsSelection {
	my ($self, ) = @_;
	$self->{'selectAllBtn'}->Disable();
	$self->{'deselectAllBtn'}->Disable();
}

sub _onSelectAllBtn {
	my ($self, $event) = @_;
	$self->_onBtn(1);
	$self->_enableNextButton(1);
}

sub _onDeselectAllBtn {
	my ($self, $event) = @_;
	$self->_onBtn(0);
	$self->_enableNextButton(0);
}

sub _enableNextButton {
}


sub _onBtn {
	my ($self, $isSelected) = @_;
	
	for my $i (0..$#{$self->{'allComopnents'}}){
		my $component = $self->{'allComopnents'}->[$i];
		$self->{'checklist'}->Check($i, $isSelected);
	}
}

sub Process{
	my ($self) = @_;

	my $selectedComponentsCsv="";
	my $selectedComponentsArr = [];

	for my $i (0..$#{$self->{'allComopnents'}}){
		my $component = $self->{'allComopnents'}->[$i];
		my $batchKey = $component->getComponentBatchKey();

		if($self->{'checklist'}->IsChecked($i)){
			push @{$selectedComponentsArr}, $batchKey;
		}
	}

	if (scalar @{$selectedComponentsArr} > 0) {
		$selectedComponentsCsv = join(',', @{$selectedComponentsArr});
	}


	my $instconfig = Wx::wxTheApp()->getInstconfig();
	$instconfig->resetError ();
	my $rc = $instconfig->setValue('SelectedComponents', $selectedComponentsCsv);
	if (!$rc) {
		my $sapdsigner = LCM::SAPDSigner->getInstance();
		if (!defined($sapdsigner) || @{$sapdsigner->getAuthenticationErrors()}) {
			return undef;
		}
		Wx::MessageBox( $instconfig->GetErrorString (), "Configuration Error",
					 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );

		if ($instconfig->{'params'}->{'SelectedComponents'}->{'no_retry'}) {
			return {'errstate' => 1};
		}

		return undef;
	}
	$self->GetWizard()->RefreshSkippableDialogs();
	my $componentManager = $instconfig->getComponentManager();
	if ( ! $componentManager->isHanaOptionSelected() ) {
		$instconfig->clearHostsParameters();
	}
	return {};
}

1;
