package LCM::Gui::Dialogs::SelectComponentsForInstallDialog;

use LCM::Gui::Dialogs::AdditionalSystemDialog;
use SDB::Install::Gui::Dialogs::User;
use LCM::Gui::Dialogs::MasterPasswordDialog;
use LCM::Gui::Dialogs::DistributedSystemParamsDialog;
use SDB::Install::Gui::Dialogs::VolumePaths;
use SDB::Install::Gui::Dialogs::User;
use SDB::Install::Gui::Dialogs::SQLUser;
use LCM::Gui::Dialogs::EsStoragePropertiesDialog;
use LCM::Gui::Dialogs::AcceleratorPropertiesDialog;
use LCM::Gui::Dialogs::RDSyncPropertiesDialog;
use LCM::Gui::Dialogs::XSPropertiesDialog;
use LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog;
use LCM::Gui::Dialogs::SelectXsComponentsDialog;
use SDB::Install::Globals qw ($gKeynameEngine);
use SDB::Install::SysVars;
use LCM::Gui::Dialogs::HostagentPasswordDialog;
use LCM::Gui::Dialogs::CertificatesDialog;

use strict;
use Wx::Event qw (EVT_CHECKLISTBOX);

use base qw (LCM::Gui::Dialogs::SelectComponentsDialog);

sub new{
    my($self) = shift->SUPER::new(@_);
    $self->{id} = 'SelectComponentsForInstall';
    return $self;
}

sub init{
	my ($self,$config) = @_;

	$self->SUPER::init();
	
	my $componentManager = Wx::wxTheApp()->{instconfig}->{componentManager};
	my $serverComponent = $componentManager->getComponentByKeyName($gKeynameEngine);
    EVT_CHECKLISTBOX($self, $self->{'checklist'}, \&_OnCheckListBox);
	$self->{'title'}->SetLabel($serverComponent->getComponentName()." version '".$serverComponent->getVersion()."' will be installed.");
	$self->{'serverComponent'} = $serverComponent;
	
    return {};
}

sub _OnCheckListBox {
    my ($self, $event) = @_;
}


sub Process{
    my ($self) = @_;
    my $rc = $self->SUPER::Process();
    return undef if !defined($rc);

    if (!$rc->{'errstate'}) {
        $self->GetWizard()->init();
    }

    return $rc;
}

1;
