package LCM::Gui::Dialogs::SelectComponentsForResidentUpdateDialog;

use strict;

use LCM::Gui::Dialogs::UpgradeParameterDialog;
use LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog;
use LCM::Gui::Dialogs::StreamingPropertiesDialog;
use LCM::Gui::Dialogs::EsStoragePropertiesDialog;
use LCM::Gui::Dialogs::AcceleratorPropertiesDialog;
use LCM::Gui::Dialogs::RDSyncPropertiesDialog;
use LCM::Gui::Dialogs::XSPropertiesDialog;
use LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog;
use LCM::Gui::Dialogs::InternalNetworkPropertiesDialog;
use LCM::Gui::Dialogs::SelectXsComponentsDialog;
use SDB::Install::Gui::Design;
use LCM::Gui::PagePredicates qw(
								ShouldSkipUpgradeProperties
								ShouldSkipAdditionalHostsProperties
								ShouldSkipStreamingPropertiesPage
								ShouldSkipEsStoragePage
								ShouldSkipAcceleratorPropertiesPage
								ShouldSkipInternalNetworkPropertiesPage
								ShouldSkipRDSyncPropertiesPage
								ShouldSkipXSPropertiesPage
								ShouldSkipXSSpaceIsolationPropertiesPage
								ShouldSkipSelectXSApplicationsPage
								ShouldSkipLSSPropertiesDialog);

use base qw (LCM::Gui::Dialogs::SelectComponentsForUpdateDialog);

sub _initializeCondensedSteps {}

sub _fillResidentCondensedSteps {
	my $self = shift;
	my $previousDialogId = $self->GetID ();
	my $wizard = $self->GetWizard ();
	my $shouldSkipPredicates = $self->_getShouldSkipPredicates();
	
	foreach my $dialog (@{$self->_getCondensedSteps()}){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $shouldSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();	
	}
}


sub init {
	my ($self,$config) = @_;
	if(!$self->{residentCondensedStepsFilled}){
		$self->_fillResidentCondensedSteps();
		$self->{residentCondensedStepsFilled} = 1;
	}
	return $self->SUPER::init($config);
}

sub _getCondensedSteps {
	my $self = shift;
	my $wizard = $self->GetWizard ();

	my @condensedSteps = (
		new LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::UpgradeParameterDialog($wizard),
		new LCM::Gui::Dialogs::InternalNetworkPropertiesDialog($wizard)
	);
	if(Wx::wxTheApp()->getInstconfig()->areLSSParamsDefined()){
		push @condensedSteps, new LCM::Gui::Dialogs::LSSPropertiesDialog($wizard);
	}
	push @condensedSteps, (
		new LCM::Gui::Dialogs::StreamingPropertiesDialog( $wizard ),
		new LCM::Gui::Dialogs::EsStoragePropertiesDialog($wizard),
		new LCM::Gui::Dialogs::AcceleratorPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::RDSyncPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::XSPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog($wizard),
		new LCM::Gui::Dialogs::SelectXsComponentsDialog($wizard),
	);
	return \@condensedSteps;
}

sub _getShouldSkipPredicates {
	return {
		"UpgradeProperties"   => sub{ ShouldSkipUpgradeProperties() },
		"HostsProperties" => sub{ ShouldSkipAdditionalHostsProperties() },
		"LSSPropertiesDialog" => sub { ShouldSkipLSSPropertiesDialog() },
		"StreamingProperties" => sub{ ShouldSkipStreamingPropertiesPage() },
		"EsStoragePropertiesDialog" => sub{ ShouldSkipEsStoragePage() },
		"AcceleratorProperties" => sub{ ShouldSkipAcceleratorPropertiesPage() },
		'InterServiceCommunicationProperties' => sub{ ShouldSkipInternalNetworkPropertiesPage() },
		'RDSyncProperties' => sub { ShouldSkipRDSyncPropertiesPage() },
		'XSProperties' => sub { ShouldSkipXSPropertiesPage() },
		'XSSpaceIsolationProperties' => sub { ShouldSkipXSSpaceIsolationPropertiesPage() },
		'SelectXsComponents' => sub { ShouldSkipSelectXSApplicationsPage() },
	};
}

1;
