package LCM::Gui::Dialogs::Update::AddHostsPanel;

use strict;
use Wx qw ( wxVERTICAL wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD);
use LCM::Gui::DialogUtilities qw ( GetAppConfig );
use parent 'LCM::Gui::Dialogs::HostsPanel';

sub newFieldsSizer {
	my ($self) = @_;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	return $self->fieldsSizer( $instconfig);
}

sub fieldsSizer {
	my ($self, $instconfig) = @_;
	my $sizer = new Wx::FlexGridSizer( 3, 2, 5, 10 );
	my $window = $self->getWindow();

	$sizer->SetFlexibleDirection(wxHORIZONTAL);
	$sizer->AddGrowableCol(1);
	if(! $instconfig->isUseSAPHostagent()){
		$self->_addRootUserName($window, $sizer, $instconfig);
		$self->_addRootUserPassword($window, $sizer, $instconfig);
	} else {
		$self->_addHostagentPassword($window, $sizer, $instconfig);
	}
	$self->_addAutoAddXs2RolesCheckBox($sizer, $instconfig);

	$window->{_fieldsSizer} = $sizer;
	return $sizer;
}

sub setFieldProperties{
	my ($self,$instconfig) = @_;
}

sub newAddHostsSizer {
	my ( $self ) = @_;
	my $sizer = new Wx::BoxSizer(wxVERTICAL);

	$self->addHostsPanel($sizer);
	return $sizer;
}

sub _addRootUserName{
	my ($self, $window, $sizer, $instconfig)=@_;
	my $isMandatory = $instconfig->isSkipped("RootUser") ? 0 : 1;
	my $rootUserParam = $instconfig->{params}->{'RootUser'};
	my $rootUserValue = $instconfig->getValue('RootUser') || $instconfig->getBatchValue('RootUser') || $instconfig->getDefault('RootUser') || "";
	my $label = new SDB::Install::Gui::Control::Label( $window, -1, $rootUserParam->{str}, $isMandatory);

	$sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL);
	$self->addWindowControl('RootUserLabel', $label);
	$self->addWindowControl('RootUser', new Wx::TextCtrl($window, -1, $rootUserValue, wxDefaultPosition, [200, -1]));
	$sizer->Add($window->{Controls}->{'RootUser'}, 0, wxALIGN_CENTER_VERTICAL);
}

sub _addRootUserPassword{
	my ($self, $window, $sizer, $instconfig)=@_;
	my $isMandatory = $instconfig->isSkipped("RootPassword") ? 0 : 1;
	my $rootPassParam = $instconfig->{params}->{'RootPassword'};
	my $rootPasswordValue = $instconfig->getValue('RootPassword') || $instconfig->getBatchValue('RootPassword') || "";
	my $label = new SDB::Install::Gui::Control::Label( $window, -1, $rootPassParam->{str}, $isMandatory);

	$sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
	$self->addWindowControl('RootPasswordLabel', $label);
	$self->addWindowControl('RootPassword', new Wx::TextCtrl($window, -1, $rootPasswordValue, wxDefaultPosition, [200, -1], wxTE_PASSWORD));
	$sizer->Add( $window->{Controls}->{'RootPassword'}, 0, wxALIGN_CENTER_VERTICAL );
}

sub _addHostagentPassword{
	my ($self, $window, $sizer, $instconfig)=@_;
	my $isMandatory = $instconfig->isSkipped("HostagentPassword") ? 0 : 1;
	my $saphostAgentParam = $instconfig->{params}->{'HostagentPassword'};
	my $hostagentPasswordValue = $instconfig->getValue('HostagentPassword') || $instconfig->getBatchValue('HostagentPassword') || "";
	my $label = new SDB::Install::Gui::Control::Label( $window, -1, $saphostAgentParam->{str}, $isMandatory);

	$sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
	$self->addWindowControl( 'HostagentPasswordLabel', $label);
	$self->addWindowControl( 'HostagentPassword', new Wx::TextCtrl($window, -1, $hostagentPasswordValue, wxDefaultPosition, [200, -1], wxTE_PASSWORD) );
	$sizer->Add( $window->{Controls}->{'HostagentPassword'}, 0, wxALIGN_CENTER_VERTICAL );
}

sub _onAssignRoles {
	my ($self, $window) = @_;
	$self->SUPER::_onAssignRoles($window);
	$window->_handleAutoAddCheckBox();
}

sub _onRemoveHost {
	my ($self, $window) = @_;
	$self->SUPER::_onRemoveHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onEditHost {
	my ($self, $window) = @_;
	$self->SUPER::_onEditHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onAddHost {
	my ($self, $window) = @_;
	$self->SUPER::_onAddHost($window);
	$window->_handleAutoAddCheckBox();
}

1;