package LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog;

use strict;
use Wx qw (wxVERTICAL wxGROW wxALL wxEXPAND);
use experimental qw (smartmatch);

use parent 'LCM::Gui::Dialogs::AddHosts::AdditionalHostsPropertiesDialog';

use SDB::Install::Configuration::AddHostsParser;
use LCM::Gui::Dialogs::Update::AddHostsPanel;
use LCM::Gui::Dialogs::UiComponentsFactory;
use LCM::Gui::Dialogs::HostsPanel;
use SDB::Install::Globals qw (GetHostRoleProperties $gHostRoleXS2Standby $gHostRoleXS2Worker $gKeynameXS2);
use LCM::Gui::DialogUtilities;
use LCM::Component;

sub new {
	my ($self) = shift->SUPER::new(@_);

	$self->{existing_hosts} = ();
	$self->{hosts} = ();
	$self->{addRoles} = ();

	return $self;
}

sub init {
	my ($self) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};

	if($self->{isInitialized}){
		my $shouldShow = $self->_isXs2SelectedForInstall($instconfig) ? 1 : 0;
		$self->{addHostPanel}->getWindowControls()->{AutoAddXS2RolesLabel}->Show($shouldShow);
		$self->{addHostPanel}->getWindowControls()->{AutoAddXS2Roles}->Show($shouldShow);
		return {};
	}

	my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
	my $is_gtk1 = Wx::wxGTK1 ();
	my $sizer = new Wx::BoxSizer(wxVERTICAL);

	$instconfig->setBatchValueOfRequiredParams('SID');
	$self->SetSizer($outer_sizer);
	$self->{sizer} = $sizer;
	$outer_sizer->Add( $sizer, 1, wxALL | wxEXPAND, 20 );

	my $title = CreateTitle($self, 'Add Hosts', $is_gtk1);
	$sizer->Add($title, 0);
	$sizer->AddSpacer(20);

	my $hostsPanel = LCM::Gui::Dialogs::Update::AddHostsPanel->new($self);
	my $componentsSizer = $hostsPanel->addNewHostPanel( wxVERTICAL, 0, wxEXPAND, 40, wxEXPAND | wxGROW );

	$sizer->Add( $componentsSizer, 1, wxEXPAND );
	$self->{addHostPanel} = $hostsPanel;

	my $shouldShow = $self->_isXs2SelectedForInstall($instconfig) ? 1 : 0;
	$hostsPanel->getWindowControls()->{AutoAddXS2RolesLabel}->Show($shouldShow);
	$hostsPanel->getWindowControls()->{AutoAddXS2Roles}->Show($shouldShow);

	$self->loadHostsAndRoles($instconfig);
	$self->_addExistingHostsToListCtrl($instconfig);
	$self->_addHostsFromCmdLineToListCtrl();
	$self->SetAutoLayout(1);
	$self->{isInitialized} = 1;

	return {};
}

sub isHostExist {
	my ($self, $host) = @_;
	return exists($self->{existing_hosts}->{$host}) ? 1 : 0;
}

sub isHostRoleExist {
	my ($self, $host, $role) = @_;

	return 0 if ! exists $self->{existing_hosts}->{$host};

	my @existingHostRolesList = split(',', $self->{existing_hosts}->{$host});
	return $role ~~ @existingHostRolesList;
}

sub getExistingHostRoles {
	my ($self, $host) = @_;
	return '' if ! exists $self->{existing_hosts}->{$host};
	return $self->{existing_hosts}->{$host};
}

sub loadHostsAndRoles {
	my ($self, $instconfig) = @_;

	my $app = Wx::wxTheApp;
	my $ownInstance = $instconfig->getOwnInstance();
	$self->{existing_hosts} = $ownInstance->getHostRolesInfo();
	for my $host (keys %{$self->{existing_hosts}}){
		my $roles = $self->{existing_hosts}->{$host};
		$self->{existing_hosts}->{$host} = join(',', split(' ', $self->{existing_hosts}->{$host}));
	}

    my $addHostsValue = $instconfig->getValueOrBatchValue('AddHosts');
	if ( $addHostsValue ) {
		my $parser = new SDB::Install::Configuration::AddHostsParser();
		$parser->setMsgLstContext([$app->getMsgLst()]);
	
		if ( ! defined $parser->parse ( $addHostsValue ) ) {
			my $errorMessage = "Error parsing command line option " . $instconfig->getOpt('AddHosts');
			$app->ShowErrorMsg ($errorMessage, $parser->getErrMsgLst());
			return;
		}
	
		for my $host ( @{$parser->getHosts()} ) {
			next if(! $host);
			
			my @roles = @ { $parser->getRoles($host) };
			my $csvRoles = join(",", @roles);
			my $hostObj = {
				host => $host,
				roles => $csvRoles,
				group => $parser->getValue($host, 'group'),
				storage_partition => $parser->getValue($host, 'storage_partition')
			};
			$self->{hosts}->{$host} = $hostObj;
		}
	}

	$self->{addRoles} = $instconfig->getValueOrBatchValue('AddRoles');
}

sub _addExistingHostsToListCtrl {
	my ($self, $instconfig) = @_;

	my $validRoles = GetHostRoleProperties();
	for my $host ( sort keys %{$self->{existing_hosts}} ) {
		my @roles = split( ',', $self->{existing_hosts}->{$host} );
		if( exists $self->{addRoles}->{$host} ) {
			my @addRoles = split(",", $self->{addRoles}->{$host});
			for ( @addRoles ) {
				next if ($_ ~~ @roles || !exists($validRoles->{$_}));
				push( @roles, $_ ) ;
			}
		}
		my $hostObj = {
			host => $host,
			role => join( ',', @roles ),
			group => undef,
			storage_partition => undef
		};
		$self->{addHostPanel}->addHost(new LCM::AdditionalHostHelper($hostObj, 1), 0, 1);
	}
}

sub _addHostsFromCmdLineToListCtrl {
	my ($self) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};
	my $addHostsBatchValue = $instconfig->{'params'}->{'AddHosts'}->{'batchValue'};

	return if(! $addHostsBatchValue);

	my $parser = new SDB::Install::Configuration::AddHostsParser();
	$parser->setMsgLstContext([$app->getMsgLst()]);

	if ( ! defined $parser->parse ($addHostsBatchValue) ) {
		my $errorMessage = "Error parsing command line option " . $instconfig->getOpt('AddHosts');
		$app->ShowErrorMsg ($errorMessage, $parser->getErrMsgLst());
		return;
	}

	for my $host ( sort @{$parser->getHosts()} ) {
		next if(! $host || exists $self->{existing_hosts}->{$host});

		my $hostObj = {
			host => $host,
			role => join(",", @{$parser->getRoles($host)}),
			group => $parser->getValue($host, 'group'),
			storage_partition => $parser->getValue($host, 'storage_partition')
		};
		$self->{addHostPanel}->addHost( new LCM::AdditionalHostHelper($hostObj), 0 );
	}
}

sub Process {
	my ( $self, @args ) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	my $isUseSha = $instconfig->isUseSAPHostagent();

	$instconfig->resetError();
	$self->_resetParams();

	if (! $self->_validateAddHosts()) {
		return $self->errorState();
	}
	if (! $self->_validateAddRoles($instconfig)) {
		return $self->errorState();
	}
	if($isUseSha && ! $self->_validateHostagentPassword()) {
		return $self->errorState();
	}
	if(!$instconfig->isSkipped('AutoAddXS2Roles')){
		my $addHostPanel = $self->{addHostPanel};
		my $value = $addHostPanel->getWindowControls()->{AutoAddXS2Roles}->IsChecked() ? 1 : 0;
		if(!$instconfig->setValue('AutoAddXS2Roles', $value)){
			return $self->errorState();
		}
	}
	if (!$isUseSha && ! $self->_validateRootCredentials()) {
		return $self->errorState();
	}

	$self->GetWizard()->RefreshSkippableDialogs();
	return {};
}

sub _validateAddRoles {
	my ($self, $instconfig) = @_;
	my $hostsList = $self->{Controls}->{'HostsList'};
	my $numberOfItems = $hostsList->GetItemCount();

	if ( $numberOfItems == 0 ) {
		$instconfig->AddError("There must be at least one host to proceed!");
		$hostsList->SetFocus();
		return undef;
	}

	my $hasRoles = 0;
	my $addRoles = $self->_getAddRolesFromHostsListControl($hostsList);
	for my $host ( keys %$addRoles ){
		if ( ! $instconfig->setMapValueItem('AddRoles', $host, $addRoles->{$host}) ) {
			$hostsList->SetFocus();
			return undef;
		}
		$hasRoles = 1;
	}
	$instconfig->setSkip('AddRoles', !$hasRoles);
	
	return 1;
}

sub _handleAutoAddCheckBox {
	my ($self) = @_;
	my $addHostPanel = $self->{addHostPanel};
	my $addHostString = $self->{addHostPanel}->buildAddHostsOptionValue();
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	my $isAddingXsRole = ($addHostString =~ /:role=($gHostRoleXS2Standby|$gHostRoleXS2Worker)/);
	my $isInstallingXs2 = $self->_isXs2SelectedForInstall($instconfig);
	my $shouldDisable = $isAddingXsRole || ! $isInstallingXs2;
	my $value = $instconfig->hasValue('AutoAddXS2Roles') ? $instconfig->getValue('AutoAddXS2Roles') : 1;
	my $uiControl = $addHostPanel->getWindowControls()->{AutoAddXS2Roles};

	$uiControl->Enable($shouldDisable ? 0 : 1);
	$uiControl->SetValue($shouldDisable ? 0 : $value);
}

sub _isXs2SelectedForInstall {
	my ($self, $instconfig) = @_;
	my $componentManager = $instconfig->getComponentManager();
	my $xs2Component = $componentManager->getComponentByKeyName($gKeynameXS2);

	return defined($xs2Component) && $xs2Component->isComponentSelected() && !$xs2Component->isUpdate();
}

sub _getAddHostsFromHostsListControl {
	my ( $self, $hostsList ) = @_;
	my $numberOfHosts = $hostsList->GetItemCount();
	my $addHostsCommand = "";
	my %roles = ();

	for my $index (0 .. ($numberOfHosts-1)) {
		my $item = LCM::Gui::Dialogs::HostsPanel::GetListItem($self, $index);
		my ($host, $role) = ($item->{host}, $item->{role});

		next if exists $self->{existing_hosts}->{$host};

		my @hostRoles = split(",", $role);
		for ( @hostRoles ) {
			if ( exists $roles{$host} ) {
				push ( @ { $roles{$host} }, $_ );
			} else {
				$roles{$host} = [$_];
			}
		}
	}

	for my $index (0 .. ($numberOfHosts-1)) {
		my $item = LCM::Gui::Dialogs::HostsPanel::GetListItem($self, $index);

		next if ( exists $self->{existing_hosts}->{$item->{host}} );

		$addHostsCommand .= "," if ($addHostsCommand ne "");
		$self->_addHost($addHostsCommand, $item->{host});
		foreach my $role (@{$roles{$item->{host}}}){
			$self->_addRole($addHostsCommand, $role);
		}
		$self->_addGroup($addHostsCommand, $item->{group});
		$self->_addWorkerGroup($addHostsCommand, $item->{workergroup});
		$self->_addSP($addHostsCommand, $item->{storage_partition});
	}
	return $addHostsCommand;
}

sub _getAddRolesFromHostsListControl {
	my ( $self, $hostsList ) = @_;
	my $numberOfHosts = $hostsList->GetItemCount();
	my $addRoles = {};
	my %roles = ();

	for my $index (0 .. ($numberOfHosts-1)) {
		my $item = LCM::Gui::Dialogs::HostsPanel::GetListItem($self, $index);
		my ($host, $role) = ($item->{host}, $item->{role});

		next if ! exists $self->{existing_hosts}->{$host};

		my @existingRoles = split(',', $self->{existing_hosts}->{$host});
		my @hostRoles = split(",", $role);
		for ( @hostRoles ) {
			next if($_ ~~ @existingRoles);

			if ( exists $roles{$host} ) {
				push(@{$roles{$host}}, $_);
			} else {
				$roles{$host} = [$_];
			}
		}
	}

	for my $host ( keys %roles ) {
		$addRoles->{$host} = join( ',', @{$roles{$host}} );
	}

	return $addRoles;
}

1;
