package LCM::Gui::Dialogs::UpdateBootstrapParamsDialog;
use base qw (LCM::Gui::Dialogs::SAPDSignerVerificationDialog);
use warnings;
use strict;

use LCM::App::UpdateSystemUtils;
use LCM::ComponentManager::MediumComponentManager;
use SAPDB::Install::Control::PathCtrl;
use SDB::Install::Gui::Control::Label;
use SDB::Install::Globals qw ($gKeynameEngine $gProductNameEngine);
use SDB::Install::Gui::Design;
use Wx qw(wxVERTICAL wxALIGN_LEFT  wxEXPAND wxLEFT wxTOP wxALL wxALIGN_LEFT wxICON_EXCLAMATION wxOK wxCENTRE);

sub new {
    my $self = shift->SUPER::new(@_);
    $self->{id}   = 'UpdateBootstrapParamsDialog';
    $self->{name} = "Enter Installation Kit Path";
    return $self;
}

sub init {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    $instconfig->setBatchValueOfRequiredParams('VerifySignature');
    $self->_addInstallationKitPathUI();
    return {};
}

sub _addInstallationKitPathUI {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();

    my $mainSizer       = Wx::BoxSizer->new(wxVERTICAL);
    my $uiElementsSizer = Wx::BoxSizer->new(wxVERTICAL);

    my $captionText = "Specify the location of a new version of the $gProductNameEngine component";
    my $staticText = Wx::StaticText->new($self, -1, $captionText, [0,0], [-1,-1]);
    $staticText->SetFont(SDBFONT_DialogTitle) if (!Wx::wxGTK1());
    $uiElementsSizer->Add($staticText, 0, wxALIGN_LEFT | wxEXPAND | wxLEFT | wxTOP, 0);

    my $mcm = $instconfig->getComponentManager();
    my $hanaServer = $mcm ? $mcm->getComponentByKeyName($gKeynameEngine) : undef;
    my $serverPath = (defined $hanaServer) ? $hanaServer->getPath() : undef;

    my $pathControlLabel = SDB::Install::Gui::Control::Label->new($self, -1, "$gProductNameEngine Installation Kit Location", [-1, -1], [-1, -1]);
    $self->{installationKitPath} = SAPDB::Install::Control::PathCtrl->new($self, -1, $serverPath, [-1,-1], [-1,-1]);
    $uiElementsSizer->Add($pathControlLabel, 0, wxALIGN_LEFT | wxEXPAND | wxTOP, 20);
    $uiElementsSizer->Add($self->{installationKitPath}, 0, wxALIGN_LEFT | wxEXPAND | wxTOP, 5);
    if (defined $serverPath) {
        $self->{installationKitPath}->Enable(0);
    }

    my $shouldVerify = $instconfig->getBatchValue('VerifySignature') // $instconfig->getDefault('VerifySignature');
    $self->{verifyCheckbox} = Wx::CheckBox->new($self, -1, "Verify Authenticity of the Installation Kit", [-1,-1], [-1,-1]);
    $self->{verifyCheckbox}->SetValue($shouldVerify);
    $uiElementsSizer->Add($self->{verifyCheckbox}, 0, wxALIGN_LEFT | wxEXPAND | wxTOP, 15);

    $mainSizer->Add($uiElementsSizer, 1, wxALIGN_LEFT | wxEXPAND | wxALL, 20);

    $self->SetSizer($mainSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
}

sub Process {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    $instconfig->resetError();

    if ($self->{installationKitPath}->IsEnabled()) {
        my $pathValue = $self->{installationKitPath}->GetValue();
        if ($pathValue eq '') {
            $instconfig->getErrMsgLst()->addError("You must enter a valid path to an installation kit.");
            $self->showConfigurationErrors();
            $self->{installationKitPath}->SetFocus();
            return undef;
        }
        my $ignoreVersion = $instconfig->getIgnore('check_version');
        my $serverPath = getServerPathFromUserInput($pathValue, $instconfig->getErrMsgLst(), $ignoreVersion);
        if (!defined $serverPath) {
            $self->showConfigurationErrors();
            $self->{installationKitPath}->SetFocus();
            return undef;
        }
        if (!isPathToServerBinaries($serverPath)) {
            $serverPath = File::Spec->catfile($serverPath, 'server');
        }
        my $componentDirsValue = $instconfig->getValue('ComponentDirs') // '';
        my $concatValue = join(',', $serverPath, $componentDirsValue);
        if (!$instconfig->setValue('ComponentDirs', $concatValue)) {
            $self->showConfigurationErrors();
            return undef;
        }
    }
    my $shouldVerify = ($self->{verifyCheckbox}->GetValue()) ? 1 : 0;
    if (!$instconfig->setValue('VerifySignature', $shouldVerify)) {
        $self->showConfigurationErrors();
        return undef;
    }
    if (!$instconfig->setValue('SID', $instconfig->getDefault('SID'))) {
        # Only possible errors are those regarding verification and they
        # are shown via the SAPDSignerVerificationDialog API.
        return undef;
    }
    return {};
}

sub showConfigurationErrors {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();

    my $errors = $instconfig->GetErrorString();
    return if(!$errors);
    Wx::MessageBox($errors, "Configuration Error", wxOK | wxCENTRE | wxICON_EXCLAMATION, $self);
}

1;
