package LCM::Gui::Dialogs::XSPropertiesDialog;

use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gShortProductNameXS2 $gProductNameXS2);
use base qw(SAPDB::Install::Wizard::Dialog::Base);
use strict;
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD wxCB_READONLY wxDefaultPosition wxDefaultSize);

sub new{
	my($self) = shift->SUPER::new(@_);

	$self->{id} = 'XSProperties';
	$self->{label_text} = "Specify $gShortProductNameXS2 Properties";
	$self->{name} = "Define $gShortProductNameXS2 Properties";

	return $self;
}

sub init{
	my ($self,$config) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};
	$instconfig->setBatchValueOfRequiredParams('XSSpaceIsolation');

	my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
	my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
	my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);
    $instconfig->setDefault('XsDomainName', $instconfig->getDefaultXsControllerHost());

	$mainSizer->AddSpacer (20);
	$dialogTitle->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
	$mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
	$mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);

	if ($instconfig->getValue('UseSimpleUI')) {
		my $xsaAdmin = $instconfig->getValue('OrgManagerUser');
		$instconfig->{params}->{OrgManagerPassword}->{str} =~ s/Admin User (\(.*?\))?\s?/Admin User \($xsaAdmin\) /;
		$self->_addPasswordConfirmationControls('OrgManagerPassword', $gridSizer, $instconfig);
	} else {
		$self->_addParameterControls('XsEaDataPath', $gridSizer, $instconfig, 'string');
		$self->_addParameterControls('OrgManagerUser', $gridSizer, $instconfig, 'string');
		$self->_addPasswordConfirmationControls('OrgManagerPassword', $gridSizer, $instconfig);
		$self->_addParameterControls('OrgName', $gridSizer, $instconfig, 'string');
		$self->_addParameterControls('ProdSpaceName', $gridSizer, $instconfig, 'string');
		$self->_addRoutingModeControl($gridSizer, $instconfig);
		$self->_addParameterControls('XsDomainName', $gridSizer, $instconfig, 'string');
		$self->_addCheckBoxParameter('XSSpaceIsolation', $gridSizer, $instconfig);
	}

	$gridSizer->AddGrowableCol( 1 );
	$self->SetSizerAndFit($mainSizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	$self->Show(1);

	return {};
}

sub _addCheckBoxParameter {
	my ($self, $parameterName, $gridSizer, $instconfig) = @_;

	# Nothing to create if parameter is skipped, hidden or not existent
	return unless(exists($instconfig->{params}->{$parameterName}));
	return if($instconfig->isSkipped($parameterName));
	return if($instconfig->isHidden($parameterName));

	my $parameter = $instconfig->{params}->{$parameterName};
	my $parameterString = $parameter->{str};
	my $parameterValue = $instconfig->hasValue($parameterName) ? $instconfig->getValue($parameterName) : $instconfig->getDefault($parameterName);

	$parameterValue = 0 if (!defined $parameterValue);

	my $label = new Wx::StaticText($self, -1, '');
	my $inputControl = new Wx::CheckBox($self, -1, $parameterString, [-1,-1], [-1,-1]);
	$inputControl->SetFont (SDBFONT_NormalText) if(!Wx::wxGTK1());
	$inputControl->SetValue($parameterValue);
	$gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($inputControl, 1, wxEXPAND);
	$self->{_uiControls}->{"_${parameterName}Label"} = $label;
	$self->{_uiControls}->{"_${parameterName}Control"} = $inputControl;
}

sub _addPasswordConfirmationControls {
	my ($self, $parameterName, $gridSizer, $instconfig) = @_;

	# Nothing to create if parameter is skipped or not existent
	return unless(exists($instconfig->{params}->{$parameterName}));
	return if($instconfig->isSkipped($parameterName));
	return if($instconfig->isHidden($parameterName));

	my $parameter = $instconfig->{params}->{$parameterName};
	my $isMandatory = $parameter->{mandatory} ? 1 : 0;
	my $parameterValue = (defined $parameter->{value} ? $parameter->{value} : $instconfig->getDefault($parameterName));
	my $parameterString = $parameter->{str};
	$parameterValue = '' if(!defined($parameterValue));
	
	my $label = SDB::Install::Gui::Control::Label->new( $self, -1, $parameterString, $isMandatory);
	my $control = $self->_createUserInputControl('password', $parameterValue);
	$gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($control, 1, wxEXPAND  );
	$self->{_uiControls}->{"_${parameterName}Label"} = $label;
	$self->{_uiControls}->{"_${parameterName}Control"} = $control;

	if($self->_shouldConfirmPassword($parameterName, $instconfig)){
		my $confirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$parameterString Confirmation", $isMandatory);
		my $confirmationControl = $self->_createUserInputControl('password', $parameterValue);
		$gridSizer->Add($confirmationLabel,0, wxALIGN_CENTER_VERTICAL);
		$gridSizer->Add($confirmationControl, 1, wxEXPAND  );
		$self->{_uiControls}->{"_${parameterName}ConfirmationLabel"} = $confirmationLabel;
		$self->{_uiControls}->{"_${parameterName}ConfirmationControl"} = $confirmationControl;
	}
}

sub _addRoutingModeControl {
    my ($self, $sizer, $instconfig) = @_;

    # Nothing to create if parameter is skipped, hidden or not existent
    return unless(exists($instconfig->{params}->{RoutingMode}));
    return if($instconfig->isSkipped("RoutingMode"));
    return if($instconfig->isHidden("RoutingMode"));

    my $label = SDB::Install::Gui::Control::Label->new( $self, -1, "Routing mode", 1);
    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL);

    my $validValues = $instconfig->{params}->{RoutingMode}->{valid_values};
    my $uiValues = [];
    for ( 0 .. (@$validValues - 1) ) {
        my $text = $validValues->[$_] . " - " . $instconfig->{params}->{RoutingMode}->{ui_values}->[$_];
        push ( @{$uiValues}, $text);
    }
    
    my $comboBox = new Wx::ComboBox($self, -1, "", wxDefaultPosition, wxDefaultSize, $uiValues, wxCB_READONLY);
    my $currentValue = $instconfig->getValueOrBatchValue("RoutingMode");
    if (! defined $currentValue) {
        $currentValue = $instconfig->getDefault("RoutingMode");
    }
    my $selection = 0;
    for my $validValue (@{$instconfig->{params}->{RoutingMode}->{valid_values}}) {
        last if ($validValue eq $currentValue);
        $selection++;
    }
    $comboBox->SetSelection($selection);
    $sizer->Add($comboBox, 1, wxEXPAND);

    $self->{_uiControls}->{"_RoutingModeLabel"} = $label;
    $self->{_uiControls}->{"_RoutingModeControl"} = $comboBox;

}

sub _addParameterControls {
	my ($self, $parameterName, $gridSizer, $instconfig, $type) = @_;

	# Nothing to create if parameter is skipped, hidden or not existent
	return unless(exists($instconfig->{params}->{$parameterName}));
	return if($instconfig->isSkipped($parameterName));
	return if($instconfig->isHidden($parameterName));

	my $parameter = $instconfig->{params}->{$parameterName};
	my $parameterValue = (defined $parameter->{value} ? $parameter->{value} : $instconfig->getDefault($parameterName));
	my $isMandatory = $parameter->{mandatory} ? 1 : 0;
	my $parameterString = $parameter->{str};

	$parameterValue = '' if (!defined $parameterValue);

	my $label = SDB::Install::Gui::Control::Label->new($self, -1, $parameterString, $isMandatory);
	my $inputControl = $self->_createUserInputControl($type, $parameterValue);
	$label->SetToolTip ($parameter->{desc});
	$inputControl->SetToolTip($parameter->{desc});
	$gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($inputControl, 1, wxEXPAND  );
	$self->{_uiControls}->{"_${parameterName}Label"} = $label;
	$self->{_uiControls}->{"_${parameterName}Control"} = $inputControl;
}

sub Process {
	my ($self,) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	my $xsSpaceIsolationValue = $instconfig->getValueOrBatchValue('XSSpaceIsolation');
	my $shouldSetXSSpaceIsolation = $instconfig->getValue('UseSimpleUI') && !$instconfig->isSkipped('XSSpaceIsolation');

	$instconfig->resetError ();

	for my $parameterId ('XsEaDataPath', 'OrgName', 'OrgManagerUser', 'ProdSpaceName'){
		return undef if(!$self->_setParameter($app, $instconfig, $parameterId));
	}
	return undef if (!$self->_setPasswordParameter($app, $instconfig, 'OrgManagerPassword'));
	return undef if (!$self->_setBooleanParameter($app, $instconfig, 'XSSpaceIsolation'));
	return undef if(!$self->_setRoutingMode($app, $instconfig));
	return undef if(!$self->_setParameter($app, $instconfig, 'XsDomainName'));
	return undef if($shouldSetXSSpaceIsolation && !$instconfig->setValue('XSSpaceIsolation', $xsSpaceIsolationValue));
	# Since the controls for XSSpaceIsolation are hidden in the HXE
	# case don't set the value of XSSPaceIsolation on 'Next'. This
	# creates a back next issue possible if you go back to the select
	# components dialog where selecting XSA will unskip 'XSSpaceUserIdProd' and 'XSSpaceUserIdSAP'
	# that should always be skipped.

	$self->GetWizard()->RefreshSkippableDialogs();
	return {};
}

sub _setPasswordParameter {
	my ($self, $app, $instconfig, $parameterId) = @_;
	my $passwordControl = $self->{_uiControls}->{"_${parameterId}Control"};
	my $shouldConfirmPassword = $self->_shouldConfirmPassword($parameterId, $instconfig);
    my $passwordConfirmationControl = $self->{_uiControls}->{"_${parameterId}ConfirmationControl"};

	# Nothing to do if controls do not exist
	return 1 unless(defined($passwordControl) && (! $shouldConfirmPassword || defined($passwordConfirmationControl)));
	
	my $passwordValue = $passwordControl->GetValue();
	my $parameterString = $instconfig->{params}->{$parameterId}->{str};
	if(! $passwordValue) {
		$app->ShowErrorMsg( "$parameterString is empty" );
		$passwordControl->SetFocus();
		return undef;
	}

	if(! $instconfig->setValue($parameterId, $passwordValue)) {
		$app->ShowErrorMsg( "$parameterString value", $instconfig->getErrMsgLst() );
		$passwordControl->SetFocus();
		return undef;
	}

	if($shouldConfirmPassword){
		my $passwordConfirmationValue = $passwordConfirmationControl->GetValue();
		if($passwordValue ne $passwordConfirmationValue) {
			$app->ShowErrorMsg( "Password confirmation doesn't match for $parameterString" );
			$passwordControl->SetFocus();
			return undef;
		}
	}

	return 1;
}

sub _setBooleanParameter {
	my ($self, $app, $instconfig, $parameterId) = @_;
	my $parameterControl = $self->{_uiControls}->{"_${parameterId}Control"};

	# Nothing to do if controls do not exist
	return 1 unless(defined($parameterControl));

	my $value = $parameterControl->GetValue() ? 1 : 0;
	my $parameterString = $instconfig->{params}->{$parameterId}->{str};
	if(! $instconfig->setValue($parameterId, $value)) {
		$app->ShowErrorMsg( "$parameterString value", $instconfig->getErrMsgLst() );
		$parameterControl->SetFocus();
		return undef;
	}
	return 1;
}

sub _setParameter {
	my ($self, $app, $instconfig, $parameterId) = @_;
	my $parameterControl = $self->{_uiControls}->{"_${parameterId}Control"};
	
	# Nothing to do if controls do not exist
	return 1 unless(defined($parameterControl));
	
	my $value = $parameterControl->GetValue();
	my $parameterString = $instconfig->{params}->{$parameterId}->{str};
	if(! $value) {
        my $mandatory = $instconfig->{params}->{$parameterId}->{mandatory};
        return 1 if (!$mandatory);
		$app->ShowErrorMsg( "$parameterString is empty" );
		$parameterControl->SetFocus();
		return undef;
	}
	if(! $instconfig->setValue($parameterId, $value)) {
		$app->ShowErrorMsg( "$parameterString value", $instconfig->getErrMsgLst() );
		$parameterControl->SetFocus();
		return undef;
	}
	return 1;
}

sub _setRoutingMode {
    my ($self, $app, $instconfig) = @_;
    
    my $parameterControl = $self->{_uiControls}->{"_RoutingModeControl"};

    # Nothing to do if controls do not exist
    return 1 unless(defined($parameterControl));

    my $uiValue = $parameterControl->GetValue();

    my $value = $self->getRoutingModeByHumanReadableText($instconfig, $uiValue);
    if(! $instconfig->setValue('RoutingMode', $value)) {
        $app->ShowErrorMsg( "Routing mode value", $instconfig->getErrMsgLst() );
        return undef;
    }

    return 1;
}

sub getRoutingModeByHumanReadableText {
    my ($self, $instconfig, $value) = @_;

    my $values = $instconfig->{params}->{RoutingMode}->{valid_values};
    my $numberOfValues = scalar(@{$values});
    for my $i (0 .. $numberOfValues-1) {
        return $values->[$i] if (index($value, $values->[$i]) == 0);
    }
    return $value;
}

sub _shouldConfirmPassword {
	my ($self, $parameterName, $instconfig) = @_;
	return $instconfig->{params}->{$parameterName}->{type} eq 'initial_passwd';
}

sub _createUserInputControl {
	my ($self, $type, $value) = @_;
	if ($type eq 'password') {
		return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1], wxTE_PASSWORD);
	} else {
		return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1]);
	}
}

sub Back{
	my ($self) = @_;
	$self->Reset();
}

sub Reset{
	my ($self) = @_;

	if(defined $self->GetSizer()){
		$self->GetSizer->Clear (1);
	}
	delete($self->{_uiControls});
	$self->SUPER::Reset();
}

sub Destroy{
	my ($self) = @_;
	$self->Reset();
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;