#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: frame base class

package LCM::Gui::Frame;

use Wx qw (wxYES_NO wxCENTRE wxID_YES
    wxICON_QUESTION wxNO_DEFAULT wxBITMAP_TYPE_ICO_RESOURCE
    wxBITMAP_TYPE_ICO);

use Wx::Event qw (EVT_CLOSE);
use strict;
use SAPDB::Install::Resources;
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::Tools qw (callstack);

our @ISA = qw (Wx::Frame);

our $icon;

sub new {
    my( $class ) = shift;
    my( $self ) = $class->SUPER::new( undef, -1, @_ );

    if ($isWin){

        #
        # load icon from the executable file
        # TODO: load it as wxBITMAP_TYPE_ICO_RESOURCE from the resource db directly
        #

        if ($SAPDB::Install::Config{RuntimeDir}){
            my $appdir = $SAPDB::Install::Config{RuntimeDir};

            $appdir =~ s/[\\\/]+instruntime[\\\/]*$//;

            my $exe = "$appdir\\hdbsetup.exe";
            if (!-f $exe){
                $exe = "$appdir\\..\\bin\\hdblaunch.exe";
            }

            if (-f $exe){
                my $l = new Wx::LogNull(); # suppress error popup
                $icon = new Wx::Icon ($exe,wxBITMAP_TYPE_ICO);
            }
        }
        if (!defined $icon || !$icon->Ok()){
            $icon = Wx::Icon->new();
            $icon->CopyFromBitmap(Wx::Bitmap->new(SAPDB::Install::Resources->new()->
                getImages('icon/install.png')->{'icon/install.png'}));
        }
    }
    else{
        $icon = Wx::Icon->new();
        unless(Wx::wxX11){
            $icon->CopyFromBitmap(Wx::Bitmap->new(SAPDB::Install::Resources->new()->
                getImages('icon/install.png')->{'icon/install.png'}));
        }
    }

    # load an icon and set it as frame icon
    $self->SetIcon($icon);
    $self->{'IsBeingClosed'} = 0;
    EVT_CLOSE( $self, \&OnQuit );
    $self;
}


sub StartWizard {
    my ($self) = @_;
    if (defined $self->{wizard}){
        $self->{wizard}->initWizard ();
    }
    return 1;
}



sub OnQuit {
    my ($self,$event) = @_;

    unless ($event->CanVeto){
        $self->Destroy ();
        return;
    }

    my $title = $self->GetTitle;
    $title =~ s/\s*\[.*\].*//;
    my $msgbox = Wx::MessageDialog->new($self,
                "Do you really want to leave the $title?",
            "Exit?", wxYES_NO | wxNO_DEFAULT  | wxICON_QUESTION | wxCENTRE);
    if ( $msgbox->ShowModal() == wxID_YES){
        my $frames = callstack ();
        if(@$frames > 12){
            # not triggered by main loop (callback Wx::Yield())
            # abort current work by an exception
            die ('__SIGINT__');
        }
        $self->Destroy;
    }
    else{
        $event->Veto();
    }
}

1;
