package LCM::Gui::Frame::HdbLcmGuiFrame;

use strict;
use parent 'LCM::Gui::Frame';
use LCM::Gui::DialogUtilities;
use LCM::Gui::Wizard::GenericStackWizard;
use SDB::Install::Globals qw ($gProductNameInstaller);
use SDB::Install::Configuration qw($bool_true_pattern $bool_false_pattern);

sub new{
    my ($class, $application) = (shift(), shift());
    my $self = $class->SUPER::new($gProductNameInstaller, @_);
    my $wizard = new LCM::Gui::Wizard::GenericStackWizard ($self, -1);

    $self->_setWizard($wizard);
    $self->_setApplication($application);
    $application->setGUIWizard($wizard);

    return $self;
}

sub _getWizard {
    my ($self) = @_;
    return $self->{wizard};
}

sub _setWizard {
    my ($self, $wizard) = @_;
    $self->{wizard} = $wizard;
}

sub _getApplication{
    my ($self) = @_;
    return $self->{_application};
}

sub _setApplication{
    my ($self, $application) = @_;
    $self->{_application} = $application;
}

sub StartWizard {
    my ($self) = @_;
    my $wizard = $self->_getWizard();
    my $isInSimpleMode = $self->_isStartedInSimpleMode();

    if (defined($wizard)){
        $wizard->initWizard($isInSimpleMode);
    }
    return 1;
}

sub _isStartedInSimpleMode {
    my ($self) = @_;
    my $application = $self->_getApplication();
    my $configuration = $application->getInstconfig();
    my $actionConfiguration = $application->getActionConfiguration();
    my $targetConfiguration = defined($configuration) ? $configuration : $actionConfiguration;
    my $isInSimpleMode = ($targetConfiguration->getBatchValue('UseSimpleUI') =~ /$bool_true_pattern/);

    return $isInSimpleMode;
}

1;