package LCM::Gui::Wizard::GenericStackWizard;
use strict;

use base 'SDB::Install::Gui::Window::Wizard';
use LCM::Gui::Dialogs::SelectComponentSourceDialog;
use LCM::Gui::Dialogs::SelectActivityExternalDialog;
use LCM::Gui::Dialogs::SelectActivityInstalledDialog;

sub new {
    my $self = shift->SUPER::new (@_);
	$self->{dialogToSkipPredicate} = {};
    return $self;
}

sub initWizard{
    my ($self, $isInSimpleMode) = @_;
   
    my $installer = new LCM::Installer ();
	if ($installer->isInstalled()){
		$self->AddDialog (new LCM::Gui::Dialogs::SelectActivityInstalledDialog ($self));
	} else {
		$self->AddDialog (new LCM::Gui::Dialogs::SelectComponentSourceDialog ($self)) if(!$isInSimpleMode);
	    $self->AddDialog (new LCM::Gui::Dialogs::SelectActivityExternalDialog ($self));
	}
	
    $self->init ();
    $self->SkipDialog('finalize', 1);
}

sub InsertDialog {
	my ($self, $dlg, $id, $condensed_id, $shouldSkipPredicate) = @_;
	
	my $rc = $self->SUPER::InsertDialog($dlg, $id, $condensed_id);
	if (not $rc) {
		return $rc;
	}
	
	if (defined $shouldSkipPredicate) {
		$self->{dialogToSkipPredicate}->{$dlg->GetID()} = $shouldSkipPredicate;
	}
}

sub RemoveDialog{
    my ($self, $id) = @_;

    my $rc = $self->SUPER::RemoveDialog($id);
    if (not $rc) {
        return $rc;
    }

    delete ($self->{dialogToSkipPredicate}{$id});
    return 1;
}

sub RefreshSkippableDialogs {
	my $self = shift;
	
	for my $dialogId (keys %{$self->{dialogToSkipPredicate}}) {
		my $shallSkipDialog = $self->{dialogToSkipPredicate}->{$dialogId}->() ? 1 : 0;
		$self->SkipDialog($dialogId, $shallSkipDialog);
	}
 }

1;
