package LCM::Landscape::Cockpit::ManifestStub;

use parent 'SDB::Install::Manifest';
use SDB::Common::Utils qw(createXMLParser);
use SDB::Install::SysVars qw($currentPlatformName);
use SDB::Install::Globals qw($gKeynameCockpitStack);

my $DEFAULT_RELEASE = '2.0';
my $DEFAULT_SP_LEVEL = '0';
my $DEFAULT_PATCH_LEVEL = '0';

sub new {
    my ($class, $systemComponentManager) = (shift(), shift());
    my $self = $class->SUPER::new(@_);
    my $cockpitStack = defined($systemComponentManager) ? $systemComponentManager->getComponentByKeyName($gKeynameCockpitStack) : undef;
    my $cockpitStackManifest = defined($cockpitStack) ? $cockpitStack->getManifest() : undef;

    my $release = (defined($cockpitStackManifest) ? $cockpitStackManifest->getValue('release') : undef) || $DEFAULT_RELEASE;
    my $spLevel = (defined($cockpitStackManifest) ? $cockpitStackManifest->getValue('rev-number') : undef) || $DEFAULT_SP_LEVEL;
    my $patchLevel = (defined($cockpitStackManifest) ? $cockpitStackManifest->getValue('rev-patchlevel') : undef) || $DEFAULT_PATCH_LEVEL;

    $self->{data} = {
        'keyname'        => 'SAP_HANA_COCKPIT',
        'release'        => $release,
        'platform'       => $currentPlatformName,
        'keyvendor'      => 'sap.com',
        'sp-number'      => $spLevel,
        'keycaption'     => 'SAP HANA COCKPIT',
        'rev-number'     => $spLevel,
        'sp-patchlevel'  => $patchLevel,
        'rev-patchlevel' => $patchLevel,
    };

    return $self;
}

1;
