package LCM::Landscape::LMStructureManifest;

use base SDB::Install::Manifest;
use SDB::Install::Globals qw ($gKeynameLMStructure);
use strict;

use SDB::Install::SysVars qw($isWin $currentPlatformName);
use LCM::Component qw (COMPONENT_NAME_LM_STRUCTURE);

sub new{
	my $self = shift->SUPER::new ();	
	return $self;
}

sub read() {
	my $self = shift;
	my $platform = ($isWin) ? 'linuxx86_64' : $currentPlatformName ;
	my %data = (
		platform => $platform,
		'release' => '1.00',
		'rev-number' => '00',
		'rev-patchlevel' => '00',
		'rev-changelist' => '000000',
		'file' => 'virtual lm structure manifest',
		'compversion-id' => '121212121212121212121',
		'keyname' => $gKeynameLMStructure
	);
	$self->{data} = \%data;

	return $self->{data};
}

# this is fake
sub getCompId{
    return COMPONENT_NAME_LM_STRUCTURE();
}

sub isStudio{
	return 0;
}

sub isLMStructure{
	return 1;
}

sub isServer{
    return 0;
}

sub isClient{
    return 0;
}

sub isOfficeClient{
    return 0;
}

sub is64bit {
	return 1;
}

sub getVersion{
	my ($self) = @_;
	return "1.50.0";
}

sub checkComponentDependency{
	return 1;
}

sub checkComponentDependencyForParser{
    return 1;
}

1;
