package LCM::Landscape::LandscapeDescription;

use strict;
use parent 'SDB::Install::Base';
use LCM::Landscape::DescriptionXML;
use LCM::Landscape::DescriptionXSD;
use LCM::Landscape::Properties::CurrentStack;
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use LCM::ComponentManager::SystemComponentManager;
use LCM::Landscape::Properties::LandscapeVariables;

sub new {
	my ($class, $messageListContext, $sid, $preInitSapSystem) = @_;
	my $self = $class->SUPER::new();
	my $sapSystems = CollectSAPSystems(undef, 1); # no cache
	my $ownSapSystem = defined($preInitSapSystem) ? $preInitSapSystem : $sapSystems->{$sid};

	$self->setMsgLstContext($messageListContext) if(defined($messageListContext));
	if(!defined($ownSapSystem)){
		$self->getErrMsgLst()->addError("No SAP system '$sid' found");
		return $self;
	}

	my $componentManager = new LCM::ComponentManager::SystemComponentManager();
	my $landscapeDescriptionXsd = new LCM::Landscape::DescriptionXSD($messageListContext);
	my $landscapeDescriptionXml = new LCM::Landscape::DescriptionXML($messageListContext, $ownSapSystem,1,1);
	my $landscapeVariablesProperties = new LCM::Landscape::Properties::LandscapeVariables($messageListContext, $ownSapSystem);
	my $installationPath = $landscapeVariablesProperties->getLandscapeInstallationPath();

	$componentManager->detectComponentsBySapmntSid($installationPath, $ownSapSystem->get_sid());

	my $currentStackProperties = new LCM::Landscape::Properties::CurrentStack($componentManager, $messageListContext, $ownSapSystem);

	$landscapeDescriptionXsd->setMsgLstContext($self->getMsgLstContext());
	$landscapeDescriptionXml->setMsgLstContext($self->getMsgLstContext());
	$currentStackProperties->setMsgLstContext($self->getMsgLstContext());
	$landscapeVariablesProperties->setMsgLstContext($self->getMsgLstContext());

	$self->_setSid($sid);
	$self->_setLandscapeDescriptionXML($landscapeDescriptionXml);
	$self->_setLandscapeDescriptionXSD($landscapeDescriptionXsd);
	$self->_setCurrentStackProperties($currentStackProperties);
	$self->_setLandscapeVariablesProperties($landscapeVariablesProperties);

	return $self;
}

sub store {
	my ($self) = @_;
	my $sid = $self->_getSid();
	my $landscapeDescriptionXml = $self->_getLandscapeDescriptionXML();
	my $landscapeDescriptionXsd = $self->_getLandscapeDescriptionXSD();
	my $currentStackProperties = $self->_getCurrentStackProperties();
	my $landscapeVariablesProperties = $self->_getLandscapeVariablesProperties();
	my $installationPath = $landscapeVariablesProperties->getLandscapeInstallationPath();
	my $targetDirectory = File::Spec->catfile($installationPath, $sid, 'lm_structure');

	return undef if(!$landscapeDescriptionXml->store($sid, $targetDirectory));
	return undef if(!$currentStackProperties->store($sid, $targetDirectory));
	return undef if(!$landscapeVariablesProperties->store($sid, $targetDirectory));
	return undef if(!$landscapeDescriptionXsd->store($sid, $targetDirectory));

	return 1;
}

sub _getSid {
	my ($self) = @_;
	return $self->{_sid};
}

sub _setSid {
	my ($self, $sid) = @_;
	$self->{_sid} = $sid;
}

sub _getLandscapeDescriptionXML {
	my ($self) = @_;
	return $self->{_landscapeDescriptionXML};
}

sub _getLandscapeDescriptionXSD {
	my ($self) = @_;
	return $self->{_landscapeDescriptionXSD};
}

sub _getCurrentStackProperties {
	my ($self) = @_;
	return $self->{_currentStackProperties};
}

sub _getLandscapeVariablesProperties {
	my ($self) = @_;
	return $self->{_landscapeVariablesProperties};
}

sub _setLandscapeDescriptionXML {
	my ($self, $landscapeDescriptionXML) = @_;
	$self->{_landscapeDescriptionXML} = $landscapeDescriptionXML;
}

sub _setLandscapeDescriptionXSD {
	my ($self, $landscapeDescriptionXSD) = @_;
	$self->{_landscapeDescriptionXSD} = $landscapeDescriptionXSD;
}

sub _setCurrentStackProperties {
	my ($self, $currentStackProperties) = @_;
	$self->{_currentStackProperties} = $currentStackProperties;
}

sub _setLandscapeVariablesProperties {
	my ($self, $landscapeVariablesProperties) = @_;
	$self->{_landscapeVariablesProperties} = $landscapeVariablesProperties;
}

1;