package LCM::Landscape::PDXmlDetector;

use strict;
use File::Spec;
use base qw(Exporter);
use experimental qw (smartmatch);

our @EXPORT_OK = qw(getListOfComponentDirs);

my @SKIP_LIST = ('.', '..', 'afl');

sub getListOfComponentDirs {
	my ($rootDir, $context) = @_;
	my $dirHandle;
	if (!opendir($dirHandle, $rootDir)){
		return [];
	}
	my @subdirs = readdir($dirHandle);
	closedir ($dirHandle);
	my $list = [];
	
	for my $dir(@subdirs){
		next if($dir ~~ @SKIP_LIST);
		my $pdXmlPath = File::Spec->catfile($rootDir, $dir, 'PD.XML');
		if(-r $pdXmlPath){
			my $path = File::Spec->catdir($rootDir, $dir);
			push @$list, $path;
			_addMessageFound($context, $path);
		}
	}
	return $list;
}

sub _addMessageFound {
	my ($context, $path) = @_;
	if($context){
		$context->getMsgLst()->addMessage("Found component PD.XML in directory '$path'");
	}
}

1;
