package LCM::Landscape::Properties::CurrentStack;

use strict;
use parent 'LCM::Landscape::Properties';
use LCM::Landscape::PDXml;

my $PROPERTY_MODELS = [{
		getter => 'getStackId',
		template => 'stackID=%s',
		regex => '^stackID\s*=',
		comment => [],
	}, {
		getter => 'getStackCaption',
		template => 'stackCaption=%s',
		regex => '^stackCaption\s*=',
		comment => [],
	}, {
		getter => 'getStackReleaseDate',
		template => 'stackReleaseDate=%s',
		regex => '^stackReleaseDate\s*=',
		comment => [],
	}, {
		getter => 'getStackInstallDate',
		template => 'stackInstallDateTime=%s',
		regex => '^stackInstallDateTime\s*=',
		comment => [],
	},
];
my $STACK_PROPERTIES_FILE = 'currentStack.properties';

####
# TODO - check what's happening with releaseDate & installDateTime
####

sub new {
	my ($class, $componentManager, $messageListContext, $sapSystem, $releaseDate, $installDateTime) = @_;
	my $self = $class->SUPER::new();
	my $manifestDir = $sapSystem->getManifestDir();
	my $pdXml = new LCM::Landscape::PDXml($componentManager, $manifestDir, $self);
	my $product = $pdXml->getProduct();

	$self->setMsgLstContext($messageListContext) if(defined($messageListContext));
	$self->_setStackId($product->getStackId());
	$self->_setStackCaption($product->getStackName());
	$self->_setStackReleaseDate($releaseDate || '');
	$self->_setStackInstallDate($installDateTime || '');

	return $self;
}

sub getStackId {
	my ($self) = @_;
	return $self->{_stackId};
}

sub getStackCaption {
	my ($self) = @_;
	return $self->{_stackCaption};
}

sub getStackReleaseDate {
	my ($self) = @_;
	return $self->{_stackReleaseDate};
}

sub getStackInstallDate {
	my ($self) = @_;
	return $self->{_stackInstallDate};
}

sub _setStackId {
	my ($self, $stackId) = @_;
	$self->{_stackId} = $stackId;
}

sub _setStackCaption {
	my ($self, $stackCaption) = @_;
	$self->{_stackCaption} = $stackCaption;
}

sub _setStackReleaseDate {
	my ($self, $stackReleaseDate) = @_;
	$self->{_stackReleaseDate} = $stackReleaseDate;
}

sub _setStackInstallDate {
	my ($self, $stackInstallDate) = @_;
	$self->{_stackInstallDate} = $stackInstallDate;
}

# Override
sub _getPopertiesFileName {
	return $STACK_PROPERTIES_FILE;
}

# Override
sub _getPropertyModels {
	return $PROPERTY_MODELS;
}

1;