package LCM::Manifests::XS2ApplicationManifest;

use strict;
use LCM::Utils::SlManifestXmlParser;
use parent 'SDB::Install::Manifest';

my $XS_RUNTIME_TYPE = 'XSART';

sub new {
	my ($class, $archivePath) = @_;
	my $self = $class->SUPER::new();
	$self->_setArchivePath($archivePath);
	$self->read($archivePath);
	return $self;
}

sub _getArchivePath {
	my ($self) = @_;
	return $self->{_archivePath};
}

sub _setArchivePath {
	my ($self, $path) = @_;
	$self->{_archivePath} = $path;
}

#Override
sub read {
	my ($self, $archivePath, $noCache) = @_;

	if($noCache || !defined($self->{data})){
		my $parser = new LCM::Utils::SlManifestXmlParser();
		my $path = $archivePath || $self->_getArchivePath();
		eval {
			$self->{data} = $parser->getParsedData($path);
		};
		my $errorMessage = "Error parsing SL_MANIFEST.XML in archive $path";
		if($@) {
			$self->setErrorMessage("$errorMessage: $@");
			return undef;
		}
		if(! defined($self->{data})) {
			$self->setErrorMessage($errorMessage);
			return undef;
		}
	}
	return $self->{data};
}

#Override
sub getVersion {
	my ($self) = @_;

	if ( ! $self->{version} ) {
		my $release = $self->getValue('release');
		my $revNumber = $self->getValue('rev-number');
		my $revPatchLevel = $self->getValue('rev-patchlevel');
		$self->{version} = join('.', $release, $revNumber, $revPatchLevel);
	}
	return $self->{version};
}

#Override
sub isXS2Application {
	my ($self) = @_;
	return $self->getValue('runtime-type') eq $XS_RUNTIME_TYPE;
}

# Override
sub isCustomerReleaseBranch { return 1; }

# Override
sub getFileName {
    return $_[0]->_getArchivePath();
}

# Override
sub checkComponentDependency {
	my ($self, $targetSet) = @_;
	my $dependencies = $self->getValue('dependencies-array');
	my $missingDependenciesSets = [];

	return (1, '') if(scalar(@{$dependencies}) == 0);

	for my $dependencyArray (@{$dependencies}){
		my $missingDependencies = [];
		my $isSuccess = 1;
		for my $dependencyObject (@{$dependencyArray}){
			if(!$dependencyObject->isSatisfied($targetSet)){
				$isSuccess = 0;
				push(@{$missingDependencies}, $dependencyObject);
			}
		}
		return (1, '') if($isSuccess);
		push(@{$missingDependenciesSets}, $missingDependencies)
	}
	return (0, $self->_constructErrorMessage($missingDependenciesSets));
}

sub _constructErrorMessage {
	my ($self, $missingDependenciesSets) = @_;
	my $name = $self->getValue('keycaption');

	if(scalar(@{$missingDependenciesSets}) == 1 && scalar(@{$missingDependenciesSets->[0]}) == 1){
		my $dependencyObject = $missingDependenciesSets->[0]->[0];
		return sprintf("Selected component '%s' requires '%s'", $name, $dependencyObject->toString());
	}

	if(scalar(@{$missingDependenciesSets}) == 1){
		my $errorString = sprintf("Selected component '%s' requires the following components:\n", $name);
		$errorString .= "    " . join("\n    ", map { $_->toString() } @{$missingDependenciesSets->[0]});
		return $errorString;
	}

	my $errorString = sprintf("Selected component '%s' requires one of the following set of components:\n", $name);
	for(my $index = 0; $index < scalar(@{$missingDependenciesSets}); $index++){
		$errorString .= "    " . join("\n    ", map { $_->toString() } @{$missingDependenciesSets->[$index]});

		if($index + 1 < scalar(@{$missingDependenciesSets})){
			$errorString .= "\n\n";
		}
	}
	return $errorString;
}

# Override
sub checkSPSUpgradeLimitation { return 1; }

# Override
sub getSupportedPhases { return []; }

1;
