package LCM::NotApplicableActions;

sub new {
    my ($class) = @_;
    my $self = { 
        "sidadm" => {},
        "win" => {},
        "root" => {},
    };
    bless $self, $class;
    return $self;
}

sub add {
    my ($self, $reason, $action, $message) = @_;
    if ( exists $self->{$reason} ) {
        $self->{$reason}->{$action} = $message;
    }
    return 1;
}

sub getMessage {
    my ($self, ) = @_;
    
    my $message = "The following actions cannot be selected because the tool was not started as %s user:";
    my $rootMessage = sprintf($message, "root");
    my $sidadmMessage = sprintf($message, "sidadm");
    
    my $winMessage = "The following actions cannot be selected because they are not available under Windows:";
    
    my $notApplicableActionsMessage = "";
    my $whiteSpace = " " x 3;
    my $winActions = "";
    if ( %{$self->{win}} ) {
        $winActions = join ("\n$whiteSpace - ", values %{$self->{win}}); 
        $notApplicableActionsMessage .= "$winMessage\n$whiteSpace - $winActions\n\n" if (defined $winActions);
    }

    my $rootActions = "";
    if ( %{$self->{root}} ) {
        $rootActions = join ("\n$whiteSpace - ", values %{$self->{root}}); 
        $notApplicableActionsMessage .= "$rootMessage\n$whiteSpace - $rootActions\n\n" if (defined $rootActions);
    }

    my $sidadmActions = "";
    if ( %{$self->{sidadm}} ) {
        $sidadmActions = join ("\n$whiteSpace - ", values %{$self->{sidadm}}); 
        $notApplicableActionsMessage .= "$sidadmMessage\n$whiteSpace - $sidadmActions\n\n" if (defined $sidadmActions);
    }
    
    return $notApplicableActionsMessage;
}

1;