package LCM::PostExecuteAction::RegenerateCertificates;

use strict;
use base qw(LCM::PostExecuteAction);

my $STATUS_OK = 1;
my $STATUS_ERROR = 0;

sub new {
	my ($class, $logHandler, $instconfig, $keystorePassword, $shouldFailOnError) = @_;

	my $self = {};
	
	bless $self, $class;
	
	$self->{_shouldFailOnError} = $shouldFailOnError;
	$self->_setKeystorePassword($keystorePassword);
	$self->_setLogHandler($logHandler);
	$self->_setInstconfig($instconfig);
	return $self;
}

sub _setKeystorePassword {
	$_[0]->{_keystorePassword} = $_[1];
}

sub _getKeystorePassword {
	return $_[0]->{_keystorePassword};
}

sub _addOutputFromExternalProcess {
	my ($self, $msgContainer, $returnCode) = @_;

	# Kind of an ugly hack - external process output might come via
	# LCM::ProcessExecutor or SDB::Install::RemoteHosts object.
	# They have rather different behaviour when in comes to logging,
	# so in order to handle them both I've written this. (i302705)
	
	if(defined $returnCode && $returnCode == 0){
		$self->_getLogHandler()->getMsgLst()->appendMsgLst ( $msgContainer->getMsgLst());
	}
	if ($self->shouldFailOnError()){
		$self->_getLogHandler()->getErrMsgLst()->appendMsgLst ( $msgContainer->getErrMsgLst());
	} else {
		$self->_getLogHandler()->getMsgLst()->addWarning(undef, $msgContainer->getErrMsgLst());
	}
	$msgContainer->resetMsgLstContext();
}

sub _addWarningMessage {
	my ($self, $message) = @_;
	$self->_getLogHandler()->getMsgLst()->addWarning($message);
}

sub addMessage {
	my ($self, $message) = @_;
    $self->_getLogHandler()->getMsgLst()->addMessage($message);
}

sub shouldFailOnError {
	return $_[0]->{_shouldFailOnError};
}

sub isStatusOK {
	my ($self, $status) = @_;
	return $status == $STATUS_OK;
}

sub _setInstconfig {
	$_[0]->{_instconfig} = $_[1];
}

sub _getInstconfig {
	return $_[0]->{_instconfig};
}

sub _setLogHandler {
	$_[0]->{_logHandler} = $_[1];
}

sub _getLogHandler {
	return $_[0]->{_logHandler};
}

sub _prepareMessageHandling {
	my ($self, $logHandler, $progressMessage) = @_;
	
	my $message = $logHandler->getMsgLst ()->addProgressMessage ($progressMessage);
	my $saveContext = $logHandler->setMsgLstContext([$message->getSubMsgLst()]);
	
	$self->{_message} = $message; 
	$self->{_saveContext} = $saveContext; 
}

sub _finalizeMessageHandling {
	my ($self, $status) = @_;

	$self->{_message}->endMessage (undef, $self->_getEndMessage($status));
	$self->_getLogHandler()->setMsgLstContext($self->{_saveContext});
}

1;