package LCM::Python::SLDReconfigurationHelper;

use base qw(LCM::Python::HanaPropertiesHelper);
use SDB::Install::SysVars qw($isWin);
use LCM::Installer;
use strict;

my $RECONFIGURATION_FAILED = 'Reconfiguration of SLD failed; check if HDB is up and running';

my $RECOFNIGURE_SLD_SCRIPT = <<EOF;
import NameServerPy
import ServiceClientPy
def reconfig():
\tNameServerPy.init()
\tns=NameServerPy.TNSClient()
\tmaster=ns.getValue('/globals/active_master')
\trs=ServiceClientPy.RemoteService(master)
\treturn rs.reconfig()
if __name__=="__main__":
\tprint('reconfigure SLD finished with code "{0}"'.format(reconfig()))
EOF

sub reconfigureSLD {
	my ($self, $uid, $gid) = @_;
	my $args = [];
	return  $self->_executePythonCommand($RECOFNIGURE_SLD_SCRIPT, $RECONFIGURATION_FAILED, $args, $uid, $gid);
}

sub setLmStructurePath
{
    my ($self, $sid, $sharedLmStructurePath, $msgLst, $errMsgLst) = @_;
    my ($uid, $gid) = $self->getPermissions($sid);
    my $result;
    
    $msgLst->AddMessage("Set global property: lmStructurePath...");
    $result = $self->setGlobalProperty('nameserver.ini', 'sld', 'lmStructurePath', $sharedLmStructurePath, $uid, $gid);
    $msgLst->addMessage(undef, $self->getMsgLst());
    if(!defined($result)) {
        $errMsgLst->addMessage(undef, $self->getErrMsgLst());
        return undef;
    }
    return 1;
}

sub isSldEnabled
{
    my ($self, $sid, $msgLst, $errMsgLst) = @_;
    my ($uid, $gid) = $self->getPermissions($sid);
    
    $msgLst->AddMessage("Checking for enabled SLD on SID $sid...");
    my $result = $self->getGlobalProperty('nameserver.ini', 'sld', 'enable', $uid, $gid);    
    $msgLst->addMessage(undef, $self->getMsgLst());
    if(!defined($result)) {
        $errMsgLst->addMessage(undef, $self->getErrMsgLst());
        return undef;
    }
    return $result eq 'yes';
}

1;