package LCM::ResidentInstallerManifest;

use base SDB::Install::Manifest;
use SDB::Install::Globals qw ($gKeynameInstaller);
use strict;

sub read{
    my $self = shift;
    my $rc = $self->SUPER::read (@_);
    if (defined $rc && !defined $rc->{'compversion-id'}){
        $rc->{'compversion-id'} = 'LcmResidentInstaller';
    }
    if (defined $rc && !defined $rc->{'keyname'}){
        $rc->{'keyname'} = $gKeynameInstaller;
    }    
    return $rc;
}

sub is64bit {
    return 1;
}

sub _checkInternalBuild {
    my ($self, $manifest) = @_;
    if ($manifest->isServer && $manifest->isInternalBuild) {
        return 1;
    }
    return 0;
}

sub checkComponentDependency{
    my ($self, $manifest, $ownProductName) = @_;

    return 1 if ($self->_checkInternalBuild($manifest));
    return $self->SUPER::checkComponentDependency($manifest, $ownProductName);
}

sub checkComponentDependencyForParser{
    my ($self, $manifest, $ownProductName, $parser) = @_;

    return 1 if ($self->_checkInternalBuild($manifest));
    return $self->SUPER::checkComponentDependencyForParser($manifest, $ownProductName, $parser);
}

1;
