package LCM::SHA::DeploymentStrategy;

use strict;
use File::Basename;
use base qw(SDB::Install::BaseLegacy);
use SDB::Install::SAPHostControl;
use SDB::Install::SysVars qw ($path_separator);

sub new {
	my ($class, $username, $password, $isUseHttp, $sso_cert) = @_;
	my $self = {
		_username => $username,
		_password => $password,
		_isUseHttp => $isUseHttp,
		_sso_cert => $sso_cert
	};
	return bless($self, $class);
}

sub getUsername {
	return $_[0]->{_username};
}

sub getPassword {
	return $_[0]->{_password};
}

sub isUseHttp {
	return $_[0]->{_isUseHttp};
}

sub getSSOCert {
	return $_[0]->{_sso_cert};
}

sub isCockpitInMasterSignature{
    my ($self, $signature_buff) = @_;
    foreach (@$signature_buff){
        if(/hdbcockpit/){
            return 1;
        }
    }
    return 0;
}

sub getCockpitSignatureFile{
    my ($self, $path_to_master_signature) = @_;
    my $signatureDir = dirname ($path_to_master_signature);
    my $pathToCockpitSignatureManifest = $signatureDir . $path_separator . 'HDBCOCKPIT.SMF';
    if (-f $pathToCockpitSignatureManifest){
       return $pathToCockpitSignatureManifest;
    }
    $self->getMsgLst()->addWarning ("No HANA Offline Cockpit signature found! ($pathToCockpitSignatureManifest)");
    return undef;
}

sub initialize { return 1; }

# 1 stands for succes
# undef stands for failure
sub deploy {
	my ($self, $host, $isLocal) = @_;
	if (!defined $isLocal){
		$isLocal = 0;
	}
	my $useUDS = $isLocal && ($> == 0);
	my $infoMessage = $self->getMsgLst()->AddMessage("Deploying SAP Host Agent configurations on host '$host'...");
    my $hostctrl = new SDB::Install::SAPHostControl($useUDS ? undef : $host, $self->getUsername(), $self->getPassword(), $self->isUseHttp(), $self->getSSOCert(), $host);
	my $result = $self->_deployOnHost($hostctrl);
	my $rc = 1;
	$self->getMsgLst()->AddSubMsgLst($infoMessage, $hostctrl->getMsgLst());
	if (! $self->_isCorrectFormat($result)) {
		my $errorInfo = "Deployment of SAP Host Agent configurations failed on host '$host'" . $self->_getFaultMessage($result);
		if($hostctrl->errorState()){
			$self->getMsgLst()->AddSubMsgLst($infoMessage, $hostctrl->getErrMsgLst ());
		}
		$self->getMsgLst()->AddWarning($errorInfo);
		$rc = undef;
	} else {
		$self->getMsgLst()->AddMessage("Successfully deployed SAP Host Agent configurations on host '$host'");
	}
	if ($self->_shallDeployCockpit){
		my $msg = $self->getMsgLst()->addMessage("Deploying SAP Host Agent configurations for Offline Cockpit on host '$host'...");
		$hostctrl->setMsgLstContext ([$msg->getSubMsgLst()]);
		$result = $self->_deployCockpitOnHost ($hostctrl);
			if (! $self->_isCorrectFormat($result)) {
			my $errorInfo = "Deployment of SAP Host Agent configurations for Offline Cockpit failed on host '$host'" . $self->_getFaultMessage($result);
			$self->getMsgLst()->AddWarning($errorInfo);
			$rc = undef;
		} else {
			$self->getMsgLst()->AddMessage("Successfully deployed SAP Host Agent configurations for Offline Cockpit on host '$host'");
		}
	}

	return $rc;
}

sub cleanup { return 1 }

sub _deployOnHost { return 0; }

sub _isCorrectFormat {
	my ($self, $result) = @_;

	return undef if(! defined($result));
	return undef if(ref($result) ne 'HASH');
	return undef if(exists($result->{faultstring}));
	return undef if(exists($result->{faultcode}));
	
	return 1;
}

sub _getFaultMessage {
	my ($self, $result) = @_;
	if(ref($result) eq 'HASH'){
		return ": " . $result->{faultstring} . ", " . $result->{faultcode};
	}
	return '';
}

sub _shallDeployCockpit{
    return 0;
}

1;